/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.tools.ImageTransform.Transforms;

import icy.image.IcyBufferedImage;
import icy.type.collection.array.Array1DUtil;
import java.awt.Color;
import plugins.fmp.multicafe.tools.ImageTransform.ImageTransformFunctionAbstract;
import plugins.fmp.multicafe.tools.ImageTransform.ImageTransformInterface;
import plugins.fmp.multicafe.tools.ImageTransform.ImageTransformOptions;

public class RGBtoHSB
extends ImageTransformFunctionAbstract
implements ImageTransformInterface {
    int channelOut = 0;

    public RGBtoHSB(int channelOut) {
        this.channelOut = channelOut;
    }

    @Override
    public IcyBufferedImage getTransformedImage(IcyBufferedImage sourceImage, ImageTransformOptions options) {
        IcyBufferedImage img = this.functionRGBtoHSB(sourceImage);
        if (this.channelOut >= 0) {
            img = this.functionRGB_keepOneChan(img, this.channelOut);
        }
        return img;
    }

    protected IcyBufferedImage functionRGBtoHSB(IcyBufferedImage sourceImage) {
        IcyBufferedImage img2 = new IcyBufferedImage(sourceImage.getWidth(), sourceImage.getHeight(), 3, sourceImage.getDataType_());
        float[] tabValuesR = Array1DUtil.arrayToFloatArray((Object)sourceImage.getDataXY(0), (boolean)sourceImage.isSignedDataType());
        float[] tabValuesG = Array1DUtil.arrayToFloatArray((Object)sourceImage.getDataXY(1), (boolean)sourceImage.isSignedDataType());
        float[] tabValuesB = Array1DUtil.arrayToFloatArray((Object)sourceImage.getDataXY(2), (boolean)sourceImage.isSignedDataType());
        float[] outValues0 = Array1DUtil.arrayToFloatArray((Object)img2.getDataXY(0), (boolean)img2.isSignedDataType());
        float[] outValues1 = Array1DUtil.arrayToFloatArray((Object)img2.getDataXY(1), (boolean)img2.isSignedDataType());
        float[] outValues2 = Array1DUtil.arrayToFloatArray((Object)img2.getDataXY(2), (boolean)img2.isSignedDataType());
        for (int ky = 0; ky < tabValuesR.length; ++ky) {
            int R = (int)tabValuesR[ky];
            int G = (int)tabValuesG[ky];
            int B = (int)tabValuesB[ky];
            float[] hsb = Color.RGBtoHSB(R, G, B, null);
            outValues0[ky] = hsb[0] * 100.0f;
            outValues1[ky] = hsb[1] * 100.0f;
            outValues2[ky] = hsb[2] * 100.0f;
        }
        int c = 0;
        Array1DUtil.floatArrayToSafeArray((float[])outValues0, (Object)img2.getDataXY(c), (boolean)false);
        img2.setDataXY(c, img2.getDataXY(c));
        Array1DUtil.floatArrayToSafeArray((float[])outValues1, (Object)img2.getDataXY(++c), (boolean)false);
        img2.setDataXY(c, img2.getDataXY(c));
        Array1DUtil.floatArrayToSafeArray((float[])outValues2, (Object)img2.getDataXY(++c), (boolean)false);
        img2.setDataXY(c, img2.getDataXY(c));
        return img2;
    }
}

