/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.tools.JComponents;

import javax.swing.table.AbstractTableModel;
import plugins.fmp.multicafe.experiment.Experiment;
import plugins.fmp.multicafe.experiment.capillaries.Capillary;
import plugins.fmp.multicafe.tools.JComponents.ExperimentsJComboBox;

public class CapillaryTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 6325792669154093747L;
    private ExperimentsJComboBox expList = null;
    String[] columnNames = new String[]{"Name", "Cage", "N flies", "Volume", "Stimulus", "Concentration"};

    public CapillaryTableModel(ExperimentsJComboBox expList) {
        this.expList = expList;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Integer.class;
            }
            case 2: {
                return Integer.class;
            }
            case 3: {
                return Double.class;
            }
            case 4: {
                return String.class;
            }
            case 5: {
                return String.class;
            }
        }
        return String.class;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public int getRowCount() {
        if (this.expList != null && this.expList.getSelectedIndex() >= 0) {
            Experiment exp = (Experiment)this.expList.getSelectedItem();
            return exp.capillaries.capillariesList.size();
        }
        return 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Capillary cap = this.getCapillaryAt(rowIndex);
        if (cap != null) {
            switch (columnIndex) {
                case 0: {
                    return cap.getRoiName();
                }
                case 1: {
                    return cap.capCageID;
                }
                case 2: {
                    return cap.capNFlies;
                }
                case 3: {
                    return cap.capVolume;
                }
                case 4: {
                    return cap.capStimulus;
                }
                case 5: {
                    return cap.capConcentration;
                }
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return false;
            }
        }
        return true;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Capillary cap = this.getCapillaryAt(rowIndex);
        if (cap != null) {
            switch (columnIndex) {
                case 0: {
                    cap.setRoiName(aValue.toString());
                    break;
                }
                case 1: {
                    cap.capCageID = (Integer)aValue;
                    break;
                }
                case 2: {
                    cap.capNFlies = (Integer)aValue;
                    break;
                }
                case 3: {
                    cap.capVolume = (Double)aValue;
                    break;
                }
                case 4: {
                    cap.capStimulus = aValue.toString();
                    break;
                }
                case 5: {
                    cap.capConcentration = aValue.toString();
                }
            }
        }
    }

    private Capillary getCapillaryAt(int rowIndex) {
        Capillary cap = null;
        if (this.expList != null && this.expList.getSelectedIndex() >= 0) {
            Experiment exp = (Experiment)this.expList.getSelectedItem();
            cap = exp.capillaries.capillariesList.get(rowIndex);
        }
        return cap;
    }
}

