/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.tools.toExcel;

import icy.gui.frame.progress.ProgressFrame;
import java.awt.Point;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import plugins.fmp.multicafe.experiment.CombinedExperiment;
import plugins.fmp.multicafe.experiment.Experiment;
import plugins.fmp.multicafe.experiment.cages.Cage;
import plugins.fmp.multicafe.experiment.capillaries.Capillary;
import plugins.fmp.multicafe.tools.toExcel.EnumXLSColumnHeader;
import plugins.fmp.multicafe.tools.toExcel.EnumXLSExport;
import plugins.fmp.multicafe.tools.toExcel.XLSExport;
import plugins.fmp.multicafe.tools.toExcel.XLSExportOptions;
import plugins.fmp.multicafe.tools.toExcel.XLSResults;
import plugins.fmp.multicafe.tools.toExcel.XLSResultsArray;
import plugins.fmp.multicafe.tools.toExcel.XLSResultsFromCapillaries;
import plugins.fmp.multicafe.tools.toExcel.XLSUtils;

public class XLSExportCapillariesResults
extends XLSExport {
    public void exportToFile(String filename, XLSExportOptions opt) {
        System.out.println("XLSExpoportCapillaries:exportToFile() - start output");
        this.options = opt;
        this.expList = this.options.expList;
        boolean loadCapillaries = true;
        boolean loadDrosoTrack = this.options.onlyalive;
        this.expList.loadListOfMeasuresFromAllExperiments(loadCapillaries, loadDrosoTrack);
        this.expList.chainExperimentsUsingKymoIndexes(this.options.collateSeries);
        this.expList.setFirstImageForAllExperiments(this.options.collateSeries);
        this.expAll = this.expList.get_MsTime_of_StartAndEnd_AllExperiments(this.options);
        ProgressFrame progress = new ProgressFrame("Export data to Excel");
        int nbexpts = this.expList.getItemCount();
        progress.setLength((double)nbexpts);
        try {
            int column = 1;
            int iSeries = 0;
            this.workbook = this.xlsInitWorkbook();
            for (int index = this.options.firstExp; index <= this.options.lastExp; ++index) {
                Experiment exp = (Experiment)this.expList.getItemAt(index);
                if (exp.chainToPreviousExperiment != null) continue;
                progress.setMessage("Export experiment " + (index + 1) + " of " + nbexpts);
                String charSeries = CellReference.convertNumToColString((int)iSeries);
                if (this.options.topLevel) {
                    this.getCapillaryDataAndExport(exp, column, charSeries, EnumXLSExport.TOPRAW);
                    this.getCapillaryDataAndExport(exp, column, charSeries, EnumXLSExport.TOPLEVEL);
                }
                if (this.options.lrPI && this.options.topLevel) {
                    this.getCapillaryDataAndExport(exp, column, charSeries, EnumXLSExport.TOPLEVEL_LR);
                }
                if (this.options.topLevelDelta) {
                    this.getCapillaryDataAndExport(exp, column, charSeries, EnumXLSExport.TOPLEVELDELTA);
                }
                if (this.options.lrPI && this.options.topLevelDelta) {
                    this.getCapillaryDataAndExport(exp, column, charSeries, EnumXLSExport.TOPLEVELDELTA_LR);
                }
                if (this.options.bottomLevel) {
                    this.getCapillaryDataAndExport(exp, column, charSeries, EnumXLSExport.BOTTOMLEVEL);
                }
                if (this.options.derivative) {
                    this.getCapillaryDataAndExport(exp, column, charSeries, EnumXLSExport.DERIVEDVALUES);
                }
                if (!this.options.collateSeries || exp.chainToPreviousExperiment == null) {
                    column += this.expList.maxSizeOfCapillaryArrays + 2;
                }
                ++iSeries;
                progress.incPosition();
            }
            progress.setMessage("Save Excel file to disk... ");
            FileOutputStream fileOut = new FileOutputStream(filename);
            this.workbook.write((OutputStream)fileOut);
            fileOut.close();
            this.workbook.close();
            progress.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("XLSExpoportCapillaries:exportToFile() XLS output finished");
    }

    int getCapillaryDataAndExport(Experiment exp, int col0, String charSeries, EnumXLSExport xlsExport) {
        XLSResultsArray rowListForOneExp = this.getXLSResultArray_CapillaryData_From_CombinedExperiment(exp, xlsExport, this.options);
        XSSFSheet sheet = this.xlsGetSheet(xlsExport.toString(), xlsExport);
        int colmax = this.xlsExportCapillaryResultsArrayToSheet(rowListForOneExp, sheet, xlsExport, col0, charSeries);
        if (this.options.onlyalive) {
            this.trimDeadsFromArrayList(rowListForOneExp, exp);
            sheet = this.xlsGetSheet(xlsExport.toString() + "_alive", xlsExport);
            this.xlsExportCapillaryResultsArrayToSheet(rowListForOneExp, sheet, xlsExport, col0, charSeries);
        }
        if (this.options.sumPerCage) {
            this.combineDataForOneCage(rowListForOneExp, exp);
            sheet = this.xlsGetSheet(xlsExport.toString() + "_cage", xlsExport);
            this.xlsExportCapillaryResultsArrayToSheet(rowListForOneExp, sheet, xlsExport, col0, charSeries);
        }
        return colmax;
    }

    public XLSResultsArray getXLSResultArray_CapillaryData_From_CombinedExperiment(Experiment exp, EnumXLSExport xlsExportType, XLSExportOptions options) {
        XLSResultsArray rowListForOneExp = this.getXLSResultsArray_Descriptors_From_CombinedExperiment(exp, xlsExportType, options);
        Experiment expi = exp.getFirstChainedExperiment(true);
        while (expi != null) {
            int nOutputFrames = this.getNOutputFrames(expi, options);
            if (nOutputFrames > 1) {
                XLSResultsFromCapillaries resultsArrayList = new XLSResultsFromCapillaries(expi.capillaries.capillariesList.size());
                options.compensateEvaporation = false;
                switch (xlsExportType) {
                    case BOTTOMLEVEL: 
                    case NBGULPS: 
                    case AMPLITUDEGULPS: 
                    case TTOGULP: 
                    case TTOGULP_LR: 
                    case DERIVEDVALUES: 
                    case SUMGULPS: 
                    case SUMGULPS_LR: 
                    case AUTOCORREL: 
                    case AUTOCORREL_LR: 
                    case CROSSCORREL: 
                    case CROSSCORREL_LR: {
                        resultsArrayList.getResults1(expi, xlsExportType, nOutputFrames, exp.kymoBin_ms, options);
                        break;
                    }
                    case TOPLEVEL: 
                    case TOPLEVEL_LR: 
                    case TOPLEVELDELTA: 
                    case TOPLEVELDELTA_LR: {
                        options.compensateEvaporation = options.subtractEvaporation;
                        resultsArrayList.getResults_T0(expi, xlsExportType, nOutputFrames, exp.kymoBin_ms, options);
                        break;
                    }
                    case TOPRAW: {
                        resultsArrayList.getResults_T0(expi, xlsExportType, nOutputFrames, exp.kymoBin_ms, options);
                        break;
                    }
                }
                this.add_resultsArrayList_To_rowListForOneExp(rowListForOneExp, expi, resultsArrayList, options);
            }
            expi = expi.chainToNextExperiment;
        }
        switch (xlsExportType) {
            case TOPLEVELDELTA: 
            case TOPLEVELDELTA_LR: {
                rowListForOneExp.subtractDeltaT(1, 1);
                break;
            }
        }
        return rowListForOneExp;
    }

    private int getNOutputFrames(Experiment expi, XLSExportOptions options) {
        int nOutputFrames = (int)((expi.kymoLast_ms - expi.kymoFirst_ms) / (long)options.buildExcelStepMs + 1L);
        if (nOutputFrames <= 1) {
            if (expi.seqKymos.imageWidthMax == 0) {
                expi.loadKymographs();
            }
            expi.kymoLast_ms = expi.kymoFirst_ms + (long)expi.seqKymos.imageWidthMax * expi.kymoBin_ms;
            if (expi.kymoLast_ms <= 0L) {
                this.exportError(expi, -1);
            }
            if ((nOutputFrames = (int)((expi.kymoLast_ms - expi.kymoFirst_ms) / (long)options.buildExcelStepMs + 1L)) <= 1) {
                nOutputFrames = expi.seqCamData.nTotalFrames;
                this.exportError(expi, nOutputFrames);
            }
        }
        return nOutputFrames;
    }

    private void exportError(Experiment expi, int nOutputFrames) {
        String error = "XLSExport:ExportError() ERROR in " + expi.getExperimentDirectory() + "\n nOutputFrames=" + nOutputFrames + " kymoFirstCol_Ms=" + expi.kymoFirst_ms + " kymoLastCol_Ms=" + expi.kymoLast_ms;
        System.out.println(error);
    }

    private XLSResultsArray getXLSResultsArray_Descriptors_From_CombinedExperiment(Experiment exp, EnumXLSExport xlsOption, XLSExportOptions options) {
        this.expAll.cages.copy(exp.cages);
        this.expAll.capillaries.copy(exp.capillaries);
        this.expAll.chainImageFirst_ms = exp.chainImageFirst_ms;
        this.expAll.copyExperimentFields(exp);
        this.expAll.setExperimentDirectory(exp.getExperimentDirectory());
        Experiment expi = exp.chainToNextExperiment;
        while (expi != null) {
            this.expAll.capillaries.mergeLists(expi.capillaries);
            expi = expi.chainToNextExperiment;
        }
        int nFrames = (int)((this.expAll.camImageLast_ms - this.expAll.camImageFirst_ms) / (long)options.buildExcelStepMs + 1L);
        int ncapillaries = this.expAll.capillaries.capillariesList.size();
        XLSResultsArray rowListForOneExp = new XLSResultsArray(ncapillaries);
        for (int i = 0; i < ncapillaries; ++i) {
            Capillary cap = this.expAll.capillaries.capillariesList.get(i);
            XLSResults row = new XLSResults(cap.getRoiName(), cap.capNFlies, cap.capCageID, xlsOption, nFrames);
            row.stimulus = cap.capStimulus;
            row.concentration = cap.capConcentration;
            row.cageID = cap.capCageID;
            rowListForOneExp.addRow(row);
        }
        rowListForOneExp.sortRowsByName();
        return rowListForOneExp;
    }

    protected void add_resultsArrayList_To_rowListForOneExp(XLSResultsArray rowListForOneExp, Experiment expi, XLSResultsArray resultsArrayList, XLSExportOptions options) {
        if (resultsArrayList.resultsList.size() < 1) {
            return;
        }
        EnumXLSExport xlsoption = resultsArrayList.getRow((int)0).exportType;
        long offsetChain = expi.camImageFirst_ms - expi.chainImageFirst_ms;
        long start_Ms = expi.kymoFirst_ms + offsetChain;
        long end_Ms = expi.kymoLast_ms + offsetChain;
        if (options.fixedIntervals) {
            if (start_Ms < options.startAll_Ms) {
                start_Ms = options.startAll_Ms;
            }
            if (start_Ms > expi.camImageLast_ms) {
                return;
            }
            if (end_Ms > options.endAll_Ms) {
                end_Ms = options.endAll_Ms;
            }
            if (end_Ms > expi.camImageFirst_ms) {
                return;
            }
        }
        long from_first_Ms = start_Ms - offsetChain;
        long from_lastMs = end_Ms - offsetChain;
        int to_first_index = (int)(start_Ms / (long)options.buildExcelStepMs);
        int to_nvalues = (int)((end_Ms - start_Ms) / (long)options.buildExcelStepMs) + 1;
        block3: for (int iRow = 0; iRow < rowListForOneExp.size(); ++iRow) {
            double dvalue;
            XLSResults row = rowListForOneExp.getRow(iRow);
            XLSResults results = XLSResults.getResultsArrayWithThatName(row.name, resultsArrayList);
            if (results != null && results.valuesOut != null) {
                int from_i;
                dvalue = 0.0;
                switch (xlsoption) {
                    case SUMGULPS: 
                    case SUMGULPS_LR: 
                    case TOPLEVEL: 
                    case TOPLEVEL_LR: 
                    case TOPLEVELDELTA: 
                    case TOPLEVELDELTA_LR: {
                        if (!options.collateSeries || !options.padIntervals || expi.chainToPreviousExperiment == null) break;
                        dvalue = row.padWithLastPreviousValue(to_first_index);
                        break;
                    }
                }
                int icolTo = 0;
                if (options.collateSeries || options.absoluteTime) {
                    icolTo = to_first_index;
                }
                long fromTime = from_first_Ms;
                while (fromTime <= from_lastMs && (from_i = (int)Math.round((double)(fromTime - from_first_Ms) / (double)options.buildExcelStepMs)) < results.valuesOut.length) {
                    if (from_i >= 0) {
                        double value = results.valuesOut[from_i] + dvalue;
                        if (icolTo >= row.valuesOut.length) continue block3;
                        row.valuesOut[icolTo] = value;
                    }
                    fromTime += (long)options.buildExcelStepMs;
                    ++icolTo;
                }
                continue;
            }
            if (!options.collateSeries || !options.padIntervals || expi.chainToPreviousExperiment == null) continue;
            dvalue = row.padWithLastPreviousValue(to_first_index);
            int tofirst = to_first_index;
            int tolast = tofirst + to_nvalues;
            if (tolast > row.valuesOut.length) {
                tolast = row.valuesOut.length;
            }
            for (int toi = tofirst; toi < tolast; ++toi) {
                row.valuesOut[toi] = dvalue;
            }
        }
    }

    private void trimDeadsFromArrayList(XLSResultsArray rowListForOneExp, Experiment exp) {
        for (Cage cell : exp.cages.cageList) {
            String test;
            String roiname = cell.cageRoi2D.getName();
            if (roiname.length() < 4 || !(test = roiname.substring(0, 4)).contains("cage") || test.contains("cell")) continue;
            String cellNumberString = roiname.substring(4);
            int cellNumber = Integer.valueOf(cellNumberString);
            int ilastalive = 0;
            if (cell.cageNFlies > 0) {
                Experiment expi = exp;
                while (expi.chainToNextExperiment != null && expi.chainToNextExperiment.cages.isFlyAlive(cellNumber)) {
                    expi = expi.chainToNextExperiment;
                }
                int lastIntervalFlyAlive = expi.cages.getLastIntervalFlyAlive(cellNumber);
                int lastMinuteAlive = (int)((long)lastIntervalFlyAlive * expi.camImageBin_ms + (expi.camImageFirst_ms - this.expAll.camImageFirst_ms));
                ilastalive = (int)((long)lastMinuteAlive / this.expAll.kymoBin_ms);
            }
            if (ilastalive > 0) {
                ++ilastalive;
            }
            for (int iRow = 0; iRow < rowListForOneExp.size(); ++iRow) {
                XLSResults row = rowListForOneExp.getRow(iRow);
                if (this.desc_getIndex_CageFromCapillaryName(row.name) != cellNumber) continue;
                row.clearValues(ilastalive);
            }
        }
    }

    private void combineDataForOneCage(XLSResultsArray rowListForOneExp, Experiment exp) {
        for (int iRow0 = 0; iRow0 < rowListForOneExp.size(); ++iRow0) {
            XLSResults row_master = rowListForOneExp.getRow(iRow0);
            if (row_master.nflies == 0 || row_master.valuesOut == null) continue;
            for (int iRow = 0; iRow < rowListForOneExp.size(); ++iRow) {
                XLSResults row = rowListForOneExp.getRow(iRow);
                if (row.nflies == 0 || row.valuesOut == null || row.cageID != row_master.cageID || row.name.equals(row_master.name) || !row.stimulus.equals(row_master.stimulus) || !row.concentration.equals(row_master.concentration)) continue;
                row_master.sumValues_out(row);
                row.clearAll();
            }
        }
    }

    protected int xlsExportCapillaryResultsArrayToSheet(XLSResultsArray rowListForOneExp, XSSFSheet sheet, EnumXLSExport xlsExportOption, int col0, String charSeries) {
        Point pt = new Point(col0, 0);
        this.writeExperiment_Capillary_descriptors(this.expAll, charSeries, sheet, pt, xlsExportOption);
        pt = this.writeExperiment_data(rowListForOneExp, sheet, xlsExportOption, pt);
        return pt.x;
    }

    public XLSResultsArray getCapDataFromOneExperiment(Experiment exp, EnumXLSExport exportType, XLSExportOptions options) {
        this.options = options;
        this.expAll = new CombinedExperiment(exp, false);
        this.expAll.camImageLast_ms = exp.camImageLast_ms;
        this.expAll.camImageFirst_ms = exp.camImageFirst_ms;
        return this.getXLSResultArray_CapillaryData_From_CombinedExperiment(exp, exportType, options);
    }

    protected Point writeExperiment_Capillary_descriptors(Experiment exp, String charSeries, XSSFSheet sheet, Point pt, EnumXLSExport xlsExportOption) {
        boolean transpose = this.options.transpose;
        int row = pt.y;
        int col0 = pt.x;
        int colseries = this.writeSeparator_Between_Experiments(sheet, pt, transpose);
        int len = EnumXLSColumnHeader.values().length;
        for (int i = 0; i < len; ++i) {
            XLSUtils.setValue(sheet, pt, transpose, "--");
            ++pt.x;
        }
        pt.x = colseries;
        int rowmax = -1;
        for (EnumXLSColumnHeader dumb : EnumXLSColumnHeader.values()) {
            if (rowmax >= dumb.getValue()) continue;
            rowmax = dumb.getValue();
        }
        if (exp.cages.cageList.size() < exp.capillaries.capillariesList.size() / 2) {
            exp.dispatchCapillariesToCages();
        }
        ArrayList<Capillary> capList = exp.capillaries.capillariesList;
        for (int index = 0; index < capList.size(); ++index) {
            Capillary cap = (Capillary)capList.get(index);
            String name = cap.getRoiName();
            int col = this.getRowIndexFromKymoFileName(name);
            if (col >= 0) {
                pt.x = colseries + col;
            }
            int x = pt.x;
            int y = row;
            this.XLSExportExperimentParameters(sheet, transpose, x, y, charSeries, exp);
            if (exp.cages.cageList.size() > index / 2) {
                Cage cage = exp.cages.cageList.get(index / 2);
                this.xlsExportCageParameters(sheet, transpose, x, y, charSeries, exp, cage);
            }
            this.XLSExportCapillaryParameters(sheet, transpose, x, y, charSeries, exp, cap, xlsExportOption, index);
            XLSUtils.setValue(sheet, x, y + EnumXLSColumnHeader.DUM4.getValue(), transpose, sheet.getSheetName());
        }
        pt.x = col0;
        pt.y = rowmax + 1;
        return pt;
    }
}

