/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.tools.toExcel;

import icy.gui.frame.progress.ProgressFrame;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.ss.util.CellReference;
import plugins.fmp.multicafe.experiment.Experiment;
import plugins.fmp.multicafe.tools.toExcel.EnumXLSExport;
import plugins.fmp.multicafe.tools.toExcel.XLSExportCapillariesResults;
import plugins.fmp.multicafe.tools.toExcel.XLSExportOptions;

public class XLSExportGulpsResults
extends XLSExportCapillariesResults {
    @Override
    public void exportToFile(String filename, XLSExportOptions opt) {
        System.out.println("XLS capillary measures output");
        this.options = opt;
        this.expList = this.options.expList;
        boolean loadCapillaries = true;
        boolean loadDrosoTrack = this.options.onlyalive;
        this.expList.loadListOfMeasuresFromAllExperiments(loadCapillaries, loadDrosoTrack);
        this.expList.chainExperimentsUsingKymoIndexes(this.options.collateSeries);
        this.expList.setFirstImageForAllExperiments(this.options.collateSeries);
        this.expAll = this.expList.get_MsTime_of_StartAndEnd_AllExperiments(this.options);
        ProgressFrame progress = new ProgressFrame("Export data to Excel");
        int nbexpts = this.expList.getItemCount();
        progress.setLength((double)nbexpts);
        try {
            int column = 1;
            int iSeries = 0;
            this.workbook = this.xlsInitWorkbook();
            for (int index = this.options.firstExp; index <= this.options.lastExp; ++index) {
                Experiment exp = (Experiment)this.expList.getItemAt(index);
                if (exp.chainToPreviousExperiment != null) continue;
                progress.setMessage("XLSExpoportGulps:exportToFile() - Export experiment " + (index + 1) + " of " + nbexpts);
                String charSeries = CellReference.convertNumToColString((int)iSeries);
                if (this.options.derivative) {
                    this.getCapillaryDataAndExport(exp, column, charSeries, EnumXLSExport.DERIVEDVALUES);
                }
                if (this.options.sumGulps) {
                    this.getCapillaryDataAndExport(exp, column, charSeries, EnumXLSExport.SUMGULPS);
                }
                if (this.options.lrPI && this.options.sumGulps) {
                    this.getCapillaryDataAndExport(exp, column, charSeries, EnumXLSExport.SUMGULPS_LR);
                }
                if (this.options.nbGulps) {
                    this.getCapillaryDataAndExport(exp, column, charSeries, EnumXLSExport.NBGULPS);
                }
                if (this.options.amplitudeGulps) {
                    this.getCapillaryDataAndExport(exp, column, charSeries, EnumXLSExport.AMPLITUDEGULPS);
                }
                if (this.options.tToNextGulp) {
                    this.getCapillaryDataAndExport(exp, column, charSeries, EnumXLSExport.TTOGULP);
                }
                if (this.options.tToNextGulp_LR) {
                    this.getCapillaryDataAndExport(exp, column, charSeries, EnumXLSExport.TTOGULP_LR);
                }
                if (this.options.autocorrelation) {
                    this.getCapillaryDataAndExport(exp, column, charSeries, EnumXLSExport.AUTOCORREL);
                    this.getCapillaryDataAndExport(exp, column, charSeries, EnumXLSExport.AUTOCORREL_LR);
                }
                if (this.options.crosscorrelation) {
                    this.getCapillaryDataAndExport(exp, column, charSeries, EnumXLSExport.CROSSCORREL);
                    this.getCapillaryDataAndExport(exp, column, charSeries, EnumXLSExport.CROSSCORREL_LR);
                }
                if (!this.options.collateSeries || exp.chainToPreviousExperiment == null) {
                    column += this.expList.maxSizeOfCapillaryArrays + 2;
                }
                ++iSeries;
                progress.incPosition();
            }
            progress.setMessage("Save Excel file to disk... ");
            FileOutputStream fileOut = new FileOutputStream(filename);
            this.workbook.write((OutputStream)fileOut);
            fileOut.close();
            this.workbook.close();
            progress.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("XLSExpoportGulps:exportToFile() - XLS output finished");
    }
}

