/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96;

import icy.gui.frame.IcyFrame;
import icy.gui.frame.progress.ProgressFrame;
import icy.gui.util.GuiUtil;
import icy.main.Icy;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginLauncher;
import icy.plugin.PluginLoader;
import icy.plugin.abstract_.PluginActionable;
import icy.preferences.GeneralPreferences;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingWorker;
import plugins.fmp.multiSPOTS96.dlg.a_browse._DlgBrowse_;
import plugins.fmp.multiSPOTS96.dlg.a_experiment._DlgExperiment_;
import plugins.fmp.multiSPOTS96.dlg.b_spots._DlgSpots_;
import plugins.fmp.multiSPOTS96.dlg.d_spotsMeasures._DlgSpotMeasure_;
import plugins.fmp.multiSPOTS96.dlg.f_excel._DlgExcel_;
import plugins.fmp.multiSPOTS96.experiment.Experiment;
import plugins.fmp.multiSPOTS96.tools.DescriptorIndex;
import plugins.fmp.multiSPOTS96.tools.DescriptorsIO;
import plugins.fmp.multiSPOTS96.tools.JComponents.JComboBoxExperimentLazy;

public class MultiSPOTS96
extends PluginActionable {
    public IcyFrame mainFrame = new IcyFrame("multiSPOTS96 August 31, 2025", true, true, true, true);
    public JComboBoxExperimentLazy expListCombo = new JComboBoxExperimentLazy();
    public DescriptorIndex descriptorIndex = new DescriptorIndex();
    public _DlgBrowse_ dlgBrowse = new _DlgBrowse_();
    public _DlgExperiment_ dlgExperiment = new _DlgExperiment_();
    public _DlgSpots_ dlgSpots = new _DlgSpots_();
    public _DlgSpotMeasure_ dlgMeasure = new _DlgSpotMeasure_();
    public _DlgExcel_ dlgExcel = new _DlgExcel_();
    public JTabbedPane tabsPane = new JTabbedPane();

    public void run() {
        JPanel mainPanel = GuiUtil.generatePanelWithoutBorder();
        this.dlgBrowse.init(mainPanel, "Browse", this);
        this.dlgExperiment.init(mainPanel, "Experiment", this);
        this.dlgSpots.init(mainPanel, "Spots", this);
        this.dlgMeasure.init(mainPanel, "Measure spots", this);
        this.dlgExcel.init(mainPanel, "Export", this);
        this.mainFrame.setLayout((LayoutManager)new BorderLayout());
        this.mainFrame.add((Component)mainPanel, (Object)"West");
        JButton rebuildBtn = new JButton("Rebuild descriptors");
        rebuildBtn.addActionListener(e -> {
            final ProgressFrame pf = new ProgressFrame("Rebuild descriptors");
            pf.setLength((double)this.expListCombo.getItemCount());
            new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    for (int i = 0; i < MultiSPOTS96.this.expListCombo.getItemCount(); ++i) {
                        pf.setMessage("Experiment " + (i + 1) + "/" + MultiSPOTS96.this.expListCombo.getItemCount());
                        Experiment exp = MultiSPOTS96.this.expListCombo.getItemAtNoLoad(i);
                        DescriptorsIO.buildFromExperiment(exp);
                        pf.incPosition();
                    }
                    return null;
                }

                @Override
                protected void done() {
                    pf.close();
                    MultiSPOTS96.this.descriptorIndex.preloadFromCombo(MultiSPOTS96.this.expListCombo, new Runnable(){

                        @Override
                        public void run() {
                            MultiSPOTS96.this.dlgExperiment.tabInfos.initCombos();
                            MultiSPOTS96.this.dlgExperiment.tabFilter.initCombos();
                        }
                    });
                }
            }.execute();
        });
        JPanel actionsPanel = new JPanel();
        actionsPanel.add(rebuildBtn);
        this.mainFrame.add((Component)actionsPanel, (Object)"North");
        this.mainFrame.pack();
        this.mainFrame.center();
        this.mainFrame.setVisible(true);
        this.mainFrame.addToDesktopPane();
    }

    public static void main(String[] args) {
        Icy.main((String[])args);
        GeneralPreferences.setSequencePersistence((boolean)false);
        PluginLauncher.start((PluginDescriptor)PluginLoader.getPlugin((String)MultiSPOTS96.class.getName()));
    }
}

