/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.dlg.a_experiment;

import icy.gui.frame.progress.ProgressFrame;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import plugins.fmp.multiSPOTS96.MultiSPOTS96;
import plugins.fmp.multiSPOTS96.experiment.Experiment;
import plugins.fmp.multiSPOTS96.tools.DescriptorsIO;
import plugins.fmp.multiSPOTS96.tools.JComponents.JComboBoxExperimentLazy;
import plugins.fmp.multiSPOTS96.tools.toExcel.EnumXLSColumnHeader;

public class Edit
extends JPanel {
    private static final long serialVersionUID = 2190848825783418962L;
    private JComboBox<EnumXLSColumnHeader> fieldNamesCombo = new JComboBox<EnumXLSColumnHeader>(new EnumXLSColumnHeader[]{EnumXLSColumnHeader.EXP_EXPT, EnumXLSColumnHeader.EXP_BOXID, EnumXLSColumnHeader.EXP_STIM1, EnumXLSColumnHeader.EXP_CONC1, EnumXLSColumnHeader.EXP_STRAIN, EnumXLSColumnHeader.EXP_SEX, EnumXLSColumnHeader.EXP_STIM2, EnumXLSColumnHeader.EXP_CONC2, EnumXLSColumnHeader.SPOT_STIM, EnumXLSColumnHeader.SPOT_CONC, EnumXLSColumnHeader.SPOT_VOLUME, EnumXLSColumnHeader.CAGE_SEX, EnumXLSColumnHeader.CAGE_STRAIN, EnumXLSColumnHeader.CAGE_AGE});
    private JComboBox<String> fieldOldValuesCombo = new JComboBox();
    private JButton refreshButton = new JButton("Refresh");
    private JTextField newValueTextField = new JTextField(10);
    private JButton applyButton = new JButton("Apply");
    private MultiSPOTS96 parent0 = null;
    JComboBoxExperimentLazy editExpList = new JComboBoxExperimentLazy();

    void init(GridLayout capLayout, MultiSPOTS96 parent0) {
        this.parent0 = parent0;
        this.setLayout(capLayout);
        FlowLayout flowlayout = new FlowLayout(0);
        flowlayout.setVgap(1);
        int bWidth = 100;
        int bHeight = 21;
        JPanel panel0 = new JPanel(flowlayout);
        panel0.add(new JLabel("Field name "));
        panel0.add(this.fieldNamesCombo);
        this.fieldNamesCombo.setPreferredSize(new Dimension(bWidth, bHeight));
        panel0.add(this.refreshButton);
        this.add(panel0);
        bWidth = 200;
        JPanel panel1 = new JPanel(flowlayout);
        panel1.add(new JLabel("Field value "));
        panel1.add(this.fieldOldValuesCombo);
        this.fieldOldValuesCombo.setPreferredSize(new Dimension(bWidth, bHeight));
        this.add(panel1);
        JPanel panel2 = new JPanel(flowlayout);
        panel2.add(new JLabel("replace with"));
        panel2.add(this.newValueTextField);
        this.newValueTextField.setPreferredSize(new Dimension(bWidth, bHeight));
        panel2.add(this.applyButton);
        this.add(panel2);
        this.defineActionListeners();
    }

    public void initEditCombos() {
        this.editExpList.setExperimentsFromList(this.parent0.expListCombo.getExperimentsAsListNoLoad());
        EnumXLSColumnHeader field = (EnumXLSColumnHeader)((Object)this.fieldNamesCombo.getSelectedItem());
        this.fieldOldValuesCombo.removeAllItems();
        if (this.parent0.descriptorIndex == null || !this.parent0.descriptorIndex.isReady()) {
            this.editExpList.getFieldValuesToComboLightweight(this.fieldOldValuesCombo, field);
            return;
        }
        List<String> values = this.parent0.descriptorIndex.getDistinctValues(field);
        Collections.sort(values);
        for (String v : values) {
            this.fieldOldValuesCombo.addItem(v);
        }
    }

    private void defineActionListeners() {
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Edit.this.applyChange();
                Edit.this.newValueTextField.setText("");
                Edit.this.initEditCombos();
            }
        });
        this.fieldNamesCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EnumXLSColumnHeader field = (EnumXLSColumnHeader)((Object)Edit.this.fieldNamesCombo.getSelectedItem());
                Edit.this.fieldOldValuesCombo.removeAllItems();
                if (((Edit)Edit.this).parent0.descriptorIndex != null && ((Edit)Edit.this).parent0.descriptorIndex.isReady()) {
                    List<String> values = ((Edit)Edit.this).parent0.descriptorIndex.getDistinctValues(field);
                    Collections.sort(values);
                    for (String v : values) {
                        Edit.this.fieldOldValuesCombo.addItem(v);
                    }
                } else {
                    Edit.this.editExpList.getFieldValuesToComboLightweight(Edit.this.fieldOldValuesCombo, field);
                }
            }
        });
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Edit.this.initEditCombos();
            }
        });
    }

    void applyChange() {
        final int nExperiments = this.editExpList.getItemCount();
        final EnumXLSColumnHeader fieldEnumCode = (EnumXLSColumnHeader)((Object)this.fieldNamesCombo.getSelectedItem());
        final String oldValue = (String)this.fieldOldValuesCombo.getSelectedItem();
        final String newValue = this.newValueTextField.getText();
        final ProgressFrame progress = new ProgressFrame("Apply changes to " + (Object)((Object)fieldEnumCode));
        progress.setLength((double)nExperiments);
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                for (int i = 0; i < nExperiments; ++i) {
                    Experiment exp = Edit.this.editExpList.getItemAt(i);
                    progress.setMessage("Updating (" + (i + 1) + "/" + nExperiments + ")");
                    exp.load_MS96_experiment();
                    exp.load_MS96_cages();
                    exp.replaceFieldValue(fieldEnumCode, oldValue, newValue);
                    exp.save_MS96_experiment();
                    exp.save_MS96_cages();
                    DescriptorsIO.buildFromExperiment(exp);
                    progress.incPosition();
                }
                return null;
            }

            @Override
            protected void done() {
                progress.close();
                Experiment exp = ((Edit)Edit.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    exp.load_MS96_spotsMeasures();
                    ((Edit)Edit.this).parent0.dlgMeasure.tabCharts.displayChartPanels(exp);
                }
                ((Edit)Edit.this).parent0.descriptorIndex.preloadFromCombo(((Edit)Edit.this).parent0.expListCombo, new Runnable(){

                    @Override
                    public void run() {
                        ((Edit)Edit.this).parent0.dlgExperiment.tabInfos.initCombos();
                        ((Edit)Edit.this).parent0.dlgExperiment.tabFilter.initCombos();
                        Edit.this.initEditCombos();
                    }
                });
            }
        };
        worker.execute();
    }
}

