/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.dlg.b_spots;

import icy.gui.frame.IcyFrame;
import icy.roi.ROI;
import icy.roi.ROI2D;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import plugins.fmp.multiSPOTS96.MultiSPOTS96;
import plugins.fmp.multiSPOTS96.experiment.Experiment;
import plugins.fmp.multiSPOTS96.experiment.cages.Cage;
import plugins.fmp.multiSPOTS96.experiment.cages.CageTable;
import plugins.fmp.multiSPOTS96.experiment.cages.CagesArray;

public class InfosCageTable
extends JPanel
implements ListSelectionListener {
    private static final long serialVersionUID = 7599620793495187279L;
    IcyFrame dialogFrame = null;
    private CageTable cageTable = null;
    private JButton copyButton = new JButton("Copy table");
    private JButton pasteButton = new JButton("Paste");
    private JButton selectedCageButton = new JButton("Locate selected cage");
    private JButton duplicateAllButton = new JButton("Cage to all");
    private MultiSPOTS96 parent0 = null;
    private CagesArray cagesArrayCopy = null;

    public void initialize(MultiSPOTS96 parent0) {
        this.parent0 = parent0;
        this.cageTable = new CageTable(parent0);
        this.cageTable.setPreferredScrollableViewportSize(new Dimension(500, 400));
        this.cageTable.setFillsViewportHeight(true);
        TableColumnModel columnModel = this.cageTable.getColumnModel();
        for (int i = 0; i < 2; ++i) {
            this.setFixedColumnProperties(columnModel.getColumn(i));
        }
        JScrollPane scrollPane = new JScrollPane(this.cageTable);
        this.cageTable.getSelectionModel().addListSelectionListener(this);
        JPanel topPanel = new JPanel(new GridLayout(2, 1));
        FlowLayout flowLayout = new FlowLayout(0);
        JPanel panel1 = new JPanel(flowLayout);
        panel1.add(this.copyButton);
        panel1.add(this.pasteButton);
        panel1.add(this.selectedCageButton);
        topPanel.add(panel1);
        JPanel panel2 = new JPanel(flowLayout);
        panel2.add(new JLabel("Duplicate:"));
        panel2.add(this.duplicateAllButton);
        topPanel.add(panel2);
        JPanel tablePanel = new JPanel();
        tablePanel.add(scrollPane);
        this.dialogFrame = new IcyFrame("Cages properties", true, true);
        this.dialogFrame.add((Component)topPanel, (Object)"North");
        this.dialogFrame.add((Component)tablePanel, (Object)"Center");
        this.dialogFrame.pack();
        this.dialogFrame.addToDesktopPane();
        this.dialogFrame.requestFocus();
        this.dialogFrame.center();
        this.dialogFrame.setVisible(true);
        this.defineActionListeners();
        this.pasteButton.setEnabled(this.cagesArrayCopy != null);
    }

    private void defineActionListeners() {
        this.copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = ((InfosCageTable)InfosCageTable.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    InfosCageTable.this.cagesArrayCopy = exp.cagesArray;
                    InfosCageTable.this.pasteButton.setEnabled(true);
                }
            }
        });
        this.pasteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = ((InfosCageTable)InfosCageTable.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    for (Cage cageFrom : ((InfosCageTable)InfosCageTable.this).cagesArrayCopy.cagesList) {
                        cageFrom.valid = false;
                        for (Cage cageTo : exp.cagesArray.cagesList) {
                            if (!cageFrom.getRoi().getName().equals(cageTo.getRoi().getName())) continue;
                            cageFrom.valid = true;
                            cageTo.getProperties().copy(cageFrom.prop);
                        }
                    }
                    ((InfosCageTable)InfosCageTable.this).cageTable.cageTableModel.fireTableDataChanged();
                }
            }
        });
        this.duplicateAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = ((InfosCageTable)InfosCageTable.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    int rowIndex = InfosCageTable.this.cageTable.getSelectedRow();
                    int columnIndex = InfosCageTable.this.cageTable.getSelectedColumn();
                    if (rowIndex >= 0) {
                        Object value = ((InfosCageTable)InfosCageTable.this).cageTable.cageTableModel.getValueAt(rowIndex, columnIndex);
                        for (Cage cage : exp.cagesArray.cagesList) {
                            int iID = cage.getProperties().getCageID();
                            ((InfosCageTable)InfosCageTable.this).cageTable.cageTableModel.setValueAt(value, iID, columnIndex);
                        }
                    }
                }
            }
        });
        this.selectedCageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList roiList;
                Experiment exp = ((InfosCageTable)InfosCageTable.this).parent0.expListCombo.getSelectedItem();
                if (exp != null && (roiList = exp.seqCamData.getSequence().getSelectedROIs()).size() > 0) {
                    Cage cage = null;
                    for (ROI roi : roiList) {
                        String name = roi.getName();
                        if (name.contains("cage")) {
                            cage = exp.cagesArray.getCageFromName(name);
                            break;
                        }
                        if (!name.contains("spot")) continue;
                        cage = exp.cagesArray.getCageFromSpotROIName(name);
                        break;
                    }
                    if (cage != null) {
                        InfosCageTable.this.selectRowFromCage(cage);
                    }
                }
            }
        });
        this.cageTable.cageTableModel.fireTableDataChanged();
    }

    public void close() {
        this.dialogFrame.close();
        Experiment exp = this.parent0.expListCombo.getSelectedItem();
        if (exp != null) {
            exp.saveSpotsArray_file();
        }
    }

    private void setFixedColumnProperties(TableColumn column) {
        column.setResizable(false);
        column.setPreferredWidth(50);
        column.setMaxWidth(50);
        column.setMinWidth(30);
    }

    void selectCage(int cageID) {
        Experiment exp = this.parent0.expListCombo.getSelectedItem();
        if (exp != null) {
            Cage cage = exp.cagesArray.getCageFromID(cageID);
            ROI2D roi = cage.getRoi();
            exp.seqCamData.getSequence().setFocusedROI((ROI)roi);
            exp.seqCamData.centerDisplayOnRoi(roi);
            roi.setSelected(true);
        }
    }

    public void selectRowFromCage(Cage cage) {
        String cageName = cage.getRoi().getName();
        int nrows = this.cageTable.getRowCount();
        int selectedRow = -1;
        for (int i = 0; i < nrows; ++i) {
            String name = (String)this.cageTable.getValueAt(i, 0);
            if (!name.equals(cageName)) continue;
            selectedRow = i;
            break;
        }
        if (selectedRow >= 0) {
            this.cageTable.setRowSelectionInterval(selectedRow, selectedRow);
            Rectangle rect = new Rectangle(this.cageTable.getCellRect(selectedRow, 0, true));
            rect.height *= 2;
            this.cageTable.scrollRectToVisible(rect);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        int minIndex = lsm.getMinSelectionIndex();
        this.selectCage(minIndex);
    }
}

