/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.series;

import icy.image.IcyBufferedImage;
import plugins.fmp.multiSPOTS96.experiment.Experiment;
import plugins.fmp.multiSPOTS96.series.ProcessingResult;
import plugins.fmp.multiSPOTS96.series.RegistrationOptions;

public interface RegistrationProcessor {
    public ProcessingResult<RegistrationResult> correctDrift(Experiment var1, RegistrationOptions var2);

    public ProcessingResult<RegistrationResult> correctRotation(Experiment var1, RegistrationOptions var2);

    public ProcessingResult<RegistrationResult> correctDriftAndRotation(Experiment var1, RegistrationOptions var2);

    public ProcessingResult<TranslationResult> findTranslation(IcyBufferedImage var1, IcyBufferedImage var2, int var3);

    public ProcessingResult<RotationResult> findRotation(IcyBufferedImage var1, IcyBufferedImage var2, int var3, TranslationResult var4);

    public ProcessingResult<IcyBufferedImage> applyTranslation(IcyBufferedImage var1, TranslationResult var2, int var3, boolean var4);

    public ProcessingResult<IcyBufferedImage> applyRotation(IcyBufferedImage var1, RotationResult var2, int var3, boolean var4);

    public static class RotationResult {
        private final double angleRadians;
        private final double angleDegrees;

        public RotationResult(double angleRadians) {
            this.angleRadians = angleRadians;
            this.angleDegrees = Math.toDegrees(angleRadians);
        }

        public double getAngleRadians() {
            return this.angleRadians;
        }

        public double getAngleDegrees() {
            return this.angleDegrees;
        }

        public boolean isSignificant(double threshold) {
            return Math.abs(this.angleRadians) > threshold;
        }
    }

    public static class TranslationResult {
        private final double x;
        private final double y;
        private final double magnitude;

        public TranslationResult(double x, double y) {
            this.x = x;
            this.y = y;
            this.magnitude = Math.sqrt(x * x + y * y);
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getMagnitude() {
            return this.magnitude;
        }

        public boolean isSignificant(double threshold) {
            return this.magnitude > threshold;
        }
    }

    public static class RegistrationResult {
        private final int framesProcessed;
        private final int framesCorrected;
        private final int totalTranslations;
        private final int totalRotations;
        private final double averageTranslationMagnitude;
        private final double averageRotationAngle;

        public RegistrationResult(int framesProcessed, int framesCorrected, int totalTranslations, int totalRotations, double averageTranslationMagnitude, double averageRotationAngle) {
            this.framesProcessed = framesProcessed;
            this.framesCorrected = framesCorrected;
            this.totalTranslations = totalTranslations;
            this.totalRotations = totalRotations;
            this.averageTranslationMagnitude = averageTranslationMagnitude;
            this.averageRotationAngle = averageRotationAngle;
        }

        public int getFramesProcessed() {
            return this.framesProcessed;
        }

        public int getFramesCorrected() {
            return this.framesCorrected;
        }

        public int getTotalTranslations() {
            return this.totalTranslations;
        }

        public int getTotalRotations() {
            return this.totalRotations;
        }

        public double getAverageTranslationMagnitude() {
            return this.averageTranslationMagnitude;
        }

        public double getAverageRotationAngle() {
            return this.averageRotationAngle;
        }
    }
}

