/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.series.options;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import plugins.fmp.multiSPOTS96.series.BuildSeriesOptions;

public class DetectionOptions {
    private final int threshold;
    private final boolean thresholdUp;
    private final int flyThreshold;
    private final boolean flyThresholdUp;
    private final int backgroundThreshold;
    private final int spotThreshold;
    private final boolean spotThresholdUp;
    private final int detectCage;
    private final boolean detectTop;
    private final boolean detectBottom;
    private final boolean detectFlies;
    private final boolean detectSelectedROIs;
    private final boolean detectAllSeries;
    private final List<Integer> selectedIndexes;
    private final int nFliesPresent;
    private final int videoChannel;
    private final int spotRadius;
    private final int diskRadius;

    private DetectionOptions(Builder builder) {
        this.threshold = this.validateThreshold(builder.threshold);
        this.thresholdUp = builder.thresholdUp;
        this.flyThreshold = this.validateFlyThreshold(builder.flyThreshold);
        this.flyThresholdUp = builder.flyThresholdUp;
        this.backgroundThreshold = this.validateBackgroundThreshold(builder.backgroundThreshold);
        this.spotThreshold = this.validateSpotThreshold(builder.spotThreshold);
        this.spotThresholdUp = builder.spotThresholdUp;
        this.detectCage = builder.detectCage;
        this.detectTop = builder.detectTop;
        this.detectBottom = builder.detectBottom;
        this.detectFlies = builder.detectFlies;
        this.detectSelectedROIs = builder.detectSelectedROIs;
        this.detectAllSeries = builder.detectAllSeries;
        this.selectedIndexes = builder.selectedIndexes != null ? Collections.unmodifiableList(new ArrayList(builder.selectedIndexes)) : Collections.emptyList();
        this.nFliesPresent = this.validateNFliesPresent(builder.nFliesPresent);
        this.videoChannel = this.validateVideoChannel(builder.videoChannel);
        this.spotRadius = this.validateSpotRadius(builder.spotRadius);
        this.diskRadius = this.validateDiskRadius(builder.diskRadius);
    }

    public int getThreshold() {
        return this.threshold;
    }

    public boolean isThresholdUp() {
        return this.thresholdUp;
    }

    public int getFlyThreshold() {
        return this.flyThreshold;
    }

    public boolean isFlyThresholdUp() {
        return this.flyThresholdUp;
    }

    public int getBackgroundThreshold() {
        return this.backgroundThreshold;
    }

    public int getSpotThreshold() {
        return this.spotThreshold;
    }

    public boolean isSpotThresholdUp() {
        return this.spotThresholdUp;
    }

    public int getDetectCage() {
        return this.detectCage;
    }

    public boolean isDetectTop() {
        return this.detectTop;
    }

    public boolean isDetectBottom() {
        return this.detectBottom;
    }

    public boolean isDetectFlies() {
        return this.detectFlies;
    }

    public boolean isDetectSelectedROIs() {
        return this.detectSelectedROIs;
    }

    public boolean isDetectAllSeries() {
        return this.detectAllSeries;
    }

    public List<Integer> getSelectedIndexes() {
        return this.selectedIndexes;
    }

    public int getNFliesPresent() {
        return this.nFliesPresent;
    }

    public int getVideoChannel() {
        return this.videoChannel;
    }

    public int getSpotRadius() {
        return this.spotRadius;
    }

    public int getDiskRadius() {
        return this.diskRadius;
    }

    private int validateThreshold(int threshold) {
        if (threshold < -1 || threshold > 255) {
            throw new IllegalArgumentException("Threshold must be between -1 and 255, got: " + threshold);
        }
        return threshold;
    }

    private int validateFlyThreshold(int flyThreshold) {
        if (flyThreshold < 0 || flyThreshold > 255) {
            throw new IllegalArgumentException("Fly threshold must be between 0 and 255, got: " + flyThreshold);
        }
        return flyThreshold;
    }

    private int validateBackgroundThreshold(int backgroundThreshold) {
        if (backgroundThreshold < 0 || backgroundThreshold > 255) {
            throw new IllegalArgumentException("Background threshold must be between 0 and 255, got: " + backgroundThreshold);
        }
        return backgroundThreshold;
    }

    private int validateSpotThreshold(int spotThreshold) {
        if (spotThreshold < 0 || spotThreshold > 255) {
            throw new IllegalArgumentException("Spot threshold must be between 0 and 255, got: " + spotThreshold);
        }
        return spotThreshold;
    }

    private int validateNFliesPresent(int nFliesPresent) {
        if (nFliesPresent < 0) {
            throw new IllegalArgumentException("Number of flies present must be non-negative, got: " + nFliesPresent);
        }
        return nFliesPresent;
    }

    private int validateVideoChannel(int videoChannel) {
        if (videoChannel < 0 || videoChannel > 2) {
            throw new IllegalArgumentException("Video channel must be between 0 and 2, got: " + videoChannel);
        }
        return videoChannel;
    }

    private int validateSpotRadius(int spotRadius) {
        if (spotRadius < 1 || spotRadius > 50) {
            throw new IllegalArgumentException("Spot radius must be between 1 and 50, got: " + spotRadius);
        }
        return spotRadius;
    }

    private int validateDiskRadius(int diskRadius) {
        if (diskRadius < 1 || diskRadius > 50) {
            throw new IllegalArgumentException("Disk radius must be between 1 and 50, got: " + diskRadius);
        }
        return diskRadius;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DetectionOptions fromLegacyOptions(BuildSeriesOptions legacy) {
        return DetectionOptions.builder().threshold(legacy.threshold).flyThreshold(legacy.flyThreshold).flyThresholdUp(legacy.flyThresholdUp).backgroundThreshold(legacy.backgroundThreshold).spotThreshold(legacy.spotThreshold).spotThresholdUp(legacy.spotThresholdUp).detectCage(legacy.detectCage).detectTop(legacy.detectTop).detectBottom(legacy.detectBottom).detectFlies(legacy.detectFlies).detectSelectedROIs(legacy.detectSelectedROIs).detectAllSeries(legacy.detectAllSeries).selectedIndexes(legacy.selectedIndexes).nFliesPresent(legacy.nFliesPresent).videoChannel(legacy.videoChannel).spotRadius(legacy.spotRadius).diskRadius(legacy.diskRadius).build();
    }

    public static class Builder {
        private int threshold = -1;
        private boolean thresholdUp = true;
        private int flyThreshold = 60;
        private boolean flyThresholdUp = true;
        private int backgroundThreshold = 40;
        private int spotThreshold = 35;
        private boolean spotThresholdUp = true;
        private int detectCage = -1;
        private boolean detectTop = true;
        private boolean detectBottom = true;
        private boolean detectFlies = true;
        private boolean detectSelectedROIs = false;
        private boolean detectAllSeries = true;
        private List<Integer> selectedIndexes = new ArrayList<Integer>();
        private int nFliesPresent = 1;
        private int videoChannel = 0;
        private int spotRadius = 5;
        private int diskRadius = 5;

        public Builder threshold(int threshold) {
            this.threshold = threshold;
            return this;
        }

        public Builder thresholdUp(boolean thresholdUp) {
            this.thresholdUp = thresholdUp;
            return this;
        }

        public Builder flyThreshold(int flyThreshold) {
            this.flyThreshold = flyThreshold;
            return this;
        }

        public Builder flyThresholdUp(boolean flyThresholdUp) {
            this.flyThresholdUp = flyThresholdUp;
            return this;
        }

        public Builder backgroundThreshold(int backgroundThreshold) {
            this.backgroundThreshold = backgroundThreshold;
            return this;
        }

        public Builder spotThreshold(int spotThreshold) {
            this.spotThreshold = spotThreshold;
            return this;
        }

        public Builder spotThresholdUp(boolean spotThresholdUp) {
            this.spotThresholdUp = spotThresholdUp;
            return this;
        }

        public Builder detectCage(int detectCage) {
            this.detectCage = detectCage;
            return this;
        }

        public Builder detectTop(boolean detectTop) {
            this.detectTop = detectTop;
            return this;
        }

        public Builder detectBottom(boolean detectBottom) {
            this.detectBottom = detectBottom;
            return this;
        }

        public Builder detectFlies(boolean detectFlies) {
            this.detectFlies = detectFlies;
            return this;
        }

        public Builder detectSelectedROIs(boolean detectSelectedROIs) {
            this.detectSelectedROIs = detectSelectedROIs;
            return this;
        }

        public Builder detectAllSeries(boolean detectAllSeries) {
            this.detectAllSeries = detectAllSeries;
            return this;
        }

        public Builder selectedIndexes(List<Integer> selectedIndexes) {
            this.selectedIndexes = selectedIndexes;
            return this;
        }

        public Builder nFliesPresent(int nFliesPresent) {
            this.nFliesPresent = nFliesPresent;
            return this;
        }

        public Builder videoChannel(int videoChannel) {
            this.videoChannel = videoChannel;
            return this;
        }

        public Builder spotRadius(int spotRadius) {
            this.spotRadius = spotRadius;
            return this;
        }

        public Builder diskRadius(int diskRadius) {
            this.diskRadius = diskRadius;
            return this;
        }

        public DetectionOptions build() {
            return new DetectionOptions(this);
        }
    }
}

