/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.experiment.spots;

import java.util.List;
import plugins.fmp.multiSPOTS96.experiment.spots.EnumSpotMeasures;

public class SpotsArrayConfiguration {
    private final boolean validateSpots;
    private final boolean enableProgressReporting;
    private final boolean autoSortSpots;
    private final boolean createBackups;
    private final List<EnumSpotMeasures> enabledMeasureTypes;
    private final int maxConcurrentOperations;
    private final boolean strictValidation;
    private final String csvSeparator;

    private SpotsArrayConfiguration(Builder builder) {
        this.validateSpots = builder.validateSpots;
        this.enableProgressReporting = builder.enableProgressReporting;
        this.autoSortSpots = builder.autoSortSpots;
        this.createBackups = builder.createBackups;
        this.enabledMeasureTypes = builder.enabledMeasureTypes != null ? List.copyOf(builder.enabledMeasureTypes) : List.of(EnumSpotMeasures.AREA_SUM, EnumSpotMeasures.AREA_SUMCLEAN, EnumSpotMeasures.AREA_OUT, EnumSpotMeasures.AREA_DIFF, EnumSpotMeasures.AREA_FLYPRESENT);
        this.maxConcurrentOperations = builder.maxConcurrentOperations;
        this.strictValidation = builder.strictValidation;
        this.csvSeparator = builder.csvSeparator;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SpotsArrayConfiguration defaultConfiguration() {
        return SpotsArrayConfiguration.builder().build();
    }

    public static SpotsArrayConfiguration highPerformance() {
        return SpotsArrayConfiguration.builder().validateSpots(false).autoSortSpots(false).enableProgressReporting(false).strictValidation(false).maxConcurrentOperations(Runtime.getRuntime().availableProcessors() * 2).build();
    }

    public static SpotsArrayConfiguration qualityAssurance() {
        return SpotsArrayConfiguration.builder().validateSpots(true).autoSortSpots(true).enableProgressReporting(true).strictValidation(true).createBackups(true).maxConcurrentOperations(1).build();
    }

    public static SpotsArrayConfiguration dataImportExport() {
        return SpotsArrayConfiguration.builder().validateSpots(true).enableProgressReporting(true).createBackups(true).strictValidation(true).build();
    }

    public boolean isValidateSpots() {
        return this.validateSpots;
    }

    public boolean isEnableProgressReporting() {
        return this.enableProgressReporting;
    }

    public boolean isAutoSortSpots() {
        return this.autoSortSpots;
    }

    public boolean isCreateBackups() {
        return this.createBackups;
    }

    public List<EnumSpotMeasures> getEnabledMeasureTypes() {
        return this.enabledMeasureTypes;
    }

    public int getMaxConcurrentOperations() {
        return this.maxConcurrentOperations;
    }

    public boolean isStrictValidation() {
        return this.strictValidation;
    }

    public String getCsvSeparator() {
        return this.csvSeparator;
    }

    public String toString() {
        return String.format("SpotsArrayConfiguration{validate=%b, progress=%b, sort=%b, backup=%b, strict=%b, concurrent=%d}", this.validateSpots, this.enableProgressReporting, this.autoSortSpots, this.createBackups, this.strictValidation, this.maxConcurrentOperations);
    }

    public static class Builder {
        private boolean validateSpots = true;
        private boolean enableProgressReporting = true;
        private boolean autoSortSpots = true;
        private boolean createBackups = false;
        private List<EnumSpotMeasures> enabledMeasureTypes;
        private int maxConcurrentOperations = Runtime.getRuntime().availableProcessors();
        private boolean strictValidation = true;
        private String csvSeparator = ";";

        public Builder validateSpots(boolean validateSpots) {
            this.validateSpots = validateSpots;
            return this;
        }

        public Builder enableProgressReporting(boolean enableProgressReporting) {
            this.enableProgressReporting = enableProgressReporting;
            return this;
        }

        public Builder autoSortSpots(boolean autoSortSpots) {
            this.autoSortSpots = autoSortSpots;
            return this;
        }

        public Builder createBackups(boolean createBackups) {
            this.createBackups = createBackups;
            return this;
        }

        public Builder enabledMeasureTypes(List<EnumSpotMeasures> enabledMeasureTypes) {
            this.enabledMeasureTypes = enabledMeasureTypes;
            return this;
        }

        public Builder maxConcurrentOperations(int maxConcurrentOperations) {
            this.maxConcurrentOperations = maxConcurrentOperations;
            return this;
        }

        public Builder strictValidation(boolean strictValidation) {
            this.strictValidation = strictValidation;
            return this;
        }

        public Builder csvSeparator(String csvSeparator) {
            this.csvSeparator = csvSeparator;
            return this;
        }

        public SpotsArrayConfiguration build() {
            return new SpotsArrayConfiguration(this);
        }
    }
}

