/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.series;

import java.util.Optional;
import java.util.function.Function;
import plugins.fmp.multiSPOTS96.series.exceptions.SeriesProcessingException;

public class ProcessingResult<T> {
    private final boolean success;
    private final String errorMessage;
    private final Optional<T> data;
    private final Optional<Throwable> cause;

    private ProcessingResult(boolean success, String errorMessage, T data, Throwable cause) {
        this.success = success;
        this.errorMessage = errorMessage;
        this.data = Optional.ofNullable(data);
        this.cause = Optional.ofNullable(cause);
    }

    public static <T> ProcessingResult<T> success(T data) {
        return new ProcessingResult<T>(true, null, data, null);
    }

    public static ProcessingResult<Void> success() {
        return new ProcessingResult<Object>(true, null, null, null);
    }

    public static <T> ProcessingResult<T> failure(String errorMessage) {
        return new ProcessingResult<Object>(false, errorMessage, null, null);
    }

    public static <T> ProcessingResult<T> failure(String errorMessage, Throwable cause) {
        return new ProcessingResult<Object>(false, errorMessage, null, cause);
    }

    public static <T> ProcessingResult<T> failure(String format, Object ... args) {
        return new ProcessingResult<Object>(false, String.format(format, args), null, null);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public boolean isFailure() {
        return !this.success;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Optional<T> getData() {
        return this.data;
    }

    public Optional<Throwable> getCause() {
        return this.cause;
    }

    public T getDataOrThrow() {
        if (this.success) {
            return this.data.orElse(null);
        }
        throw new SeriesProcessingException(this.errorMessage, this.cause.orElse(null));
    }

    public T getDataOrDefault(T defaultValue) {
        return this.success ? this.data.orElse(defaultValue) : defaultValue;
    }

    public <U> ProcessingResult<U> map(Function<T, U> mapper) {
        if (this.success && this.data.isPresent()) {
            try {
                return ProcessingResult.success(mapper.apply(this.data.get()));
            }
            catch (Exception e) {
                return ProcessingResult.failure("Mapping failed", e);
            }
        }
        return ProcessingResult.failure(this.errorMessage, this.cause.orElse(null));
    }

    public <U> ProcessingResult<U> flatMap(Function<T, ProcessingResult<U>> mapper) {
        if (this.success && this.data.isPresent()) {
            try {
                return mapper.apply(this.data.get());
            }
            catch (Exception e) {
                return ProcessingResult.failure("FlatMapping failed", e);
            }
        }
        return ProcessingResult.failure(this.errorMessage, this.cause.orElse(null));
    }

    public String toString() {
        if (this.success) {
            return "ProcessingResult.success(" + this.data.orElse(null) + ")";
        }
        return "ProcessingResult.failure(" + this.errorMessage + ")";
    }
}

