/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.series;

import icy.gui.frame.progress.ProgressFrame;
import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageUtil;
import icy.image.ImageUtil;
import icy.type.geom.Polygon2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.logging.Logger;
import javax.vecmath.Vector2d;
import plugins.fmp.multiSPOTS96.experiment.Experiment;
import plugins.fmp.multiSPOTS96.series.ImageProcessor;
import plugins.fmp.multiSPOTS96.series.ProcessingResult;
import plugins.fmp.multiSPOTS96.series.ProgressReporter;
import plugins.fmp.multiSPOTS96.series.RegistrationOptions;
import plugins.fmp.multiSPOTS96.series.RegistrationProcessor;
import plugins.fmp.multiSPOTS96.series.SafeImageProcessor;
import plugins.fmp.multiSPOTS96.tools.GaspardRigidRegistration;
import plugins.fmp.multiSPOTS96.tools.imageTransform.ImageTransformInterface;

public class SafeRegistrationProcessor
implements RegistrationProcessor {
    private static final Logger LOGGER = Logger.getLogger(SafeRegistrationProcessor.class.getName());
    private final ImageProcessor imageProcessor;
    private final ProgressReporter progressReporter;
    private boolean stopFlag = false;

    public SafeRegistrationProcessor() {
        this(new SafeImageProcessor(), ProgressReporter.NO_OP);
    }

    public SafeRegistrationProcessor(ImageProcessor imageProcessor, ProgressReporter progressReporter) {
        this.imageProcessor = imageProcessor;
        this.progressReporter = progressReporter;
    }

    @Override
    public ProcessingResult<RegistrationProcessor.RegistrationResult> correctDrift(Experiment experiment, RegistrationOptions options) {
        return this.performRegistration(experiment, options, false, true);
    }

    @Override
    public ProcessingResult<RegistrationProcessor.RegistrationResult> correctRotation(Experiment experiment, RegistrationOptions options) {
        return this.performRegistration(experiment, options, true, false);
    }

    @Override
    public ProcessingResult<RegistrationProcessor.RegistrationResult> correctDriftAndRotation(Experiment experiment, RegistrationOptions options) {
        return this.performRegistration(experiment, options, true, true);
    }

    @Override
    public ProcessingResult<RegistrationProcessor.TranslationResult> findTranslation(IcyBufferedImage sourceImage, IcyBufferedImage targetImage, int channel) {
        if (sourceImage == null) {
            return ProcessingResult.failure("Source image cannot be null");
        }
        if (targetImage == null) {
            return ProcessingResult.failure("Target image cannot be null");
        }
        if (channel < 0 || channel >= sourceImage.getSizeC()) {
            return ProcessingResult.failure("Invalid channel: %d", channel);
        }
        try {
            Vector2d translation = GaspardRigidRegistration.findTranslation2D(sourceImage, channel, targetImage, channel);
            RegistrationProcessor.TranslationResult result = new RegistrationProcessor.TranslationResult(translation.x, translation.y);
            return ProcessingResult.success(result);
        }
        catch (Exception e) {
            LOGGER.warning("Failed to find translation: " + e.getMessage());
            return ProcessingResult.failure("Translation detection failed", e);
        }
    }

    @Override
    public ProcessingResult<RegistrationProcessor.RotationResult> findRotation(IcyBufferedImage sourceImage, IcyBufferedImage targetImage, int channel, RegistrationProcessor.TranslationResult previousTranslation) {
        if (sourceImage == null) {
            return ProcessingResult.failure("Source image cannot be null");
        }
        if (targetImage == null) {
            return ProcessingResult.failure("Target image cannot be null");
        }
        if (channel < 0 || channel >= sourceImage.getSizeC()) {
            return ProcessingResult.failure("Invalid channel: %d", channel);
        }
        try {
            Vector2d translation = previousTranslation != null ? new Vector2d(previousTranslation.getX(), previousTranslation.getY()) : null;
            double angle = GaspardRigidRegistration.findRotation2D(sourceImage, channel, targetImage, channel, translation);
            RegistrationProcessor.RotationResult result = new RegistrationProcessor.RotationResult(angle);
            return ProcessingResult.success(result);
        }
        catch (Exception e) {
            LOGGER.warning("Failed to find rotation: " + e.getMessage());
            return ProcessingResult.failure("Rotation detection failed", e);
        }
    }

    @Override
    public ProcessingResult<IcyBufferedImage> applyTranslation(IcyBufferedImage image, RegistrationProcessor.TranslationResult translation, int channel, boolean preserveSize) {
        if (image == null) {
            return ProcessingResult.failure("Image cannot be null");
        }
        if (translation == null) {
            return ProcessingResult.failure("Translation cannot be null");
        }
        try {
            Vector2d vector = new Vector2d(translation.getX(), translation.getY());
            IcyBufferedImage result = GaspardRigidRegistration.applyTranslation2D(image, channel, vector, preserveSize);
            return ProcessingResult.success(result);
        }
        catch (Exception e) {
            LOGGER.warning("Failed to apply translation: " + e.getMessage());
            return ProcessingResult.failure("Translation application failed", e);
        }
    }

    @Override
    public ProcessingResult<IcyBufferedImage> applyRotation(IcyBufferedImage image, RegistrationProcessor.RotationResult rotation, int channel, boolean preserveSize) {
        if (image == null) {
            return ProcessingResult.failure("Image cannot be null");
        }
        if (rotation == null) {
            return ProcessingResult.failure("Rotation cannot be null");
        }
        try {
            IcyBufferedImage result = GaspardRigidRegistration.applyRotation2D(image, channel, rotation.getAngleRadians(), preserveSize);
            return ProcessingResult.success(result);
        }
        catch (Exception e) {
            LOGGER.warning("Failed to apply rotation: " + e.getMessage());
            return ProcessingResult.failure("Rotation application failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProcessingResult<RegistrationProcessor.RegistrationResult> performRegistration(Experiment experiment, RegistrationOptions options, boolean correctRotation, boolean correctTranslation) {
        ProcessingResult<Void> validationResult = this.validateRegistrationInputs(experiment, options);
        if (validationResult.isFailure()) {
            return ProcessingResult.failure(validationResult.getErrorMessage());
        }
        try {
            ProcessingResult<Void> loadResult = this.loadExperimentData(experiment);
            if (loadResult.isFailure()) {
                ProcessingResult<RegistrationProcessor.RegistrationResult> processingResult = ProcessingResult.failure(loadResult.getErrorMessage());
                return processingResult;
            }
            ProcessingResult<RegistrationProcessor.RegistrationResult> processingResult = this.executeRegistration(experiment, options, correctRotation, correctTranslation);
            return processingResult;
        }
        finally {
            this.cleanupResources();
        }
    }

    private ProcessingResult<Void> validateRegistrationInputs(Experiment experiment, RegistrationOptions options) {
        if (experiment == null) {
            return ProcessingResult.failure("Experiment cannot be null");
        }
        if (experiment.seqCamData == null) {
            return ProcessingResult.failure("Experiment must have camera data");
        }
        if (experiment.cagesArray == null) {
            return ProcessingResult.failure("Experiment must have cages array");
        }
        return options.validate();
    }

    private ProcessingResult<Void> loadExperimentData(Experiment experiment) {
        try {
            boolean loadSuccess = this.loadSeqCamDataAndCages(experiment);
            if (!loadSuccess) {
                return ProcessingResult.failure("Failed to load experiment data");
            }
            return ProcessingResult.success();
        }
        catch (Exception e) {
            return ProcessingResult.failure("Error loading experiment data", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProcessingResult<RegistrationProcessor.RegistrationResult> executeRegistration(Experiment experiment, RegistrationOptions options, boolean correctRotation, boolean correctTranslation) {
        try (ProgressFrame progressBar = new ProgressFrame("Registration Analysis");){
            int fromFrame = options.getFromFrame();
            int toFrame = options.getToFrame();
            int referenceFrame = options.getReferenceFrame();
            double translationThreshold = options.getTranslationThreshold();
            double rotationThreshold = options.getRotationThreshold();
            ProcessingResult<IcyBufferedImage> refImageResult = this.loadReferenceImage(experiment, referenceFrame, options);
            if (refImageResult.isFailure()) {
                ProcessingResult<RegistrationProcessor.RegistrationResult> processingResult = ProcessingResult.failure(refImageResult.getErrorMessage());
                return processingResult;
            }
            IcyBufferedImage referenceImage = refImageResult.getDataOrThrow();
            IcyBufferedImage transformedReference = this.applyTransform(referenceImage, options);
            IcyBufferedImage reducedReference = this.extractRegionOfInterest(transformedReference, experiment);
            RegistrationStatistics stats = new RegistrationStatistics();
            for (int frame = fromFrame; frame < toFrame && !this.stopFlag; ++frame) {
                progressBar.setMessage("Processing frame: " + frame + "/" + toFrame);
                ProcessingResult<RegistrationProcessor.RegistrationResult> frameResult = this.processFrame(experiment, frame, referenceImage, reducedReference, options, correctRotation, correctTranslation, translationThreshold, rotationThreshold);
                if (frameResult.isSuccess()) {
                    RegistrationProcessor.RegistrationResult frameResultData = frameResult.getDataOrThrow();
                    stats.incrementFramesProcessed();
                    if (frameResultData.getFramesCorrected() > 0) {
                        stats.incrementFramesCorrected();
                    }
                    stats.addTranslationMagnitude(frameResultData.getAverageTranslationMagnitude());
                    stats.addRotationAngle(frameResultData.getAverageRotationAngle());
                    continue;
                }
                LOGGER.warning("Frame " + frame + " processing failed: " + frameResult.getErrorMessage());
            }
            ProcessingResult<RegistrationProcessor.RegistrationResult> processingResult = ProcessingResult.success(stats.buildResult());
            return processingResult;
        }
    }

    private ProcessingResult<IcyBufferedImage> loadReferenceImage(Experiment experiment, int referenceFrame, RegistrationOptions options) {
        String fileName = experiment.seqCamData.getFileNameFromImageList(referenceFrame);
        if (fileName == null) {
            return ProcessingResult.failure("Reference frame file not found: %d", referenceFrame);
        }
        return this.imageProcessor.loadImage(fileName);
    }

    private IcyBufferedImage applyTransform(IcyBufferedImage image, RegistrationOptions options) {
        ImageTransformInterface transformFunction = options.getTransformOptions().transformOption.getFunction();
        return transformFunction.getTransformedImage(image, options.getTransformOptions());
    }

    private IcyBufferedImage extractRegionOfInterest(IcyBufferedImage image, Experiment experiment) {
        Polygon2D polygon2D = experiment.cagesArray.getPolygon2DEnclosingAllCages();
        Rectangle rect = polygon2D.getBounds();
        return IcyBufferedImageUtil.getSubImage((IcyBufferedImage)image, (int)rect.x, (int)rect.y, (int)rect.height, (int)rect.width);
    }

    private ProcessingResult<RegistrationProcessor.RegistrationResult> processFrame(Experiment experiment, int frame, IcyBufferedImage referenceImage, IcyBufferedImage reducedReference, RegistrationOptions options, boolean correctRotation, boolean correctTranslation, double translationThreshold, double rotationThreshold) {
        ProcessingResult<Void> saveResult;
        RegistrationProcessor.RotationResult rotation;
        ProcessingResult<RegistrationProcessor.RotationResult> rotationResult;
        ProcessingResult<IcyBufferedImage> appliedResult;
        RegistrationProcessor.TranslationResult translation;
        ProcessingResult<RegistrationProcessor.TranslationResult> translationResult;
        String fileName = experiment.seqCamData.getFileNameFromImageList(frame);
        if (fileName == null) {
            return ProcessingResult.failure("Frame file not found: %d", frame);
        }
        ProcessingResult<IcyBufferedImage> workImageResult = this.imageProcessor.loadImage(fileName);
        if (workImageResult.isFailure()) {
            return ProcessingResult.failure("Failed to load frame %d: %s", frame, workImageResult.getErrorMessage());
        }
        IcyBufferedImage workImage = workImageResult.getDataOrThrow();
        IcyBufferedImage transformedWorkImage = this.applyTransform(workImage, options);
        IcyBufferedImage reducedWorkImage = this.extractRegionOfInterest(transformedWorkImage, experiment);
        RegistrationStatistics frameStats = new RegistrationStatistics();
        frameStats.incrementFramesProcessed();
        if (correctTranslation && (translationResult = this.findTranslation(reducedWorkImage, reducedReference, options.getReferenceChannel())).isSuccess() && (translation = translationResult.getDataOrThrow()).isSignificant(translationThreshold) && (appliedResult = this.applyTranslation(workImage, translation, -1, options.isPreserveImageSize())).isSuccess()) {
            workImage = appliedResult.getDataOrThrow();
            frameStats.incrementTranslations();
            LOGGER.info("Applied translation correction: (" + translation.getX() + ", " + translation.getY() + ")");
        }
        if (correctRotation && (rotationResult = this.findRotation(reducedWorkImage, reducedReference, options.getReferenceChannel(), null)).isSuccess() && (rotation = rotationResult.getDataOrThrow()).isSignificant(rotationThreshold) && (appliedResult = this.applyRotation(workImage, rotation, -1, options.isPreserveImageSize())).isSuccess()) {
            workImage = appliedResult.getDataOrThrow();
            frameStats.incrementRotations();
            LOGGER.info("Applied rotation correction: " + rotation.getAngleDegrees() + " degrees");
        }
        if (options.isSaveCorrectedImages() && (frameStats.getTotalTranslations() > 0 || frameStats.getTotalRotations() > 0) && (saveResult = this.saveCorrectedImage(workImage, fileName)).isFailure()) {
            LOGGER.warning("Failed to save corrected image: " + saveResult.getErrorMessage());
        }
        frameStats.incrementFramesCorrected();
        return ProcessingResult.success(frameStats.buildResult());
    }

    private ProcessingResult<Void> saveCorrectedImage(IcyBufferedImage image, String fileName) {
        try {
            File outputFile = new File(fileName);
            BufferedImage renderedImage = ImageUtil.toRGBImage((Image)image);
            boolean success = ImageUtil.save((RenderedImage)renderedImage, (String)"jpg", (File)outputFile);
            if (!success) {
                return ProcessingResult.failure("Failed to save image: %s", fileName);
            }
            return ProcessingResult.success();
        }
        catch (Exception e) {
            return ProcessingResult.failure("Error saving image: %s", fileName);
        }
    }

    private void cleanupResources() {
    }

    private boolean loadSeqCamDataAndCages(Experiment experiment) {
        return true;
    }

    private static class RegistrationStatistics {
        private int framesProcessed = 0;
        private int framesCorrected = 0;
        private int totalTranslations = 0;
        private int totalRotations = 0;
        private double totalTranslationMagnitude = 0.0;
        private double totalRotationAngle = 0.0;

        private RegistrationStatistics() {
        }

        public void incrementFramesProcessed() {
            ++this.framesProcessed;
        }

        public void incrementFramesCorrected() {
            ++this.framesCorrected;
        }

        public void incrementTranslations() {
            ++this.totalTranslations;
        }

        public void incrementRotations() {
            ++this.totalRotations;
        }

        public void addTranslationMagnitude(double magnitude) {
            this.totalTranslationMagnitude += magnitude;
        }

        public void addRotationAngle(double angle) {
            this.totalRotationAngle += Math.abs(angle);
        }

        public int getTotalTranslations() {
            return this.totalTranslations;
        }

        public int getTotalRotations() {
            return this.totalRotations;
        }

        public RegistrationProcessor.RegistrationResult buildResult() {
            double avgTranslation = this.totalTranslations > 0 ? this.totalTranslationMagnitude / (double)this.totalTranslations : 0.0;
            double avgRotation = this.totalRotations > 0 ? this.totalRotationAngle / (double)this.totalRotations : 0.0;
            return new RegistrationProcessor.RegistrationResult(this.framesProcessed, this.framesCorrected, this.totalTranslations, this.totalRotations, avgTranslation, avgRotation);
        }
    }
}

