/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.tools.JComponents;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class JCheckComboBox
extends JComboBox<CheckableItem> {
    private static final long serialVersionUID = 1L;

    public JCheckComboBox() {
        this.setRenderer(new CheckBoxRenderer());
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox combo = (JComboBox)e.getSource();
                CheckableItem item = (CheckableItem)combo.getSelectedItem();
                if (item != null) {
                    item.setSelected(!item.isSelected());
                    combo.repaint();
                }
                JCheckComboBox.this.setPopupVisible(true);
            }
        });
    }

    public void setItems(List<String> items) {
        DefaultComboBoxModel<CheckableItem> model = new DefaultComboBoxModel<CheckableItem>();
        if (items != null) {
            for (String s : items) {
                model.addElement(new CheckableItem(s, false));
            }
        }
        this.setModel(model);
    }

    public void setSelectedValues(Collection<String> values) {
        if (values == null) {
            return;
        }
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            CheckableItem item = (CheckableItem)model.getElementAt(i);
            item.setSelected(values.contains(item.getText()));
        }
        this.repaint();
    }

    public List<String> getSelectedValues() {
        ArrayList<String> list = new ArrayList<String>();
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            CheckableItem item = (CheckableItem)model.getElementAt(i);
            if (!item.isSelected()) continue;
            list.add(item.getText());
        }
        return list;
    }

    public void clearSelection() {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            ((CheckableItem)model.getElementAt(i)).setSelected(false);
        }
        this.repaint();
    }

    private static class CheckBoxRenderer
    extends JCheckBox
    implements ListCellRenderer<CheckableItem> {
        private static final long serialVersionUID = 1L;

        private CheckBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends CheckableItem> list, CheckableItem value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value != null ? value.getText() : "");
            this.setSelected(value != null ? value.isSelected() : false);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }

    public static class CheckableItem {
        private final String text;
        private boolean selected;

        public CheckableItem(String text, boolean selected) {
            this.text = text;
            this.selected = selected;
        }

        public String getText() {
            return this.text;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean b) {
            this.selected = b;
        }

        public String toString() {
            return this.text;
        }
    }
}

