/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.tools.JComponents;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class MultiSelectDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final DefaultListModel<CheckItem> fullModel = new DefaultListModel();
    private final DefaultListModel<CheckItem> filteredModel = new DefaultListModel();
    private final JList<CheckItem> list = new JList<CheckItem>(this.filteredModel);
    private final JTextField searchField = new JTextField();
    private boolean confirmed = false;

    public static List<String> showDialog(Component parent, String title, List<String> allValues, Collection<String> preSelected) {
        Frame owner = parent != null ? (Frame)SwingUtilities.getWindowAncestor(parent) : null;
        MultiSelectDialog dlg = new MultiSelectDialog(owner, title, allValues, preSelected);
        dlg.setVisible(true);
        if (!dlg.confirmed) {
            return null;
        }
        return dlg.getSelectedValues();
    }

    private MultiSelectDialog(Frame owner, String title, List<String> allValues, Collection<String> preSelected) {
        super(owner, title, true);
        this.setLayout(new BorderLayout(5, 5));
        for (String v : allValues) {
            boolean sel = preSelected != null && preSelected.contains(v);
            this.fullModel.addElement(new CheckItem(v, sel));
        }
        this.copyFilter("");
        this.list.setCellRenderer(new CheckRenderer());
        this.list.setSelectionMode(0);
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int idx = MultiSelectDialog.this.list.locationToIndex(e.getPoint());
                if (idx >= 0) {
                    CheckItem item = (CheckItem)MultiSelectDialog.this.filteredModel.get(idx);
                    item.selected = !item.selected;
                    MultiSelectDialog.this.list.repaint(MultiSelectDialog.this.list.getCellBounds(idx, idx));
                }
            }
        });
        this.searchField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                MultiSelectDialog.this.copyFilter(MultiSelectDialog.this.searchField.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                MultiSelectDialog.this.copyFilter(MultiSelectDialog.this.searchField.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                MultiSelectDialog.this.copyFilter(MultiSelectDialog.this.searchField.getText());
            }
        });
        JPanel top = new JPanel(new BorderLayout(5, 5));
        top.add((Component)new JLabel("Filter:"), "West");
        top.add((Component)this.searchField, "Center");
        JPanel buttons = new JPanel(new FlowLayout(2));
        JButton selectAllBtn = new JButton("Select all");
        JButton clearBtn = new JButton("Clear");
        JButton invertBtn = new JButton("Invert");
        JButton okBtn = new JButton("OK");
        JButton cancelBtn = new JButton("Cancel");
        buttons.add(selectAllBtn);
        buttons.add(clearBtn);
        buttons.add(invertBtn);
        buttons.add(okBtn);
        buttons.add(cancelBtn);
        selectAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiSelectDialog.this.setAllFiltered(true);
            }
        });
        clearBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiSelectDialog.this.setAllFiltered(false);
            }
        });
        invertBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiSelectDialog.this.invertFiltered();
            }
        });
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiSelectDialog.this.confirmed = true;
                MultiSelectDialog.this.dispose();
            }
        });
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiSelectDialog.this.dispose();
            }
        });
        this.add((Component)top, "North");
        this.add((Component)new JScrollPane(this.list), "Center");
        this.add((Component)buttons, "South");
        this.setPreferredSize(new Dimension(360, 420));
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    private void copyFilter(String term) {
        this.filteredModel.clear();
        String t = term != null ? term.trim().toLowerCase() : "";
        for (int i = 0; i < this.fullModel.getSize(); ++i) {
            CheckItem it = this.fullModel.getElementAt(i);
            if (!t.isEmpty() && !it.text.toLowerCase().contains(t)) continue;
            this.filteredModel.addElement(it);
        }
    }

    private void setAllFiltered(boolean sel) {
        for (int i = 0; i < this.filteredModel.getSize(); ++i) {
            this.filteredModel.getElementAt((int)i).selected = sel;
        }
        this.list.repaint();
    }

    private void invertFiltered() {
        for (int i = 0; i < this.filteredModel.getSize(); ++i) {
            CheckItem it = this.filteredModel.getElementAt(i);
            it.selected = !it.selected;
        }
        this.list.repaint();
    }

    private List<String> getSelectedValues() {
        ArrayList<String> out = new ArrayList<String>();
        for (int i = 0; i < this.fullModel.getSize(); ++i) {
            CheckItem it = this.fullModel.getElementAt(i);
            if (!it.selected) continue;
            out.add(it.text);
        }
        return out;
    }

    private static class CheckItem {
        final String text;
        boolean selected;

        CheckItem(String t, boolean s) {
            this.text = t;
            this.selected = s;
        }
    }

    private static class CheckRenderer
    extends JCheckBox
    implements ListCellRenderer<CheckItem> {
        private static final long serialVersionUID = 1L;

        private CheckRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends CheckItem> list, CheckItem value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value != null ? value.text : "");
            this.setSelected(value != null && value.selected);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }
}

