/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.tools.chart;

import java.util.logging.Logger;
import org.jfree.chart.ChartPanel;
import plugins.fmp.multiSPOTS96.experiment.cages.Cage;

public class ChartCagePair {
    private static final Logger LOGGER = Logger.getLogger(ChartCagePair.class.getName());
    private ChartPanel chartPanel;
    private Cage cage;

    public ChartCagePair(ChartPanel chartPanel, Cage cage) {
        this.chartPanel = chartPanel;
        this.cage = cage;
    }

    public ChartPanel getChartPanel() {
        return this.chartPanel;
    }

    public void setChartPanel(ChartPanel chartPanel) {
        if (chartPanel == null) {
            throw new IllegalArgumentException("Chart panel cannot be null");
        }
        this.chartPanel = chartPanel;
    }

    public Cage getCage() {
        return this.cage;
    }

    public void setCage(Cage cage) {
        if (cage == null) {
            throw new IllegalArgumentException("Cage cannot be null");
        }
        this.cage = cage;
    }

    public boolean isComplete() {
        return this.chartPanel != null && this.cage != null;
    }

    public int getCageID() {
        return this.cage != null ? this.cage.getProperties().getCageID() : -1;
    }

    public int getCagePosition() {
        return this.cage != null ? this.cage.getProperties().getCagePosition() : -1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CageChartPair[");
        if (this.cage != null) {
            sb.append("cageID=").append(this.cage.getProperties().getCageID());
            sb.append(", cagePosition=").append(this.cage.getProperties().getCagePosition());
        } else {
            sb.append("cage=null");
        }
        sb.append(", chartPanel=").append(this.chartPanel != null ? "set" : "null");
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ChartCagePair other = (ChartCagePair)obj;
        return this.getCageID() == other.getCageID();
    }

    public int hashCode() {
        return Integer.hashCode(this.getCageID());
    }
}

