/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.tools.imageTransform.transforms;

import icy.image.IcyBufferedImage;
import icy.type.collection.array.Array1DUtil;
import plugins.fmp.multiSPOTS96.tools.imageTransform.ImageTransformFunctionAbstract;
import plugins.fmp.multiSPOTS96.tools.imageTransform.ImageTransformInterface;
import plugins.fmp.multiSPOTS96.tools.imageTransform.ImageTransformOptions;

public class RGBtoHSV
extends ImageTransformFunctionAbstract
implements ImageTransformInterface {
    int channelOut = 0;
    double h;
    double s;
    double v;
    final int UNDEFINED = -1;

    public RGBtoHSV(int channelOut) {
        this.channelOut = channelOut;
    }

    @Override
    public IcyBufferedImage getTransformedImage(IcyBufferedImage sourceImage, ImageTransformOptions options) {
        IcyBufferedImage img = this.functionRGBtoHSB(sourceImage);
        if (this.channelOut >= 0) {
            img = this.functionRGB_keepOneChan(img, this.channelOut);
        }
        return img;
    }

    protected IcyBufferedImage functionRGBtoHSB(IcyBufferedImage sourceImage) {
        IcyBufferedImage img2 = new IcyBufferedImage(sourceImage.getWidth(), sourceImage.getHeight(), 3, sourceImage.getDataType_());
        double[] tabValuesR = Array1DUtil.arrayToDoubleArray((Object)sourceImage.getDataXY(0), (boolean)sourceImage.isSignedDataType());
        double[] tabValuesG = Array1DUtil.arrayToDoubleArray((Object)sourceImage.getDataXY(1), (boolean)sourceImage.isSignedDataType());
        double[] tabValuesB = Array1DUtil.arrayToDoubleArray((Object)sourceImage.getDataXY(2), (boolean)sourceImage.isSignedDataType());
        double[] outValuesH = Array1DUtil.arrayToDoubleArray((Object)img2.getDataXY(0), (boolean)img2.isSignedDataType());
        double[] outValuesS = Array1DUtil.arrayToDoubleArray((Object)img2.getDataXY(1), (boolean)img2.isSignedDataType());
        double[] outValuesV = Array1DUtil.arrayToDoubleArray((Object)img2.getDataXY(2), (boolean)img2.isSignedDataType());
        for (int ky = 0; ky < tabValuesR.length; ++ky) {
            this.NH_RGB_to_HSV(tabValuesR[ky], tabValuesG[ky], tabValuesB[ky]);
            outValuesH[ky] = this.h * 100.0;
            outValuesS[ky] = this.s * 100.0;
            outValuesV[ky] = this.v * 100.0;
        }
        Array1DUtil.doubleArrayToSafeArray((double[])outValuesH, (Object)img2.getDataXY(0), (boolean)false);
        img2.setDataXY(0, img2.getDataXY(0));
        Array1DUtil.doubleArrayToSafeArray((double[])outValuesS, (Object)img2.getDataXY(1), (boolean)false);
        img2.setDataXY(1, img2.getDataXY(1));
        Array1DUtil.doubleArrayToSafeArray((double[])outValuesV, (Object)img2.getDataXY(2), (boolean)false);
        img2.setDataXY(2, img2.getDataXY(2));
        return img2;
    }

    void NH_RGB_to_HSV(double r, double g, double b) {
        double max = Math.max(b, Math.max(r, g));
        double min = Math.min(b, Math.min(r, g));
        this.v = max;
        double d = this.s = max != 0.0 ? (max - min) / max : 0.0;
        if (this.s == 0.0) {
            this.h = -1.0;
        } else {
            double delta = max - min;
            if (r == max) {
                this.h = (g - b) / delta;
            } else if (g == max) {
                this.h = 2.0 + (b - r) / delta;
            } else if (b == max) {
                this.h = 4.0 + (r - g) / delta;
            }
            this.h *= 60.0;
            if (this.h < 0.0) {
                this.h += 360.0;
            }
        }
    }
}

