/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.experiment;

import icy.roi.ROI;
import icy.roi.ROI2D;
import java.util.ArrayList;
import java.util.Iterator;
import plugins.fmp.multiSPOTS96.experiment.Experiment;
import plugins.fmp.multiSPOTS96.experiment.cages.Cage;
import plugins.fmp.multiSPOTS96.experiment.cages.CagesArray;
import plugins.fmp.multiSPOTS96.experiment.spots.Spot;
import plugins.fmp.multiSPOTS96.experiment.spots.SpotString;
import plugins.kernel.roi.roi2d.ROI2DPolygon;
import plugins.kernel.roi.roi2d.ROI2DShape;

public class ExperimentUtils {
    public static void transferCamDataROI2DsToSpots(Experiment exp) {
        if (exp.cagesArray == null) {
            exp.cagesArray = new CagesArray();
        }
        ArrayList<ROI2D> listROIsSpots = exp.seqCamData.getROIsContainingString("spot");
        for (ROI2D roi : listROIsSpots) {
            boolean found = false;
            block1: for (Cage cage : exp.cagesArray.cagesList) {
                for (Spot spot : cage.spotsArray.getSpotsList()) {
                    if (spot.getRoi() == null || !roi.getName().equals(spot.getRoi().getName())) continue;
                    found = true;
                    continue block1;
                }
            }
            if (found) continue;
            String name = roi.getName();
            ROI2DPolygon roi_new = new ROI2DPolygon();
            int cageID = SpotString.getCageIDFromSpotName(name);
            int cagePosition = SpotString.getSpotCagePositionFromSpotName(name);
            if (cageID < 0 || cagePosition < 0) continue;
            Cage cage = exp.cagesArray.getCageFromID(cageID);
            cage.spotsArray.getSpotsList().add(new Spot((ROI2DShape)roi_new));
        }
    }

    public void removeSpotsWithNoCamDataROI(Experiment exp) {
        if (exp.cagesArray == null) {
            exp.cagesArray = new CagesArray();
        }
        ArrayList<ROI2D> listROIsSpots = exp.seqCamData.getROIsContainingString("spot");
        for (Cage cage : exp.cagesArray.cagesList) {
            Iterator<Spot> iterator = cage.spotsArray.getSpotsList().iterator();
            while (iterator.hasNext()) {
                Spot spot = iterator.next();
                boolean found = false;
                for (ROI rOI : listROIsSpots) {
                    if (!rOI.getName().equals(spot.getRoi().getName())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                iterator.remove();
            }
        }
    }

    public static void transferSpotsToCamDataSequence(Experiment exp) {
        if (exp.cagesArray == null) {
            return;
        }
        ArrayList<ROI2D> listROISSpots = exp.seqCamData.getROIsContainingString("spot");
        for (Cage cage : exp.cagesArray.cagesList) {
            for (Spot spot : cage.spotsArray.getSpotsList()) {
                boolean found = false;
                for (ROI rOI : listROISSpots) {
                    if (!rOI.getName().equals(spot.getRoi().getName())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                exp.seqCamData.getSequence().addROI((ROI)spot.getRoi());
            }
        }
    }

    public static void transferCagesToCamDataSequence(Experiment exp) {
        if (exp.cagesArray == null) {
            return;
        }
        ArrayList<ROI2D> roisAlreadyTransferred = exp.seqCamData.getROIsContainingString("cage");
        for (Cage cage : exp.cagesArray.cagesList) {
            boolean found = false;
            for (ROI rOI : roisAlreadyTransferred) {
                if (!rOI.getName().equals(cage.getRoi().getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            exp.seqCamData.getSequence().addROI((ROI)cage.getRoi());
        }
    }

    public static void removeCageAndSpotROISFromCamDataSequence(Experiment exp) {
        if (exp.cagesArray == null) {
            return;
        }
        ArrayList<ROI2D> roisCages = exp.seqCamData.getROIsContainingString("cage");
        exp.seqCamData.getSequence().removeROIs(roisCages, false);
        ArrayList<ROI2D> roisSpots = exp.seqCamData.getROIsContainingString("spot");
        exp.seqCamData.getSequence().removeROIs(roisSpots, false);
    }
}

