/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.experiment.sequence;

public class TimeRange {
    private final long firstImageMs;
    private final long lastImageMs;
    private final long binDurationMs;

    public TimeRange(long firstImageMs, long lastImageMs, long binDurationMs) {
        this.firstImageMs = firstImageMs;
        this.lastImageMs = lastImageMs;
        this.binDurationMs = binDurationMs;
    }

    public long getFirstImageMs() {
        return this.firstImageMs;
    }

    public long getLastImageMs() {
        return this.lastImageMs;
    }

    public long getBinDurationMs() {
        return this.binDurationMs;
    }

    public long getTotalDurationMs() {
        return this.lastImageMs - this.firstImageMs;
    }

    public boolean isValid() {
        return this.firstImageMs <= this.lastImageMs && this.binDurationMs > 0L;
    }

    public String toString() {
        return String.format("TimeRange{first=%d, last=%d, binDuration=%d ms}", this.firstImageMs, this.lastImageMs, this.binDurationMs);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TimeRange timeRange = (TimeRange)obj;
        return this.firstImageMs == timeRange.firstImageMs && this.lastImageMs == timeRange.lastImageMs && this.binDurationMs == timeRange.binDurationMs;
    }

    public int hashCode() {
        int result = Long.hashCode(this.firstImageMs);
        result = 31 * result + Long.hashCode(this.lastImageMs);
        result = 31 * result + Long.hashCode(this.binDurationMs);
        return result;
    }
}

