/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.tools;

import icy.util.XMLUtil;
import java.io.File;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.fmp.multiSPOTS96.experiment.Experiment;
import plugins.fmp.multiSPOTS96.experiment.ExperimentDirectories;
import plugins.fmp.multiSPOTS96.experiment.ExperimentProperties;
import plugins.fmp.multiSPOTS96.tools.toExcel.EnumXLSColumnHeader;

public class LazyExperiment
extends Experiment {
    private static final Logger LOGGER = Logger.getLogger(LazyExperiment.class.getName());
    private final ExperimentMetadata metadata;
    private boolean isLoaded = false;
    private boolean experimentPropertiesLoaded = false;
    private ExperimentProperties cachedExperimentProperties = null;
    private static final String ID_MCEXPERIMENT = "MCexperiment";
    private static final String ID_MS96_experiment_XML = "MS96_experiment.xml";

    public LazyExperiment(ExperimentMetadata metadata) {
        this.metadata = metadata;
        this.setResultsDirectory(metadata.getResultsDirectory());
    }

    @Override
    public String toString() {
        return this.metadata.getCameraDirectory();
    }

    public void loadIfNeeded() {
        if (!this.isLoaded) {
            try {
                ExperimentDirectories expDirectories = new ExperimentDirectories();
                if (expDirectories.getDirectoriesFromExptPath(this.metadata.getBinDirectory(), this.metadata.getCameraDirectory())) {
                    Experiment fullExp = new Experiment(expDirectories);
                    this.seqCamData = fullExp.seqCamData;
                    this.cagesArray = fullExp.cagesArray;
                    this.firstImage_FileTime = fullExp.firstImage_FileTime;
                    this.lastImage_FileTime = fullExp.lastImage_FileTime;
                    this.col = fullExp.col;
                    this.chainToPreviousExperiment = fullExp.chainToPreviousExperiment;
                    this.chainToNextExperiment = fullExp.chainToNextExperiment;
                    this.chainImageFirst_ms = fullExp.chainImageFirst_ms;
                    this.experimentID = fullExp.experimentID;
                    this.isLoaded = true;
                }
            }
            catch (Exception e) {
                LOGGER.warning("Error loading experiment " + this.metadata.getCameraDirectory() + ": " + e.getMessage());
            }
        }
    }

    public boolean loadPropertiesIfNeeded() {
        if (!this.experimentPropertiesLoaded) {
            try {
                String xmlFileName;
                File xmlFile;
                String resultsDir = this.metadata.getResultsDirectory();
                if (resultsDir == null) {
                    resultsDir = this.metadata.getCameraDirectory() + File.separator + "results";
                }
                if (!(xmlFile = new File(xmlFileName = resultsDir + File.separator + ID_MS96_experiment_XML)).exists()) {
                    LOGGER.warning("XML file not found: " + xmlFileName);
                    return false;
                }
                Document doc = XMLUtil.loadDocument((String)xmlFileName);
                if (doc == null) {
                    LOGGER.warning("Could not load XML document from " + xmlFileName);
                    return false;
                }
                Element node = XMLUtil.getElement((Node)XMLUtil.getRootElement((Document)doc), (String)ID_MCEXPERIMENT);
                if (node == null) {
                    LOGGER.warning("Could not find MCexperiment node in XML");
                    return false;
                }
                this.cachedExperimentProperties = new ExperimentProperties();
                this.cachedExperimentProperties.loadXML_Properties(node);
                this.experimentPropertiesLoaded = true;
                return true;
            }
            catch (Exception e) {
                LOGGER.warning("Error loading properties for experiment " + this.metadata.getCameraDirectory() + ": " + e.getMessage());
                return false;
            }
        }
        return true;
    }

    public String getFieldValue(EnumXLSColumnHeader field) {
        if (this.loadPropertiesIfNeeded() && this.cachedExperimentProperties != null) {
            return this.cachedExperimentProperties.getExperimentField(field);
        }
        return "..";
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public boolean isPropertiesLoaded() {
        return this.experimentPropertiesLoaded;
    }

    public ExperimentMetadata getMetadata() {
        return this.metadata;
    }

    public ExperimentProperties getCachedProperties() {
        this.loadPropertiesIfNeeded();
        return this.cachedExperimentProperties;
    }

    public static class ExperimentMetadata {
        private final String cameraDirectory;
        private final String resultsDirectory;
        private final String binDirectory;

        public ExperimentMetadata(String cameraDirectory, String resultsDirectory, String binDirectory) {
            this.cameraDirectory = cameraDirectory;
            this.resultsDirectory = resultsDirectory;
            this.binDirectory = binDirectory;
        }

        public String getCameraDirectory() {
            return this.cameraDirectory;
        }

        public String getResultsDirectory() {
            return this.resultsDirectory;
        }

        public String getBinDirectory() {
            return this.binDirectory;
        }

        public String toString() {
            return this.cameraDirectory;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ExperimentMetadata that = (ExperimentMetadata)obj;
            return this.cameraDirectory.equals(that.cameraDirectory) && this.resultsDirectory.equals(that.resultsDirectory) && this.binDirectory.equals(that.binDirectory);
        }

        public int hashCode() {
            int result = this.cameraDirectory != null ? this.cameraDirectory.hashCode() : 0;
            result = 31 * result + (this.resultsDirectory != null ? this.resultsDirectory.hashCode() : 0);
            result = 31 * result + (this.binDirectory != null ? this.binDirectory.hashCode() : 0);
            return result;
        }
    }
}

