/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.tools.ROI2D;

public class ROI2DException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final String operation;
    private final String context;

    public ROI2DException(String message) {
        super(message);
        this.operation = null;
        this.context = null;
    }

    public ROI2DException(String message, Throwable cause) {
        super(message, cause);
        this.operation = null;
        this.context = null;
    }

    public ROI2DException(String message, String operation, String context) {
        super(ROI2DException.buildMessage(message, operation, context));
        this.operation = operation;
        this.context = context;
    }

    public ROI2DException(String message, Throwable cause, String operation, String context) {
        super(ROI2DException.buildMessage(message, operation, context), cause);
        this.operation = operation;
        this.context = context;
    }

    public String getOperation() {
        return this.operation;
    }

    public String getContext() {
        return this.context;
    }

    private static String buildMessage(String message, String operation, String context) {
        StringBuilder sb = new StringBuilder(message);
        if (operation != null) {
            sb.append(" [Operation: ").append(operation).append("]");
        }
        if (context != null) {
            sb.append(" [Context: ").append(context).append("]");
        }
        return sb.toString();
    }
}

