/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.tools.imageTransform;

import icy.image.IcyBufferedImage;
import icy.type.collection.array.Array1DUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ArrayOperationCache {
    private final Map<String, CachedArrays> cache = new ConcurrentHashMap<String, CachedArrays>();
    private final int maxCacheSize;

    public ArrayOperationCache() {
        this(100);
    }

    public ArrayOperationCache(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
    }

    public double[][] getRGBArrays(IcyBufferedImage sourceImage) {
        CachedArrays cached;
        if (sourceImage == null) {
            return null;
        }
        String cacheKey = this.generateCacheKey(sourceImage);
        boolean isCacheable = this.isCacheable(sourceImage);
        if (isCacheable && (cached = this.cache.get(cacheKey)) != null && cached.isValid(sourceImage)) {
            return cached.getRGBArrays();
        }
        double[][] rgbArrays = this.extractRGBArrays(sourceImage);
        if (isCacheable && this.cache.size() < this.maxCacheSize) {
            this.cache.put(cacheKey, new CachedArrays(sourceImage, rgbArrays));
        }
        return rgbArrays;
    }

    public double[] linearCombination(double[][] rgbArrays, double[] weights) {
        if (rgbArrays == null || rgbArrays.length < 3 || weights == null || weights.length < 3) {
            throw new IllegalArgumentException("Invalid RGB arrays or weights");
        }
        double[] r = rgbArrays[0];
        double[] g = rgbArrays[1];
        double[] b = rgbArrays[2];
        double[] result = new double[r.length];
        double wR = weights[0];
        double wG = weights[1];
        double wB = weights[2];
        for (int i = 0; i < result.length; ++i) {
            result[i] = r[i] * wR + g[i] * wG + b[i] * wB;
        }
        return result;
    }

    public double[] arrayDifference(double[] array1, double[] array2) {
        if (array1 == null || array2 == null || array1.length != array2.length) {
            throw new IllegalArgumentException("Arrays must be non-null and same length");
        }
        double[] result = new double[array1.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = array1[i] - array2[i];
        }
        return result;
    }

    public double[] arrayAbsoluteDifference(double[] array1, double[] array2) {
        if (array1 == null || array2 == null || array1.length != array2.length) {
            throw new IllegalArgumentException("Arrays must be non-null and same length");
        }
        double[] result = new double[array1.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Math.abs(array1[i] - array2[i]);
        }
        return result;
    }

    public void clearCache() {
        this.cache.clear();
    }

    public int getCacheSize() {
        return this.cache.size();
    }

    private String generateCacheKey(IcyBufferedImage image) {
        return String.format("img_%d_%d_%d_%d", image.getWidth(), image.getHeight(), image.getSizeC(), System.identityHashCode(image));
    }

    private boolean isCacheable(IcyBufferedImage image) {
        int pixelCount = image.getWidth() * image.getHeight();
        return pixelCount <= 2073600;
    }

    private double[][] extractRGBArrays(IcyBufferedImage sourceImage) {
        int c;
        int channels = Math.min(3, sourceImage.getSizeC());
        double[][] arrays = new double[3][];
        for (c = 0; c < channels; ++c) {
            arrays[c] = Array1DUtil.arrayToDoubleArray((Object)sourceImage.getDataXY(c), (boolean)sourceImage.isSignedDataType());
        }
        for (c = channels; c < 3; ++c) {
            arrays[c] = new double[sourceImage.getWidth() * sourceImage.getHeight()];
        }
        return arrays;
    }

    private static class CachedArrays {
        private final double[][] rgbArrays;
        private final long timestamp;
        private final int width;
        private final int height;
        private final int channels;

        public CachedArrays(IcyBufferedImage sourceImage, double[][] rgbArrays) {
            this.rgbArrays = rgbArrays;
            this.timestamp = System.currentTimeMillis();
            this.width = sourceImage.getWidth();
            this.height = sourceImage.getHeight();
            this.channels = sourceImage.getSizeC();
        }

        public double[][] getRGBArrays() {
            return this.rgbArrays;
        }

        public boolean isValid(IcyBufferedImage sourceImage) {
            return sourceImage.getWidth() == this.width && sourceImage.getHeight() == this.height && sourceImage.getSizeC() == this.channels;
        }
    }
}

