/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.series;

import icy.gui.frame.progress.ProgressFrame;
import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageCursor;
import icy.sequence.Sequence;
import icy.system.SystemUtil;
import icy.system.thread.Processor;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import plugins.fmp.multiSPOTS96.experiment.Experiment;
import plugins.fmp.multiSPOTS96.experiment.cages.Cage;
import plugins.fmp.multiSPOTS96.experiment.sequence.SequenceCamData;
import plugins.fmp.multiSPOTS96.experiment.spots.Spot;
import plugins.fmp.multiSPOTS96.series.BuildSeries;
import plugins.fmp.multiSPOTS96.series.ResultsThreshold;
import plugins.fmp.multiSPOTS96.tools.ROI2D.ROI2DProcessingException;
import plugins.fmp.multiSPOTS96.tools.ROI2D.ROI2DValidationException;
import plugins.fmp.multiSPOTS96.tools.ROI2D.ROI2DWithMask;
import plugins.fmp.multiSPOTS96.tools.ViewerFMP;
import plugins.fmp.multiSPOTS96.tools.imageTransform.ImageTransformInterface;
import plugins.fmp.multiSPOTS96.tools.imageTransform.ImageTransformOptions;

public class BuildSpotsMeasures
extends BuildSeries {
    public Sequence seqData = new Sequence();
    private ViewerFMP vData = null;
    private ImageTransformOptions transformOptions01 = null;
    ImageTransformInterface transformFunctionSpot = null;
    ImageTransformOptions transformOptions02 = null;
    ImageTransformInterface transformFunctionFly = null;

    @Override
    void analyzeExperiment(Experiment exp) {
        this.getTimeLimitsOfSequence(exp);
        this.loadExperimentDataToMeasureSpots(exp);
        exp.cagesArray.setReadyToAnalyze(true, this.options);
        this.openViewers(exp);
        if (this.measureSpots(exp)) {
            this.saveComputation(exp);
        }
        exp.cagesArray.setReadyToAnalyze(false, this.options);
        this.closeViewers();
    }

    private boolean loadExperimentDataToMeasureSpots(Experiment exp) {
        exp.load_MS96_experiment();
        exp.seqCamData.attachSequence(exp.seqCamData.getImageLoader().initSequenceFromFirstImage(exp.seqCamData.getImagesList(true)));
        boolean flag = exp.load_MS96_cages();
        if (exp.seqCamData.getTimeManager().getBinDurationMs() == 0L) {
            exp.loadFileIntervalsFromSeqCamData();
        }
        return flag;
    }

    private void saveComputation(Experiment exp) {
        String directory = exp.getDirectoryToSaveResults();
        if (directory == null) {
            return;
        }
        exp.cagesArray.transferMeasuresToLevel2D();
        exp.cagesArray.medianFilterFromSumToSumClean();
        exp.save_MS96_experiment();
        exp.save_MS96_spotsMeasures();
    }

    private void initMeasureSpots(Experiment exp) {
        this.initMasks2D(exp);
        this.initSpotsDataArrays(exp);
        if (this.transformFunctionSpot == null) {
            this.transformOptions01 = new ImageTransformOptions();
            this.transformOptions01.transformOption = this.options.transform01;
            this.transformOptions01.copyResultsToThe3planes = false;
            this.transformOptions01.setSingleThreshold(this.options.spotThreshold, this.options.spotThresholdUp);
            this.transformFunctionSpot = this.options.transform01.getFunction();
            this.transformOptions02 = new ImageTransformOptions();
            this.transformOptions02.transformOption = this.options.transform02;
            this.transformOptions02.copyResultsToThe3planes = false;
            this.transformFunctionFly = this.options.transform02.getFunction();
        }
    }

    private boolean measureSpots(Experiment exp) {
        if (exp.cagesArray.getTotalNumberOfSpots() < 1) {
            System.out.println("DetectAreas:measureAreas Abort (1): nbspots = 0");
            return false;
        }
        this.threadRunning = true;
        this.stopFlag = false;
        if (!exp.seqCamData.build_MsTimesArray_From_FileNamesList()) {
            return false;
        }
        int iiFirst = 0;
        int iiLast = exp.seqCamData.getImageLoader().getNTotalFrames();
        this.vData.setTitle(exp.seqCamData.getCSCamFileName() + ": " + iiFirst + "-" + iiLast);
        ProgressFrame progressBar1 = new ProgressFrame("Analyze stack");
        Processor processor = new Processor(Math.min(this.options.maxConcurrentTasks, SystemUtil.getNumberOfCPUs()));
        processor.setThreadName("measureSpots");
        processor.setPriority(5);
        this.initMeasureSpots(exp);
        for (int batchStart = iiFirst; batchStart < iiLast && !this.stopFlag; batchStart += this.options.batchSize) {
            int batchEnd = Math.min(batchStart + this.options.batchSize, iiLast);
            this.processFrameBatch(exp, batchStart, batchEnd, iiFirst, iiLast, processor, progressBar1);
            System.gc();
        }
        progressBar1.close();
        return true;
    }

    private void processFrameBatch(final Experiment exp, int batchStart, int batchEnd, final int iiFirst, int iiLast, Processor processor, ProgressFrame progressBar1) {
        ArrayList tasks = new ArrayList(batchEnd - batchStart);
        for (int ii = batchStart; ii < batchEnd; ++ii) {
            if (this.options.concurrentDisplay) {
                IcyBufferedImage sourceImage0 = this.imageIORead(exp.seqCamData.getFileNameFromImageList(ii));
                this.seqData.setImage(0, 0, (BufferedImage)sourceImage0);
                this.vData.setTitle("Frame #" + ii + " /" + iiLast);
            }
            final int t = ii;
            progressBar1.setMessage("Analyze frame: " + t + "//" + iiLast);
            String fileName = exp.seqCamData.getFileNameFromImageList(t);
            if (fileName == null) {
                System.out.println("filename null at t=" + t);
                continue;
            }
            final IcyBufferedImage sourceImage = this.imageIORead(fileName);
            tasks.add(processor.submit(new Runnable(){

                @Override
                public void run() {
                    BuildSpotsMeasures.this.processSingleFrame(exp, t, iiFirst, sourceImage);
                }
            }));
        }
        this.waitFuturesCompletion(processor, tasks, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSingleFrame(Experiment exp, int frameIndex, int iiFirst, IcyBufferedImage sourceImage) {
        IcyBufferedImage transformToMeasureArea = null;
        IcyBufferedImage transformToDetectFly = null;
        IcyBufferedImageCursor cursorToDetectFly = null;
        IcyBufferedImageCursor cursorToMeasureArea = null;
        try {
            transformToMeasureArea = this.transformFunctionSpot.getTransformedImage(sourceImage, this.transformOptions01);
            transformToDetectFly = this.transformFunctionFly.getTransformedImage(sourceImage, this.transformOptions02);
            cursorToDetectFly = new IcyBufferedImageCursor(transformToDetectFly);
            cursorToMeasureArea = new IcyBufferedImageCursor(transformToMeasureArea);
            int ii_local = frameIndex - iiFirst;
            for (Cage cage : exp.cagesArray.cagesList) {
                for (Spot spot : cage.spotsArray.getSpotsList()) {
                    if (!spot.isReadyForAnalysis()) continue;
                    ROI2DWithMask roiT = spot.getROIMask();
                    ResultsThreshold results = this.measureSpotOverThreshold(cursorToMeasureArea, cursorToDetectFly, roiT);
                    spot.getFlyPresent().setIsPresentAt(ii_local, results.nPoints_fly_present);
                    spot.getSum().setValueAt(ii_local, results.sumOverThreshold / (double)results.npoints_in);
                    if (results.nPoints_no_fly == results.npoints_in) continue;
                    spot.getSum().setValueAt(ii_local, results.sumTot_no_fly_over_threshold / (double)results.nPoints_no_fly);
                }
            }
        }
        finally {
            transformToMeasureArea = null;
            transformToDetectFly = null;
            cursorToDetectFly = null;
            cursorToMeasureArea = null;
        }
    }

    private ResultsThreshold measureSpotOverThreshold(IcyBufferedImageCursor cursorToMeasureArea, IcyBufferedImageCursor cursorToDetectFly, ROI2DWithMask roiT) {
        ResultsThreshold result = new ResultsThreshold();
        if (this.options.usePrimitiveArrays) {
            int[][] maskCoords = roiT.getMaskPointsAsArrays();
            if (maskCoords == null) {
                result.npoints_in = 0;
                return result;
            }
            int[] maskX = maskCoords[0];
            int[] maskY = maskCoords[1];
            result.npoints_in = maskX.length;
            for (int offset = 0; offset < maskX.length; ++offset) {
                int x = maskX[offset];
                int y = maskY[offset];
                int value = (int)cursorToMeasureArea.get(x, y, 0);
                int value_to_detect_fly = (int)cursorToDetectFly.get(x, y, 0);
                boolean isFlyThere = this.isFlyPresent(value_to_detect_fly);
                if (!isFlyThere) {
                    ++result.nPoints_no_fly;
                } else {
                    ++result.nPoints_fly_present;
                }
                if (!this.isOverThreshold(value)) continue;
                result.sumOverThreshold += (double)value;
                ++result.nPointsOverThreshold;
                if (isFlyThere) continue;
                result.sumTot_no_fly_over_threshold += (double)value;
            }
        } else {
            Point[] maskPoints = roiT.getMaskPoints();
            if (maskPoints == null) {
                result.npoints_in = 0;
                return result;
            }
            result.npoints_in = maskPoints.length;
            for (int offset = 0; offset < maskPoints.length; ++offset) {
                Point pt = maskPoints[offset];
                int value = (int)cursorToMeasureArea.get((int)pt.getX(), (int)pt.getY(), 0);
                int value_to_detect_fly = (int)cursorToDetectFly.get((int)pt.getX(), (int)pt.getY(), 0);
                boolean isFlyThere = this.isFlyPresent(value_to_detect_fly);
                if (!isFlyThere) {
                    ++result.nPoints_no_fly;
                } else {
                    ++result.nPoints_fly_present;
                }
                if (!this.isOverThreshold(value)) continue;
                result.sumOverThreshold += (double)value;
                ++result.nPointsOverThreshold;
                if (isFlyThere) continue;
                result.sumTot_no_fly_over_threshold += (double)value;
            }
        }
        return result;
    }

    private boolean isFlyPresent(double value) {
        boolean flag;
        boolean bl = flag = value > (double)this.options.flyThreshold;
        if (!this.options.flyThresholdUp) {
            flag = !flag;
        }
        return flag;
    }

    private boolean isOverThreshold(double value) {
        boolean flag;
        boolean bl = flag = value > (double)this.options.spotThreshold;
        if (!this.options.spotThresholdUp) {
            flag = !flag;
        }
        return flag;
    }

    private void initSpotsDataArrays(Experiment exp) {
        int nFrames = exp.seqCamData.getImageLoader().getNTotalFrames();
        int spotArrayGlobalIndex = 0;
        for (Cage cage : exp.cagesArray.cagesList) {
            int spotPosition = 0;
            for (Spot spot : cage.spotsArray.getSpotsList()) {
                spot.getProperties().setCagePosition(spotPosition);
                spot.getProperties().setCageID(cage.getProperties().getCageID());
                spot.getProperties().setSpotArrayIndex(spotArrayGlobalIndex);
                spot.getSum().setValues(new double[nFrames]);
                spot.getSumClean().setValues(new double[nFrames]);
                spot.getFlyPresent().setIsPresent(new int[nFrames]);
                ++spotArrayGlobalIndex;
                ++spotPosition;
            }
        }
    }

    private void initMasks2D(Experiment exp) {
        SequenceCamData seqCamData = exp.seqCamData;
        if (seqCamData.getSequence() == null) {
            seqCamData.attachSequence(exp.seqCamData.getImageLoader().initSequenceFromFirstImage(exp.seqCamData.getImagesList(true)));
        }
        for (Cage cage : exp.cagesArray.cagesList) {
            for (Spot spot : cage.spotsArray.getSpotsList()) {
                ROI2DWithMask roiT = null;
                try {
                    roiT = new ROI2DWithMask(spot.getRoi());
                    roiT.buildMask2DFromInputRoi();
                }
                catch (ROI2DProcessingException | ROI2DValidationException e) {
                    System.err.println("Error building mask for ROI: " + e.getMessage());
                    e.printStackTrace();
                }
                spot.setROIMask(roiT);
            }
        }
    }

    private void closeViewers() {
        this.closeViewer(this.vData);
        this.closeSequence(this.seqData);
    }

    private void openViewers(final Experiment exp) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    BuildSpotsMeasures.this.seqData = BuildSpotsMeasures.this.newSequence(exp.seqCamData.getCSCamFileName(), exp.seqCamData.getSeqImage(0, 0));
                    BuildSpotsMeasures.this.vData = new ViewerFMP(BuildSpotsMeasures.this.seqData, true, true);
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

