/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import plugins.fmp.multiSPOTS96.experiment.Experiment;
import plugins.fmp.multiSPOTS96.experiment.ExperimentProperties;
import plugins.fmp.multiSPOTS96.experiment.cages.Cage;
import plugins.fmp.multiSPOTS96.experiment.spots.Spot;
import plugins.fmp.multiSPOTS96.tools.DescriptorsIO;
import plugins.fmp.multiSPOTS96.tools.JComponents.JComboBoxExperimentLazy;
import plugins.fmp.multiSPOTS96.tools.LazyExperiment;
import plugins.fmp.multiSPOTS96.tools.toExcel.EnumXLSColumnHeader;

public class DescriptorIndex {
    private volatile boolean ready = false;
    private Map<String, ExperimentProperties> propertiesByResultsDir = new HashMap<String, ExperimentProperties>();
    private EnumMap<EnumXLSColumnHeader, TreeSet<String>> distinctByField = new EnumMap(EnumXLSColumnHeader.class);

    public DescriptorIndex() {
        this.initializeDistinctMaps();
    }

    private void initializeDistinctMaps() {
        this.distinctByField.put(EnumXLSColumnHeader.EXP_EXPT, new TreeSet());
        this.distinctByField.put(EnumXLSColumnHeader.EXP_BOXID, new TreeSet());
        this.distinctByField.put(EnumXLSColumnHeader.EXP_STIM1, new TreeSet());
        this.distinctByField.put(EnumXLSColumnHeader.EXP_CONC1, new TreeSet());
        this.distinctByField.put(EnumXLSColumnHeader.EXP_STRAIN, new TreeSet());
        this.distinctByField.put(EnumXLSColumnHeader.EXP_SEX, new TreeSet());
        this.distinctByField.put(EnumXLSColumnHeader.EXP_STIM2, new TreeSet());
        this.distinctByField.put(EnumXLSColumnHeader.EXP_CONC2, new TreeSet());
        this.distinctByField.put(EnumXLSColumnHeader.CAGE_SEX, new TreeSet());
        this.distinctByField.put(EnumXLSColumnHeader.CAGE_STRAIN, new TreeSet());
        this.distinctByField.put(EnumXLSColumnHeader.CAGE_AGE, new TreeSet());
        this.distinctByField.put(EnumXLSColumnHeader.SPOT_STIM, new TreeSet());
        this.distinctByField.put(EnumXLSColumnHeader.SPOT_CONC, new TreeSet());
        this.distinctByField.put(EnumXLSColumnHeader.SPOT_VOLUME, new TreeSet());
    }

    public void clear() {
        this.ready = false;
        this.propertiesByResultsDir.clear();
        for (TreeSet<String> set : this.distinctByField.values()) {
            set.clear();
        }
    }

    public boolean isReady() {
        return this.ready;
    }

    public void preloadFromCombo(final JComboBoxExperimentLazy combo, final Runnable onDone) {
        this.clear();
        final int nitems = combo.getItemCount();
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                HashMap<String, ExperimentProperties> propsLocal = new HashMap<String, ExperimentProperties>(nitems);
                EnumMap distinctLocal = new EnumMap(EnumXLSColumnHeader.class);
                for (Map.Entry e : DescriptorIndex.this.distinctByField.entrySet()) {
                    distinctLocal.put((EnumXLSColumnHeader)((Object)e.getKey()), new TreeSet());
                }
                for (int i = 0; i < nitems; ++i) {
                    Experiment exp = combo.getItemAtNoLoad(i);
                    if (exp == null) continue;
                    String resDir = exp.getResultsDirectory();
                    Map<EnumXLSColumnHeader, List<String>> preDicts = DescriptorsIO.readDescriptors(resDir);
                    if (preDicts != null && !preDicts.isEmpty()) {
                        for (Map.Entry<EnumXLSColumnHeader, List<String>> e : preDicts.entrySet()) {
                            TreeSet set = (TreeSet)distinctLocal.get((Object)e.getKey());
                            if (set == null) continue;
                            set.addAll((Collection)e.getValue());
                        }
                        continue;
                    }
                    ExperimentProperties props = null;
                    if (exp instanceof LazyExperiment) {
                        LazyExperiment lexp = (LazyExperiment)exp;
                        lexp.loadPropertiesIfNeeded();
                        props = lexp.getCachedProperties();
                    } else {
                        exp.load_MS96_experiment();
                        props = exp.getProperties();
                    }
                    if (props == null || resDir == null) continue;
                    propsLocal.put(resDir, props);
                    DescriptorIndex.this.updateDistinctLocal(distinctLocal, props);
                    try {
                        exp.load_MS96_cages();
                        if (exp.cagesArray == null || exp.cagesArray.cagesList == null) continue;
                        for (Cage cage : exp.cagesArray.cagesList) {
                            DescriptorIndex.this.addIfNotEmpty((Set)distinctLocal.get((Object)EnumXLSColumnHeader.CAGE_SEX), cage.getField(EnumXLSColumnHeader.CAGE_SEX));
                            DescriptorIndex.this.addIfNotEmpty((Set)distinctLocal.get((Object)EnumXLSColumnHeader.CAGE_STRAIN), cage.getField(EnumXLSColumnHeader.CAGE_STRAIN));
                            DescriptorIndex.this.addIfNotEmpty((Set)distinctLocal.get((Object)EnumXLSColumnHeader.CAGE_AGE), cage.getField(EnumXLSColumnHeader.CAGE_AGE));
                            if (cage.spotsArray == null || cage.spotsArray.getSpotsList() == null) continue;
                            for (Spot spot : cage.spotsArray.getSpotsList()) {
                                DescriptorIndex.this.addIfNotEmpty((Set)distinctLocal.get((Object)EnumXLSColumnHeader.SPOT_STIM), spot.getField(EnumXLSColumnHeader.SPOT_STIM));
                                DescriptorIndex.this.addIfNotEmpty((Set)distinctLocal.get((Object)EnumXLSColumnHeader.SPOT_CONC), spot.getField(EnumXLSColumnHeader.SPOT_CONC));
                                DescriptorIndex.this.addIfNotEmpty((Set)distinctLocal.get((Object)EnumXLSColumnHeader.SPOT_VOLUME), spot.getField(EnumXLSColumnHeader.SPOT_VOLUME));
                            }
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                DescriptorIndex.this.propertiesByResultsDir.clear();
                DescriptorIndex.this.propertiesByResultsDir.putAll(propsLocal);
                for (EnumXLSColumnHeader field : DescriptorIndex.this.distinctByField.keySet()) {
                    TreeSet set = (TreeSet)DescriptorIndex.this.distinctByField.get((Object)field);
                    set.clear();
                    set.addAll((Collection)distinctLocal.get((Object)field));
                }
                DescriptorIndex.this.ready = true;
                return null;
            }

            @Override
            protected void done() {
                if (onDone != null) {
                    SwingUtilities.invokeLater(onDone);
                }
            }
        }.execute();
    }

    private void updateDistinctLocal(EnumMap<EnumXLSColumnHeader, TreeSet<String>> distinctLocal, ExperimentProperties props) {
        this.addIfNotEmpty((Set<String>)distinctLocal.get((Object)EnumXLSColumnHeader.EXP_EXPT), props.getExperimentField(EnumXLSColumnHeader.EXP_EXPT));
        this.addIfNotEmpty((Set<String>)distinctLocal.get((Object)EnumXLSColumnHeader.EXP_BOXID), props.getExperimentField(EnumXLSColumnHeader.EXP_BOXID));
        this.addIfNotEmpty((Set<String>)distinctLocal.get((Object)EnumXLSColumnHeader.EXP_STIM1), props.getExperimentField(EnumXLSColumnHeader.EXP_STIM1));
        this.addIfNotEmpty((Set<String>)distinctLocal.get((Object)EnumXLSColumnHeader.EXP_CONC1), props.getExperimentField(EnumXLSColumnHeader.EXP_CONC1));
        this.addIfNotEmpty((Set<String>)distinctLocal.get((Object)EnumXLSColumnHeader.EXP_STRAIN), props.getExperimentField(EnumXLSColumnHeader.EXP_STRAIN));
        this.addIfNotEmpty((Set<String>)distinctLocal.get((Object)EnumXLSColumnHeader.EXP_SEX), props.getExperimentField(EnumXLSColumnHeader.EXP_SEX));
        this.addIfNotEmpty((Set<String>)distinctLocal.get((Object)EnumXLSColumnHeader.EXP_STIM2), props.getExperimentField(EnumXLSColumnHeader.EXP_STIM2));
        this.addIfNotEmpty((Set<String>)distinctLocal.get((Object)EnumXLSColumnHeader.EXP_CONC2), props.getExperimentField(EnumXLSColumnHeader.EXP_CONC2));
    }

    private void addIfNotEmpty(Set<String> set, String value) {
        if (value != null && !value.isEmpty()) {
            set.add(value);
        }
    }

    public List<String> getDistinctValues(EnumXLSColumnHeader field) {
        TreeSet<String> set = this.distinctByField.get((Object)field);
        if (set == null) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(set);
    }

    public synchronized void addValue(EnumXLSColumnHeader field, String value) {
        if (value == null) {
            return;
        }
        String v = value.trim();
        if (v.isEmpty()) {
            return;
        }
        TreeSet<String> set = this.distinctByField.get((Object)field);
        if (set != null) {
            set.add(v);
        }
    }

    public synchronized void removeValue(EnumXLSColumnHeader field, String value) {
        if (value == null) {
            return;
        }
        String v = value.trim();
        if (v.isEmpty()) {
            return;
        }
        TreeSet<String> set = this.distinctByField.get((Object)field);
        if (set != null) {
            set.remove(v);
        }
    }

    public List<String> getDistinctValuesForExperiments(List<Experiment> experiments, EnumXLSColumnHeader field) {
        TreeSet<String> set = new TreeSet<String>();
        for (Experiment exp : experiments) {
            String value;
            if (exp == null) continue;
            ExperimentProperties props = this.propertiesByResultsDir.get(exp.getResultsDirectory());
            if (props == null) {
                if (exp instanceof LazyExperiment) {
                    LazyExperiment lexp = (LazyExperiment)exp;
                    lexp.loadPropertiesIfNeeded();
                    props = lexp.getCachedProperties();
                } else {
                    exp.load_MS96_experiment();
                    props = exp.getProperties();
                }
            }
            if (props == null || (value = props.getExperimentField(field)) == null || value.isEmpty()) continue;
            set.add(value);
        }
        return new ArrayList<String>(set);
    }

    public ExperimentProperties getCachedProperties(Experiment exp) {
        if (exp == null) {
            return null;
        }
        return this.propertiesByResultsDir.get(exp.getResultsDirectory());
    }
}

