/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.tools;

import icy.util.XMLUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.fmp.multiSPOTS96.experiment.Experiment;
import plugins.fmp.multiSPOTS96.experiment.ExperimentProperties;
import plugins.fmp.multiSPOTS96.experiment.cages.Cage;
import plugins.fmp.multiSPOTS96.experiment.spots.Spot;
import plugins.fmp.multiSPOTS96.tools.toExcel.EnumXLSColumnHeader;

public class DescriptorsIO {
    private static final String FILE_NAME = "MS96_descriptors.xml";
    private static final String ROOT = "MS96_DESCRIPTORS";
    private static final String VERSION_ATTR = "version";
    private static final String VERSION = "1.0";
    private static final String DICTS = "DICTS";
    private static final String DICT = "DICT";
    private static final String NAME = "name";
    private static final String VAL = "VAL";

    public static String getDescriptorsFullName(String resultsDirectory) {
        return resultsDirectory + File.separator + FILE_NAME;
    }

    public static Map<EnumXLSColumnHeader, List<String>> readDescriptors(String resultsDirectory) {
        String path = DescriptorsIO.getDescriptorsFullName(resultsDirectory);
        Document doc = XMLUtil.loadDocument((String)path);
        if (doc == null) {
            return null;
        }
        Element root = XMLUtil.getRootElement((Document)doc);
        if (root == null || !ROOT.equals(root.getNodeName())) {
            return null;
        }
        Element dicts = XMLUtil.getElement((Node)root, (String)DICTS);
        if (dicts == null) {
            return null;
        }
        HashMap<EnumXLSColumnHeader, List<String>> map = new HashMap<EnumXLSColumnHeader, List<String>>();
        for (EnumXLSColumnHeader field : EnumXLSColumnHeader.values()) {
            List<String> values = DescriptorsIO.readDict(dicts, field.name());
            if (values == null || values.isEmpty()) continue;
            map.put(field, values);
        }
        return map;
    }

    private static List<String> readDict(Node dictsNode, String dictName) {
        Node dict = DescriptorsIO.findChildByNameAttr(dictsNode, DICT, dictName);
        if (dict == null) {
            return null;
        }
        ArrayList<String> out = new ArrayList<String>();
        ArrayList vals = XMLUtil.getChildren((Node)dict, (String)VAL);
        for (Node v : vals) {
            String t = XMLUtil.getElementValue((Node)v, (String)"", (String)"");
            if (t == null || t.isEmpty()) continue;
            out.add(t);
        }
        return out;
    }

    private static Node findChildByNameAttr(Node parent, String childName, String nameAttrValue) {
        ArrayList children = XMLUtil.getChildren((Node)parent, (String)childName);
        for (Node n : children) {
            String attr;
            if (!(n instanceof Element) || !nameAttrValue.equals(attr = ((Element)n).getAttribute(NAME))) continue;
            return n;
        }
        return null;
    }

    public static boolean writeDescriptors(String resultsDirectory, EnumMap<EnumXLSColumnHeader, Set<String>> dicts) {
        try {
            Document doc = XMLUtil.createDocument((boolean)true);
            Element root = doc.getDocumentElement();
            if (root == null) {
                root = doc.createElement(ROOT);
                doc.appendChild(root);
            }
            root.setAttribute(VERSION_ATTR, VERSION);
            Element dictsNode = XMLUtil.setElement((Node)root, (String)DICTS);
            for (Map.Entry<EnumXLSColumnHeader, Set<String>> e : dicts.entrySet()) {
                if (e.getValue() == null || e.getValue().isEmpty()) continue;
                Element dictNode = doc.createElement(DICT);
                dictNode.setAttribute(NAME, e.getKey().name());
                dictsNode.appendChild(dictNode);
                for (String v : e.getValue()) {
                    Element valNode = doc.createElement(VAL);
                    valNode.setTextContent(v);
                    dictNode.appendChild(valNode);
                }
            }
            String path = DescriptorsIO.getDescriptorsFullName(resultsDirectory);
            return XMLUtil.saveDocument((Document)doc, (String)path);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean buildFromExperiment(Experiment exp) {
        if (exp == null) {
            return false;
        }
        EnumMap<EnumXLSColumnHeader, Set<String>> dicts = new EnumMap<EnumXLSColumnHeader, Set<String>>(EnumXLSColumnHeader.class);
        for (EnumXLSColumnHeader f : EnumXLSColumnHeader.values()) {
            dicts.put(f, new HashSet());
        }
        ExperimentProperties p = exp.getProperties();
        if (p != null) {
            DescriptorsIO.addIfNotEmpty((Set)dicts.get((Object)EnumXLSColumnHeader.EXP_EXPT), p.getExperimentField(EnumXLSColumnHeader.EXP_EXPT));
            DescriptorsIO.addIfNotEmpty(dicts.get((Object)EnumXLSColumnHeader.EXP_BOXID), p.getExperimentField(EnumXLSColumnHeader.EXP_BOXID));
            DescriptorsIO.addIfNotEmpty(dicts.get((Object)EnumXLSColumnHeader.EXP_STIM1), p.getExperimentField(EnumXLSColumnHeader.EXP_STIM1));
            DescriptorsIO.addIfNotEmpty(dicts.get((Object)EnumXLSColumnHeader.EXP_CONC1), p.getExperimentField(EnumXLSColumnHeader.EXP_CONC1));
            DescriptorsIO.addIfNotEmpty(dicts.get((Object)EnumXLSColumnHeader.EXP_STRAIN), p.getExperimentField(EnumXLSColumnHeader.EXP_STRAIN));
            DescriptorsIO.addIfNotEmpty(dicts.get((Object)EnumXLSColumnHeader.EXP_SEX), p.getExperimentField(EnumXLSColumnHeader.EXP_SEX));
            DescriptorsIO.addIfNotEmpty(dicts.get((Object)EnumXLSColumnHeader.EXP_STIM2), p.getExperimentField(EnumXLSColumnHeader.EXP_STIM2));
            DescriptorsIO.addIfNotEmpty(dicts.get((Object)EnumXLSColumnHeader.EXP_CONC2), p.getExperimentField(EnumXLSColumnHeader.EXP_CONC2));
        }
        try {
            exp.load_MS96_cages();
            if (exp.cagesArray != null && exp.cagesArray.cagesList != null) {
                for (Cage cage : exp.cagesArray.cagesList) {
                    DescriptorsIO.addIfNotEmpty(dicts.get((Object)EnumXLSColumnHeader.CAGE_SEX), cage.getField(EnumXLSColumnHeader.CAGE_SEX));
                    DescriptorsIO.addIfNotEmpty(dicts.get((Object)EnumXLSColumnHeader.CAGE_STRAIN), cage.getField(EnumXLSColumnHeader.CAGE_STRAIN));
                    DescriptorsIO.addIfNotEmpty(dicts.get((Object)EnumXLSColumnHeader.CAGE_AGE), cage.getField(EnumXLSColumnHeader.CAGE_AGE));
                    if (cage.spotsArray == null || cage.spotsArray.getSpotsList() == null) continue;
                    for (Spot spot : cage.spotsArray.getSpotsList()) {
                        DescriptorsIO.addIfNotEmpty(dicts.get((Object)EnumXLSColumnHeader.SPOT_STIM), spot.getField(EnumXLSColumnHeader.SPOT_STIM));
                        DescriptorsIO.addIfNotEmpty(dicts.get((Object)EnumXLSColumnHeader.SPOT_CONC), spot.getField(EnumXLSColumnHeader.SPOT_CONC));
                        DescriptorsIO.addIfNotEmpty(dicts.get((Object)EnumXLSColumnHeader.SPOT_VOLUME), spot.getField(EnumXLSColumnHeader.SPOT_VOLUME));
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return DescriptorsIO.writeDescriptors(exp.getResultsDirectory(), dicts);
    }

    private static void addIfNotEmpty(Set<String> set, String value) {
        if (set == null) {
            return;
        }
        if (value != null && !value.isEmpty()) {
            set.add(value);
        }
    }
}

