/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.tools.JComponents;

import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;

public class TableCellColorRenderer
extends JLabel
implements TableCellRenderer {
    private static final long serialVersionUID = 1L;
    Border unselectedBorder = null;
    Border selectedBorder = null;
    boolean isBordered = true;

    public TableCellColorRenderer(boolean isBordered) {
        this.isBordered = isBordered;
        this.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object color, boolean isSelected, boolean hasFocus, int row, int column) {
        Color newColor = (Color)color;
        if (color == null) {
            return null;
        }
        this.setBackground(newColor);
        if (this.isBordered) {
            if (isSelected) {
                if (this.selectedBorder == null) {
                    this.selectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getSelectionBackground());
                }
                this.setBorder(this.selectedBorder);
            } else {
                if (this.unselectedBorder == null) {
                    this.unselectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getBackground());
                }
                this.setBorder(this.unselectedBorder);
            }
        }
        this.setToolTipText(String.format("RGB value: %d, %d, %d", newColor.getRed(), newColor.getGreen(), newColor.getBlue()));
        return this;
    }
}

