/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.tools.chart;

import icy.util.StringUtil;
import java.awt.Color;
import java.awt.Paint;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.XYPlot;
import plugins.fmp.multiSPOTS96.experiment.cages.Cage;

public class ChartCagePanel
extends ChartPanel
implements PropertyChangeListener,
AutoCloseable {
    private static final long serialVersionUID = 1L;
    private static final Color BACKGROUND_WITH_DATA = Color.WHITE;
    private static final Color BACKGROUND_WITHOUT_DATA = Color.LIGHT_GRAY;
    private static final Color GRID_WITH_DATA = Color.GRAY;
    private static final Color GRID_WITHOUT_DATA = Color.WHITE;
    private Cage cageListened = null;

    public ChartCagePanel(JFreeChart chart, int width, int height, int minimumDrawWidth, int minimumDrawHeight, int maximumDrawWidth, int maximumDrawHeight, boolean useBuffer, boolean properties, boolean copy, boolean save, boolean print, boolean zoom) {
        super(chart, width, height, minimumDrawWidth, minimumDrawHeight, maximumDrawWidth, maximumDrawHeight, useBuffer, properties, copy, save, print, zoom);
    }

    private void updateFlyCountDisplay(int flyCount) {
        XYPlot xyPlot = this.getChart().getXYPlot();
        this.setXYPlotBackGroundAccordingToNFlies(xyPlot, flyCount);
    }

    private void setXYPlotBackGroundAccordingToNFlies(XYPlot xyPlot, int flyCount) {
        if (flyCount > 0) {
            xyPlot.setBackgroundPaint((Paint)BACKGROUND_WITH_DATA);
            xyPlot.setDomainGridlinePaint((Paint)GRID_WITH_DATA);
            xyPlot.setRangeGridlinePaint((Paint)GRID_WITH_DATA);
        } else {
            xyPlot.setBackgroundPaint((Paint)BACKGROUND_WITHOUT_DATA);
            xyPlot.setDomainGridlinePaint((Paint)GRID_WITHOUT_DATA);
            xyPlot.setRangeGridlinePaint((Paint)GRID_WITHOUT_DATA);
        }
    }

    public void subscribeToCagePropertiesUpdates(Cage cage) {
        this.cageListened = cage;
        this.cageListened.getProperties().addPropertyChangeListener(this);
    }

    @Override
    public void close() throws Exception {
        this.cageListened.getProperties().removePropertyChangeListener(this);
        this.cageListened = null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (StringUtil.equals((String)"cageNFlies", (String)evt.getPropertyName())) {
            int flyCount = (Integer)evt.getNewValue();
            this.updateFlyCountDisplay(flyCount);
        }
    }
}

