/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.tools.polyline;

import icy.gui.frame.progress.AnnounceFrame;
import icy.type.geom.Polygon2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PolygonUtilities {
    private static final Logger LOGGER = Logger.getLogger(PolygonUtilities.class.getName());
    private static final int REQUIRED_VERTICES = 4;
    private static final int MIN_GRID_SIZE = 1;
    private static final double EPSILON = 1.0E-10;
    private static final int SUBDIVISION_FACTOR = 2;
    private static final int RECTANGLE_OFFSET = 2;

    private PolygonUtilities() {
        throw new UnsupportedOperationException("Utility class cannot be instantiated");
    }

    public static Polygon2D orderVerticesOf4CornersPolygon(Polygon roiPolygon) {
        if (roiPolygon == null) {
            throw new IllegalArgumentException("ROI polygon cannot be null");
        }
        if (roiPolygon.npoints < 4) {
            throw new IllegalArgumentException("Polygon must have at least 4 vertices, got: " + roiPolygon.npoints);
        }
        if (roiPolygon.npoints > 4) {
            new AnnounceFrame("Only the first 4 points of the polygon will be used...");
        }
        try {
            Polygon2D orderedPolygon = new Polygon2D();
            Rectangle bounds = roiPolygon.getBounds();
            Rectangle upperLeft = new Rectangle(bounds.x, bounds.y, bounds.width / 2, bounds.height / 2);
            Rectangle lowerLeft = new Rectangle(bounds.x, bounds.y + bounds.height / 2 + 2, bounds.width / 2, bounds.height / 2);
            Rectangle lowerRight = new Rectangle(bounds.x + bounds.width / 2 + 2, bounds.y + bounds.height / 2 + 2, bounds.width / 2, bounds.height / 2);
            Rectangle upperRight = new Rectangle(bounds.x + bounds.width / 2 + 2, bounds.y, bounds.width / 2, bounds.height / 2);
            PolygonUtilities.addVertexInQuadrant(orderedPolygon, roiPolygon, upperLeft, "upper-left");
            PolygonUtilities.addVertexInQuadrant(orderedPolygon, roiPolygon, lowerLeft, "lower-left");
            PolygonUtilities.addVertexInQuadrant(orderedPolygon, roiPolygon, lowerRight, "lower-right");
            PolygonUtilities.addVertexInQuadrant(orderedPolygon, roiPolygon, upperRight, "upper-right");
            return orderedPolygon;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error ordering polygon vertices", e);
            return new Polygon2D();
        }
    }

    public static Polygon2D inflatePolygon(Polygon2D roiPolygon, int numColumns, int numRows, int cageWidth, int cageHeight, int widthInterval, int heightInterval) {
        PolygonUtilities.validateInflationParameters(roiPolygon, numColumns, numRows, cageWidth, cageHeight, widthInterval, heightInterval);
        try {
            double currentWidth = numColumns * (cageWidth + 2 * widthInterval) - 2 * widthInterval;
            double currentHeight = numRows * (cageHeight + 2 * heightInterval) - 2 * heightInterval;
            double topDeltaX = (roiPolygon.xpoints[3] - roiPolygon.xpoints[0]) * (double)widthInterval / currentWidth;
            double bottomDeltaX = (roiPolygon.xpoints[2] - roiPolygon.xpoints[1]) * (double)widthInterval / currentWidth;
            double leftDeltaY = (roiPolygon.ypoints[1] - roiPolygon.ypoints[0]) * (double)heightInterval / currentHeight;
            double rightDeltaY = (roiPolygon.ypoints[2] - roiPolygon.ypoints[3]) * (double)heightInterval / currentHeight;
            double[] newXPoints = new double[4];
            double[] newYPoints = new double[4];
            newXPoints[0] = roiPolygon.xpoints[0] - topDeltaX;
            newXPoints[1] = roiPolygon.xpoints[1] - bottomDeltaX;
            newXPoints[2] = roiPolygon.xpoints[2] + bottomDeltaX;
            newXPoints[3] = roiPolygon.xpoints[3] + topDeltaX;
            newYPoints[0] = roiPolygon.ypoints[0] - leftDeltaY;
            newYPoints[1] = roiPolygon.ypoints[1] + leftDeltaY;
            newYPoints[2] = roiPolygon.ypoints[2] + rightDeltaY;
            newYPoints[3] = roiPolygon.ypoints[3] - rightDeltaY;
            return new Polygon2D(newXPoints, newYPoints, 4);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error inflating polygon", e);
            return new Polygon2D();
        }
    }

    @Deprecated
    public static Polygon2D inflate(Polygon2D roiPolygon, int ncolumns, int nrows, int width_cage, int width_interval) {
        LOGGER.warning("Using deprecated method inflate(). Use inflatePolygon() instead.");
        return PolygonUtilities.inflatePolygon(roiPolygon, ncolumns, nrows, width_cage, width_cage, width_interval, width_interval);
    }

    @Deprecated
    public static Polygon2D inflate2(Polygon2D roiPolygon, int ncolumns, int width_cage, int width_interval, int nrows, int height_cage, int height_interval) {
        LOGGER.warning("Using deprecated method inflate2(). Use inflatePolygon() instead.");
        return PolygonUtilities.inflatePolygon(roiPolygon, ncolumns, nrows, width_cage, height_cage, width_interval, height_interval);
    }

    public static ArrayList<Point2D.Double> divide4CornersPolygon(Polygon2D roiPolygon, int numColumns, int numRows) {
        if (roiPolygon == null) {
            throw new IllegalArgumentException("ROI polygon cannot be null");
        }
        if (roiPolygon.npoints != 4) {
            throw new IllegalArgumentException("Polygon must have exactly 4 vertices, got: " + roiPolygon.npoints);
        }
        if (numColumns < 1 || numRows < 1) {
            throw new IllegalArgumentException("Grid dimensions must be at least 1x1, got: " + numColumns + "x" + numRows);
        }
        try {
            ArrayList<Point2D.Double> gridPoints = new ArrayList<Point2D.Double>((numColumns + 1) * (numRows + 1));
            for (int row = 0; row <= numRows; ++row) {
                double rowRatio = numRows > 0 ? (double)row / (double)numRows : 0.0;
                Point2D.Double leftEdgePoint = PolygonUtilities.interpolatePoint(roiPolygon.xpoints[0], roiPolygon.ypoints[0], roiPolygon.xpoints[1], roiPolygon.ypoints[1], rowRatio);
                Point2D.Double rightEdgePoint = PolygonUtilities.interpolatePoint(roiPolygon.xpoints[3], roiPolygon.ypoints[3], roiPolygon.xpoints[2], roiPolygon.ypoints[2], rowRatio);
                for (int col = 0; col <= numColumns; ++col) {
                    double colRatio = numColumns > 0 ? (double)col / (double)numColumns : 0.0;
                    Point2D.Double gridPoint = PolygonUtilities.interpolatePoint(leftEdgePoint.x, leftEdgePoint.y, rightEdgePoint.x, rightEdgePoint.y, colRatio);
                    gridPoints.add(gridPoint);
                }
            }
            return gridPoints;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error dividing polygon into grid", e);
            return new ArrayList<Point2D.Double>();
        }
    }

    public static Point2D lineIntersect(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
        try {
            double denominator = (y4 - y3) * (x2 - x1) - (x4 - x3) * (y2 - y1);
            if (Math.abs(denominator) < 1.0E-10) {
                return null;
            }
            double numeratorA = (x4 - x3) * (y1 - y3) - (y4 - y3) * (x1 - x3);
            double numeratorB = (x2 - x1) * (y1 - y3) - (y2 - y1) * (x1 - x3);
            double ua = numeratorA / denominator;
            double ub = numeratorB / denominator;
            if (ua >= 0.0 && ua <= 1.0 && ub >= 0.0 && ub <= 1.0) {
                double intersectionX = x1 + ua * (x2 - x1);
                double intersectionY = y1 + ua * (y2 - y1);
                return new Point2D.Double(intersectionX, intersectionY);
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error calculating line intersection", e);
            return null;
        }
    }

    public static Point2D.Double[][] createGridInsidePolygon(Polygon2D roiPolygon, int numColumns, int numRows) {
        if (roiPolygon == null) {
            throw new IllegalArgumentException("ROI polygon cannot be null");
        }
        if (roiPolygon.npoints != 4) {
            throw new IllegalArgumentException("Polygon must have exactly 4 vertices, got: " + roiPolygon.npoints);
        }
        if (numColumns <= 0 || numRows <= 0) {
            throw new IllegalArgumentException("Grid dimensions must be positive, got: " + numColumns + "x" + numRows);
        }
        try {
            Point2D.Double[][] gridPoints = new Point2D.Double[numColumns][numRows];
            for (int col = 0; col < numColumns; ++col) {
                double colRatio = numColumns > 1 ? (double)col / (double)(numColumns - 1) : 0.0;
                Point2D.Double topEdgePoint = PolygonUtilities.interpolatePoint(roiPolygon.xpoints[0], roiPolygon.ypoints[0], roiPolygon.xpoints[3], roiPolygon.ypoints[3], colRatio);
                Point2D.Double bottomEdgePoint = PolygonUtilities.interpolatePoint(roiPolygon.xpoints[1], roiPolygon.ypoints[1], roiPolygon.xpoints[2], roiPolygon.ypoints[2], colRatio);
                for (int row = 0; row < numRows; ++row) {
                    Point2D.Double gridPoint;
                    double rowRatio = numRows > 1 ? (double)row / (double)(numRows - 1) : 0.0;
                    gridPoints[col][row] = gridPoint = PolygonUtilities.interpolatePoint(topEdgePoint.x, topEdgePoint.y, bottomEdgePoint.x, bottomEdgePoint.y, rowRatio);
                }
            }
            return gridPoints;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error creating grid inside polygon", e);
            return new Point2D.Double[0][0];
        }
    }

    public static double calculatePolygonArea(Polygon2D polygon) {
        if (polygon == null) {
            throw new IllegalArgumentException("Polygon cannot be null");
        }
        if (polygon.npoints < 3) {
            return 0.0;
        }
        try {
            double area = 0.0;
            for (int i = 0; i < polygon.npoints; ++i) {
                int j = (i + 1) % polygon.npoints;
                area += polygon.xpoints[i] * polygon.ypoints[j];
                area -= polygon.xpoints[j] * polygon.ypoints[i];
            }
            return Math.abs(area) / 2.0;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error calculating polygon area", e);
            return 0.0;
        }
    }

    public static boolean isConvex(Polygon2D polygon) {
        if (polygon == null) {
            throw new IllegalArgumentException("Polygon cannot be null");
        }
        if (polygon.npoints < 3) {
            return false;
        }
        try {
            boolean isPositive = false;
            boolean isNegative = false;
            for (int i = 0; i < polygon.npoints; ++i) {
                int j = (i + 1) % polygon.npoints;
                int k = (i + 2) % polygon.npoints;
                double crossProduct = PolygonUtilities.getCrossProduct(polygon.xpoints[i], polygon.ypoints[i], polygon.xpoints[j], polygon.ypoints[j], polygon.xpoints[k], polygon.ypoints[k]);
                if (crossProduct > 1.0E-10) {
                    isPositive = true;
                } else if (crossProduct < -1.0E-10) {
                    isNegative = true;
                }
                if (!isPositive || !isNegative) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error checking polygon convexity", e);
            return false;
        }
    }

    private static void addVertexInQuadrant(Polygon2D orderedPolygon, Polygon roiPolygon, Rectangle quadrant, String quadrantName) {
        for (int i = 0; i < roiPolygon.npoints && i < 4; ++i) {
            if (!quadrant.contains(roiPolygon.xpoints[i], roiPolygon.ypoints[i])) continue;
            orderedPolygon.addPoint((double)roiPolygon.xpoints[i], (double)roiPolygon.ypoints[i]);
            return;
        }
        LOGGER.warning("No vertex found in " + quadrantName + " quadrant");
    }

    private static void validateInflationParameters(Polygon2D roiPolygon, int numColumns, int numRows, int cageWidth, int cageHeight, int widthInterval, int heightInterval) {
        if (roiPolygon == null) {
            throw new IllegalArgumentException("ROI polygon cannot be null");
        }
        if (roiPolygon.npoints != 4) {
            throw new IllegalArgumentException("Polygon must have exactly 4 vertices, got: " + roiPolygon.npoints);
        }
        if (numColumns <= 0 || numRows <= 0) {
            throw new IllegalArgumentException("Grid dimensions must be positive: " + numColumns + "x" + numRows);
        }
        if (cageWidth <= 0 || cageHeight <= 0) {
            throw new IllegalArgumentException("Cage dimensions must be positive: " + cageWidth + "x" + cageHeight);
        }
        if (widthInterval < 0 || heightInterval < 0) {
            throw new IllegalArgumentException("Intervals cannot be negative: " + widthInterval + ", " + heightInterval);
        }
    }

    private static Point2D.Double interpolatePoint(double x1, double y1, double x2, double y2, double ratio) {
        double x = x1 + ratio * (x2 - x1);
        double y = y1 + ratio * (y2 - y1);
        return new Point2D.Double(x, y);
    }

    private static double getCrossProduct(double x1, double y1, double x2, double y2, double x3, double y3) {
        return (x2 - x1) * (y3 - y1) - (y2 - y1) * (x3 - x1);
    }
}

