/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.tools.toExcel;

import plugins.fmp.multiSPOTS96.tools.toExcel.XLSExport;
import plugins.fmp.multiSPOTS96.tools.toExcel.XLSExportFactory;
import plugins.fmp.multiSPOTS96.tools.toExcel.XLSExportMeasuresFromSpotStreaming;
import plugins.fmp.multiSPOTS96.tools.toExcel.XLSExportOptions;
import plugins.fmp.multiSPOTS96.tools.toExcel.exceptions.ExcelExportException;

public class ExportUsageExample {
    public static void exampleAutomaticSelection() {
        try {
            int experimentCount = ExportUsageExample.getExperimentCount();
            XLSExportOptions options = ExportUsageExample.createExportOptions();
            XLSExport exporter = XLSExportFactory.createExporter(experimentCount, options);
            System.out.println("Using: " + exporter.getClass().getSimpleName());
            System.out.println(XLSExportFactory.getMemoryAnalysis(experimentCount));
            exporter.exportToFile("output_automatic.xlsx", options);
        }
        catch (ExcelExportException e) {
            System.err.println("Export failed: " + e.getMessage());
        }
    }

    public static void exampleManualSelection() {
        try {
            XLSExportOptions options = ExportUsageExample.createExportOptions();
            XLSExport originalExporter = XLSExportFactory.createOriginalExporter();
            originalExporter.exportToFile("output_original.xlsx", options);
            XLSExport optimizedExporter = XLSExportFactory.createOptimizedExporter();
            optimizedExporter.exportToFile("output_optimized.xlsx", options);
            XLSExport streamingExporter = XLSExportFactory.createStreamingExporter();
            streamingExporter.exportToFile("output_streaming.xlsx", options);
        }
        catch (ExcelExportException e) {
            System.err.println("Export failed: " + e.getMessage());
        }
    }

    public static void exampleMemoryConstrained() {
        try {
            int experimentCount = ExportUsageExample.getExperimentCount();
            XLSExportOptions options = ExportUsageExample.createExportOptions();
            if (!XLSExportFactory.canHandleExport(experimentCount)) {
                System.err.println("Warning: Insufficient memory for export");
                System.err.println("Required: " + XLSExportFactory.getMinimumRequiredMemory(experimentCount) + " MB");
                System.err.println("Available: " + XLSExportFactory.getAvailableMemoryMB() + " MB");
                return;
            }
            XLSExport exporter = XLSExportFactory.createStreamingExporter();
            if (exporter instanceof XLSExportMeasuresFromSpotStreaming) {
                ((XLSExportMeasuresFromSpotStreaming)exporter).setMemoryMonitoringEnabled(true);
            }
            exporter.exportToFile("output_memory_constrained.xlsx", options);
        }
        catch (ExcelExportException e) {
            System.err.println("Export failed: " + e.getMessage());
        }
    }

    public static void examplePerformanceComparison() {
        try {
            int experimentCount = ExportUsageExample.getExperimentCount();
            XLSExportOptions options = ExportUsageExample.createExportOptions();
            System.out.println("Performance Comparison for " + experimentCount + " experiments:");
            System.out.println("==================================================");
            long startTime = System.currentTimeMillis();
            long startMemory = ExportUsageExample.getCurrentMemoryUsage();
            XLSExport originalExporter = XLSExportFactory.createOriginalExporter();
            originalExporter.exportToFile("output_perf_original.xlsx", options);
            long originalTime = System.currentTimeMillis() - startTime;
            long originalMemory = ExportUsageExample.getCurrentMemoryUsage() - startMemory;
            startTime = System.currentTimeMillis();
            startMemory = ExportUsageExample.getCurrentMemoryUsage();
            XLSExport optimizedExporter = XLSExportFactory.createOptimizedExporter();
            optimizedExporter.exportToFile("output_perf_optimized.xlsx", options);
            long optimizedTime = System.currentTimeMillis() - startTime;
            long optimizedMemory = ExportUsageExample.getCurrentMemoryUsage() - startMemory;
            startTime = System.currentTimeMillis();
            startMemory = ExportUsageExample.getCurrentMemoryUsage();
            XLSExport streamingExporter = XLSExportFactory.createStreamingExporter();
            streamingExporter.exportToFile("output_perf_streaming.xlsx", options);
            long streamingTime = System.currentTimeMillis() - startTime;
            long streamingMemory = ExportUsageExample.getCurrentMemoryUsage() - startMemory;
            System.out.println("Original:    " + originalTime + " ms, " + originalMemory + " MB");
            System.out.println("Optimized:   " + optimizedTime + " ms, " + optimizedMemory + " MB");
            System.out.println("Streaming:   " + streamingTime + " ms, " + streamingMemory + " MB");
        }
        catch (ExcelExportException e) {
            System.err.println("Export failed: " + e.getMessage());
        }
    }

    public static void exampleCustomThresholds() {
        try {
            int experimentCount = ExportUsageExample.getExperimentCount();
            XLSExportOptions options = ExportUsageExample.createExportOptions();
            XLSExport exporter = XLSExportFactory.createExporterWithCustomThresholds(experimentCount, options, 5, 50, 0.5);
            System.out.println("Using custom thresholds: " + exporter.getClass().getSimpleName());
            exporter.exportToFile("output_custom.xlsx", options);
        }
        catch (ExcelExportException e) {
            System.err.println("Export failed: " + e.getMessage());
        }
    }

    public static void exampleMemoryMonitoring() {
        try {
            int experimentCount = ExportUsageExample.getExperimentCount();
            XLSExportOptions options = ExportUsageExample.createExportOptions();
            System.out.println("Initial memory usage: " + ExportUsageExample.getCurrentMemoryUsage() + " MB");
            System.out.println("Available memory: " + XLSExportFactory.getAvailableMemoryMB() + " MB");
            XLSExport exporter = XLSExportFactory.createExporter(experimentCount, options, true);
            long startMemory = ExportUsageExample.getCurrentMemoryUsage();
            long startTime = System.currentTimeMillis();
            exporter.exportToFile("output_monitored.xlsx", options);
            long endTime = System.currentTimeMillis();
            long endMemory = ExportUsageExample.getCurrentMemoryUsage();
            System.out.println("Export completed:");
            System.out.println("- Time: " + (endTime - startTime) + " ms");
            System.out.println("- Memory used: " + (endMemory - startMemory) + " MB");
            System.out.println("- Final memory: " + endMemory + " MB");
        }
        catch (ExcelExportException e) {
            System.err.println("Export failed: " + e.getMessage());
        }
    }

    public static void exampleMemoryPressure() {
        try {
            int experimentCount = ExportUsageExample.getExperimentCount();
            XLSExportOptions options = ExportUsageExample.createExportOptions();
            if (XLSExportFactory.isUnderMemoryPressure()) {
                System.out.println("Warning: System under memory pressure");
                System.out.println("Memory usage: " + XLSExportFactory.getMemoryUsagePercentage() * 100.0 + "%");
                System.gc();
                if (XLSExportFactory.isUnderMemoryPressure()) {
                    System.err.println("Error: Insufficient memory for export");
                    return;
                }
            }
            XLSExport exporter = XLSExportFactory.createStreamingExporter();
            exporter.exportToFile("output_pressure.xlsx", options);
        }
        catch (ExcelExportException e) {
            System.err.println("Export failed: " + e.getMessage());
        }
    }

    public static void exampleBatchProcessing() {
        try {
            int[] experimentCounts;
            XLSExportOptions options = ExportUsageExample.createExportOptions();
            for (int count : experimentCounts = new int[]{5, 25, 100, 500}) {
                System.out.println("Processing " + count + " experiments...");
                XLSExport exporter = XLSExportFactory.createExporter(count, options);
                String filename = "output_batch_" + count + ".xlsx";
                exporter.exportToFile(filename, options);
                System.out.println("Completed: " + filename);
            }
        }
        catch (ExcelExportException e) {
            System.err.println("Export failed: " + e.getMessage());
        }
    }

    private static int getExperimentCount() {
        return 50;
    }

    private static XLSExportOptions createExportOptions() {
        XLSExportOptions options = new XLSExportOptions();
        options.spotAreas = true;
        options.onlyalive = false;
        options.relativeToT0 = false;
        options.buildExcelStepMs = 1000;
        return options;
    }

    private static long getCurrentMemoryUsage() {
        Runtime runtime = Runtime.getRuntime();
        long totalMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        return (totalMemory - freeMemory) / 0x100000L;
    }

    public static void main(String[] args) {
        System.out.println("MultiSPOTS96 Excel Export Examples");
        System.out.println("==================================");
        ExportUsageExample.exampleAutomaticSelection();
        ExportUsageExample.exampleManualSelection();
        ExportUsageExample.exampleMemoryConstrained();
        ExportUsageExample.examplePerformanceComparison();
        ExportUsageExample.exampleCustomThresholds();
        ExportUsageExample.exampleMemoryMonitoring();
        ExportUsageExample.exampleMemoryPressure();
        ExportUsageExample.exampleBatchProcessing();
        System.out.println("All examples completed.");
    }
}

