/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.dlg.a_experiment;

import icy.canvas.Canvas2D;
import icy.gui.viewer.Viewer;
import icy.sequence.Sequence;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import plugins.fmp.multiSPOTS96.MultiSPOTS96;
import plugins.fmp.multiSPOTS96.experiment.Experiment;
import plugins.fmp.multiSPOTS96.experiment.ExperimentProperties;
import plugins.fmp.multiSPOTS96.tools.DialogTools;
import plugins.fmp.multiSPOTS96.tools.JComponents.JComboBoxModelSorted;
import plugins.fmp.multiSPOTS96.tools.toExcel.EnumXLSColumnHeader;

public class Infos
extends JPanel {
    private static final long serialVersionUID = 2190848825783418962L;
    private JComboBox<String> stim1Combo = new JComboBox<String>(new JComboBoxModelSorted());
    private JComboBox<String> conc1Combo = new JComboBox<String>(new JComboBoxModelSorted());
    private JComboBox<String> boxIDCombo = new JComboBox<String>(new JComboBoxModelSorted());
    private JComboBox<String> exptCombo = new JComboBox<String>(new JComboBoxModelSorted());
    private JComboBox<String> strainCombo = new JComboBox<String>(new JComboBoxModelSorted());
    private JComboBox<String> sexCombo = new JComboBox<String>(new JComboBoxModelSorted());
    private JComboBox<String> stim2Combo = new JComboBox<String>(new JComboBoxModelSorted());
    private JComboBox<String> conc2Combo = new JComboBox<String>(new JComboBoxModelSorted());
    private JLabel experimentCheck = new JLabel(EnumXLSColumnHeader.EXP_EXPT.toString());
    private JLabel boxIDCheck = new JLabel(EnumXLSColumnHeader.EXP_BOXID.toString());
    private JLabel stim1Check = new JLabel(EnumXLSColumnHeader.EXP_STIM1.toString());
    private JLabel conc1Check = new JLabel(EnumXLSColumnHeader.EXP_CONC1.toString());
    private JLabel strainCheck = new JLabel(EnumXLSColumnHeader.EXP_STRAIN.toString());
    private JLabel sexCheck = new JLabel(EnumXLSColumnHeader.EXP_SEX.toString());
    private JLabel stim2Check = new JLabel(EnumXLSColumnHeader.EXP_STIM2.toString());
    private JLabel conc2Check = new JLabel(EnumXLSColumnHeader.EXP_CONC2.toString());
    private JButton openButton = new JButton("Load...");
    private JButton saveButton = new JButton("Save...");
    private JButton duplicateButton = new JButton("Get previous");
    private JButton zoomButton = new JButton("zoom top");
    private MultiSPOTS96 parent0 = null;

    void init(GridLayout capLayout, MultiSPOTS96 parent0) {
        this.parent0 = parent0;
        GridBagLayout layoutThis = new GridBagLayout();
        this.setLayout(layoutThis);
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.fill = 2;
        c.anchor = 256;
        c.ipadx = 0;
        c.ipady = 0;
        c.insets = new Insets(1, 2, 1, 2);
        int delta1 = 1;
        int delta2 = 3;
        c.gridx = 0;
        c.gridy = 0;
        DialogTools.addFiveComponentOnARow(this, this.experimentCheck, this.exptCombo, this.boxIDCheck, this.boxIDCombo, this.openButton, c, delta1, delta2);
        c.gridy = 1;
        c.gridx = 0;
        DialogTools.addFiveComponentOnARow(this, this.strainCheck, this.strainCombo, this.sexCheck, this.sexCombo, this.saveButton, c, delta1, delta2);
        c.gridy = 2;
        c.gridx = 0;
        DialogTools.addFiveComponentOnARow(this, this.stim1Check, this.stim1Combo, this.conc1Check, this.conc1Combo, this.duplicateButton, c, delta1, delta2);
        c.gridy = 3;
        c.gridx = 0;
        DialogTools.addFiveComponentOnARow(this, this.stim2Check, this.stim2Combo, this.conc2Check, this.conc2Combo, this.zoomButton, c, delta1, delta2);
        this.boxIDCombo.setEditable(true);
        this.exptCombo.setEditable(true);
        this.stim1Combo.setEditable(true);
        this.conc1Combo.setEditable(true);
        this.strainCombo.setEditable(true);
        this.sexCombo.setEditable(true);
        this.stim2Combo.setEditable(true);
        this.conc2Combo.setEditable(true);
        this.defineActionListeners();
    }

    private void defineActionListeners() {
        this.openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = ((Infos)Infos.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    exp.load_MS96_experiment();
                    Infos.this.transferPreviousExperimentInfosToDialog(exp, exp);
                }
            }
        });
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = ((Infos)Infos.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    ExperimentProperties expDesc = exp.getProperties();
                    Infos.this.getExperimentInfosFromDialog(expDesc);
                    exp.save_MS96_experiment();
                }
            }
        });
        this.duplicateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Infos.this.duplicatePreviousDescriptors();
            }
        });
        this.zoomButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = ((Infos)Infos.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    Infos.this.zoomToUpperCorner(exp);
                }
            }
        });
    }

    public void transferPreviousExperimentInfosToDialog(Experiment exp_source, Experiment exp_destination) {
        this.setInfoCombo(exp_destination, exp_source, this.boxIDCombo, EnumXLSColumnHeader.EXP_BOXID);
        this.setInfoCombo(exp_destination, exp_source, this.exptCombo, EnumXLSColumnHeader.EXP_EXPT);
        this.setInfoCombo(exp_destination, exp_source, this.stim1Combo, EnumXLSColumnHeader.EXP_STIM1);
        this.setInfoCombo(exp_destination, exp_source, this.conc1Combo, EnumXLSColumnHeader.EXP_CONC1);
        this.setInfoCombo(exp_destination, exp_source, this.strainCombo, EnumXLSColumnHeader.EXP_STRAIN);
        this.setInfoCombo(exp_destination, exp_source, this.sexCombo, EnumXLSColumnHeader.EXP_SEX);
        this.setInfoCombo(exp_destination, exp_source, this.stim2Combo, EnumXLSColumnHeader.EXP_STIM2);
        this.setInfoCombo(exp_destination, exp_source, this.conc2Combo, EnumXLSColumnHeader.EXP_CONC2);
    }

    private void setInfoCombo(Experiment exp_dest, Experiment exp_source, JComboBox<String> combo, EnumXLSColumnHeader field) {
        String altText = exp_source.getProperties().getExperimentField(field);
        String text = exp_dest.getProperties().getExperimentField(field);
        if (text.equals("..")) {
            exp_dest.getProperties().setExperimentFieldNoTest(field, altText);
        }
        text = exp_dest.getProperties().getExperimentField(field);
        this.addItemToComboIfNew(text, combo);
        combo.setSelectedItem(text);
    }

    public void getExperimentInfosFromDialog(ExperimentProperties expDesc) {
        expDesc.setExperimentFieldNoTest(EnumXLSColumnHeader.EXP_BOXID, (String)this.boxIDCombo.getSelectedItem());
        expDesc.setExperimentFieldNoTest(EnumXLSColumnHeader.EXP_EXPT, (String)this.exptCombo.getSelectedItem());
        expDesc.setExperimentFieldNoTest(EnumXLSColumnHeader.EXP_STIM1, (String)this.stim1Combo.getSelectedItem());
        expDesc.setExperimentFieldNoTest(EnumXLSColumnHeader.EXP_CONC1, (String)this.conc1Combo.getSelectedItem());
        expDesc.setExperimentFieldNoTest(EnumXLSColumnHeader.EXP_STRAIN, (String)this.strainCombo.getSelectedItem());
        expDesc.setExperimentFieldNoTest(EnumXLSColumnHeader.EXP_SEX, (String)this.sexCombo.getSelectedItem());
        expDesc.setExperimentFieldNoTest(EnumXLSColumnHeader.EXP_STIM2, (String)this.stim2Combo.getSelectedItem());
        expDesc.setExperimentFieldNoTest(EnumXLSColumnHeader.EXP_CONC2, (String)this.conc2Combo.getSelectedItem());
    }

    private void addItemToComboIfNew(String toAdd, JComboBox<String> combo) {
        if (toAdd == null) {
            return;
        }
        JComboBoxModelSorted model = (JComboBoxModelSorted)combo.getModel();
        if (model.getIndexOf(toAdd) == -1) {
            model.addElement(toAdd);
        }
    }

    public void initCombos() {
        if (this.parent0.descriptorIndex != null && this.parent0.descriptorIndex.isReady()) {
            this.refreshComboFromIndex(this.exptCombo, EnumXLSColumnHeader.EXP_EXPT);
            this.refreshComboFromIndex(this.stim1Combo, EnumXLSColumnHeader.EXP_STIM1);
            this.refreshComboFromIndex(this.conc1Combo, EnumXLSColumnHeader.EXP_CONC1);
            this.refreshComboFromIndex(this.boxIDCombo, EnumXLSColumnHeader.EXP_BOXID);
            this.refreshComboFromIndex(this.strainCombo, EnumXLSColumnHeader.EXP_STRAIN);
            this.refreshComboFromIndex(this.sexCombo, EnumXLSColumnHeader.EXP_SEX);
            this.refreshComboFromIndex(this.stim2Combo, EnumXLSColumnHeader.EXP_STIM2);
            this.refreshComboFromIndex(this.conc2Combo, EnumXLSColumnHeader.EXP_CONC2);
        } else {
            this.parent0.expListCombo.getFieldValuesToComboLightweight(this.exptCombo, EnumXLSColumnHeader.EXP_EXPT);
            this.parent0.expListCombo.getFieldValuesToComboLightweight(this.stim1Combo, EnumXLSColumnHeader.EXP_STIM1);
            this.parent0.expListCombo.getFieldValuesToComboLightweight(this.conc1Combo, EnumXLSColumnHeader.EXP_CONC1);
            this.parent0.expListCombo.getFieldValuesToComboLightweight(this.boxIDCombo, EnumXLSColumnHeader.EXP_BOXID);
            this.parent0.expListCombo.getFieldValuesToComboLightweight(this.strainCombo, EnumXLSColumnHeader.EXP_STRAIN);
            this.parent0.expListCombo.getFieldValuesToComboLightweight(this.sexCombo, EnumXLSColumnHeader.EXP_SEX);
            this.parent0.expListCombo.getFieldValuesToComboLightweight(this.stim2Combo, EnumXLSColumnHeader.EXP_STIM2);
            this.parent0.expListCombo.getFieldValuesToComboLightweight(this.conc2Combo, EnumXLSColumnHeader.EXP_CONC2);
        }
        Experiment exp = this.parent0.expListCombo.getSelectedItem();
        if (exp != null) {
            this.transferPreviousExperimentInfosToDialog(exp, exp);
        }
    }

    private void refreshComboFromIndex(JComboBox<String> combo, EnumXLSColumnHeader field) {
        combo.removeAllItems();
        for (String text : this.parent0.descriptorIndex.getDistinctValues(field)) {
            combo.addItem(text);
        }
    }

    public void clearCombos() {
        this.exptCombo.removeAllItems();
        this.stim1Combo.removeAllItems();
        this.conc1Combo.removeAllItems();
        this.boxIDCombo.removeAllItems();
        this.strainCombo.removeAllItems();
        this.sexCombo.removeAllItems();
    }

    void duplicatePreviousDescriptors() {
        int iprevious = this.parent0.expListCombo.getSelectedIndex() - 1;
        if (iprevious < 0) {
            return;
        }
        Experiment exp0 = this.parent0.expListCombo.getItemAt(iprevious);
        Experiment exp = this.parent0.expListCombo.getItemAt(iprevious + 1);
        this.transferPreviousExperimentInfosToDialog(exp0, exp);
    }

    void zoomToUpperCorner(Experiment exp) {
        Sequence seq = exp.seqCamData.getSequence();
        Viewer v = seq.getFirstViewer();
        if (v != null) {
            Canvas2D canvas = (Canvas2D)v.getCanvas();
            canvas.setScale(2.0, 2.0, true);
            canvas.setOffset(0, 0, true);
        }
    }
}

