/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.dlg.b_spots;

import icy.canvas.Canvas2D;
import icy.gui.dialog.ConfirmDialog;
import icy.gui.viewer.Viewer;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.type.geom.Polygon2D;
import icy.type.geom.Polyline2D;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import plugins.fmp.multiSPOTS96.MultiSPOTS96;
import plugins.fmp.multiSPOTS96.experiment.Experiment;
import plugins.fmp.multiSPOTS96.tools.ROI2D.ROI2DUtilities;
import plugins.kernel.roi.roi2d.ROI2DPolyLine;
import plugins.kernel.roi.roi2d.ROI2DPolygon;

public class EditSpots
extends JPanel {
    private static final long serialVersionUID = -7582410775062671523L;
    private JComboBox<String> typeCombo = new JComboBox<String>(new String[]{"spot", "cage"});
    private JCheckBox selectRoisCheckBox = new JCheckBox("Select");
    private JCheckBox displaySnakeCheckBox = new JCheckBox("Display snake");
    private JButton centerRoisToSnakeButton = new JButton("Center rois to snake");
    private MultiSPOTS96 parent0 = null;
    public ROI2DPolygon roiPerimeter = null;
    public ROI2DPolyLine roiSnake = null;
    private ArrayList<ROI2D> enclosedRois = null;
    private JButton erodeButton = new JButton("Contract rois");
    private JButton dilateButton = new JButton("Dilate rois");

    void init(GridLayout capLayout, MultiSPOTS96 parent0) {
        this.parent0 = parent0;
        this.setLayout(capLayout);
        FlowLayout flowLayout = new FlowLayout(0);
        flowLayout.setVgap(0);
        JPanel panel0 = new JPanel(flowLayout);
        panel0.add(new JLabel("select type of rois"));
        panel0.add(this.typeCombo);
        this.add(panel0);
        JPanel panel1 = new JPanel(flowLayout);
        panel1.add(this.selectRoisCheckBox);
        panel1.add(this.displaySnakeCheckBox);
        panel1.add(this.centerRoisToSnakeButton);
        this.add(panel1);
        JPanel panel2 = new JPanel(flowLayout);
        panel2.add(this.dilateButton);
        panel2.add(this.erodeButton);
        this.add(panel2);
        this.defineActionListeners();
        this.updateButtonsStateAccordingToSelectRois(false, false);
    }

    private void defineActionListeners() {
        this.selectRoisCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = ((EditSpots)EditSpots.this).parent0.expListCombo.getSelectedItem();
                if (exp == null) {
                    return;
                }
                boolean isSelected = EditSpots.this.selectRoisCheckBox.isSelected();
                EditSpots.this.updateButtonsStateAccordingToSelectRois(isSelected, false);
                EditSpots.this.showFrameEnclosingRois(exp, isSelected);
            }
        });
        this.displaySnakeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = ((EditSpots)EditSpots.this).parent0.expListCombo.getSelectedItem();
                if (exp == null) {
                    return;
                }
                boolean isSelected = EditSpots.this.displaySnakeCheckBox.isSelected();
                EditSpots.this.showSnake(exp, isSelected);
                EditSpots.this.showFrameEnclosingRois(exp, !isSelected);
                EditSpots.this.updateButtonsStateAccordingToSelectRois(true, isSelected);
            }
        });
        this.centerRoisToSnakeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = ((EditSpots)EditSpots.this).parent0.expListCombo.getSelectedItem();
                if (exp == null) {
                    return;
                }
                EditSpots.this.updateRoisFromSnake(exp);
            }
        });
        this.dilateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = ((EditSpots)EditSpots.this).parent0.expListCombo.getSelectedItem();
                if (exp == null) {
                    return;
                }
                EditSpots.this.resizeRois(exp, 1);
            }
        });
        this.erodeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = ((EditSpots)EditSpots.this).parent0.expListCombo.getSelectedItem();
                if (exp == null) {
                    return;
                }
                EditSpots.this.resizeRois(exp, -1);
            }
        });
    }

    private void updateButtonsStateAccordingToSelectRois(boolean enableSnake, boolean enableCenter) {
        this.displaySnakeCheckBox.setEnabled(enableSnake);
        this.centerRoisToSnakeButton.setEnabled(enableCenter);
    }

    private void showFrameEnclosingRois(Experiment exp, boolean show) {
        if (show) {
            this.setEnclosingFrame(exp);
        } else {
            exp.seqCamData.getSequence().removeROI((ROI)this.roiPerimeter);
            this.roiPerimeter = null;
        }
    }

    private void setEnclosingFrame(Experiment exp) {
        exp.seqCamData.getSequence().removeROI((ROI)this.roiPerimeter);
        this.showSnake(exp, false);
        this.createPerimeterEnclosingRois(exp);
        exp.seqCamData.getSequence().addROI((ROI)this.roiPerimeter);
        exp.seqCamData.getSequence().setSelectedROI((ROI)this.roiPerimeter);
        this.makeSureRectangleIsVisible(exp, this.roiPerimeter.getBounds());
    }

    private void makeSureRectangleIsVisible(Experiment exp, Rectangle rect) {
        Viewer v = exp.seqCamData.getSequence().getFirstViewer();
        Canvas2D canvas = (Canvas2D)v.getCanvas();
        canvas.centerOn(rect);
    }

    private void showSnake(Experiment exp, boolean show) {
        exp.seqCamData.getSequence().removeROI((ROI)this.roiSnake);
        String selectedRoiType = (String)this.typeCombo.getSelectedItem();
        if (show) {
            exp.seqCamData.getSequence().removeROI((ROI)this.roiPerimeter);
            if (this.enclosedRois.size() > 0) {
                ArrayList<Point2D.Double> listPoint = new ArrayList<Point2D.Double>();
                for (ROI2D roi : this.enclosedRois) {
                    Rectangle rect = roi.getBounds();
                    Point2D.Double point = null;
                    point = selectedRoiType.contains("cage") ? new Point2D.Double(rect.getX(), rect.getY()) : new Point2D.Double(rect.getCenterX(), rect.getCenterY());
                    listPoint.add(point);
                }
                this.roiSnake = new ROI2DPolyLine(listPoint);
                this.roiSnake.setName("snake");
                exp.seqCamData.getSequence().addROI((ROI)this.roiSnake);
                exp.seqCamData.getSequence().setSelectedROI((ROI)this.roiSnake);
                exp.seqCamData.displaySpecificROIs(false, selectedRoiType);
                this.makeSureRectangleIsVisible(exp, this.roiSnake.getBounds());
            }
        } else {
            this.roiSnake = null;
            exp.seqCamData.getSequence().addROI((ROI)this.roiPerimeter);
            exp.seqCamData.displaySpecificROIs(true, selectedRoiType);
        }
    }

    private void createPerimeterEnclosingRois(Experiment exp) {
        String selectedRoiType = (String)this.typeCombo.getSelectedItem();
        ArrayList<ROI2D> listRoisPresent = exp.seqCamData.getROIsContainingString(selectedRoiType);
        ArrayList<ROI2D> listRoisSelected = new ArrayList<ROI2D>();
        for (ROI2D roi : listRoisPresent) {
            if (!roi.isSelected()) continue;
            listRoisSelected.add(roi);
        }
        this.enclosedRois = listRoisSelected.size() > 0 ? listRoisSelected : listRoisPresent;
        Polygon2D polygon = ROI2DUtilities.getPolygonEnclosingROI2Ds(this.enclosedRois, selectedRoiType);
        this.roiPerimeter = new ROI2DPolygon(polygon);
        this.roiPerimeter.setName("perimeter");
        this.roiPerimeter.setColor(Color.YELLOW);
    }

    private void updateRoisFromSnake(Experiment exp) {
        if (this.enclosedRois == null || this.enclosedRois.size() < 1 || this.roiSnake == null) {
            return;
        }
        String selectedRoiType = (String)this.typeCombo.getSelectedItem();
        Polyline2D snake = this.roiSnake.getPolyline2D();
        int i = 0;
        for (ROI2D roi : this.enclosedRois) {
            double x = snake.xpoints[i];
            double y = snake.ypoints[i];
            ++i;
            Rectangle rect = roi.getBounds();
            Point2D.Double point = null;
            point = selectedRoiType.contains("cage") ? new Point2D.Double(x, y) : new Point2D.Double(x - (double)(rect.width / 2), y - (double)(rect.height / 2));
            roi.setPosition2D((Point2D)point);
        }
        exp.seqCamData.displaySpecificROIs(true, selectedRoiType);
    }

    private void resizeRois(Experiment exp, int delta) {
        if (this.enclosedRois.size() > 0) {
            for (ROI2D roi : this.enclosedRois) {
                exp.seqCamData.getSequence().removeROI((ROI)roi);
                roi = ROI2DUtilities.resizeROI(roi, delta);
                exp.seqCamData.getSequence().addROI((ROI)roi);
            }
        } else {
            ConfirmDialog.confirm((String)"At least one spot must be selected");
        }
    }

    public void clearTemporaryROIs() {
        Experiment exp = this.parent0.expListCombo.getSelectedItem();
        if (exp != null) {
            exp.seqCamData.getSequence().removeROI((ROI)this.roiSnake);
            exp.seqCamData.getSequence().removeROI((ROI)this.roiPerimeter);
            this.roiSnake = null;
            this.roiPerimeter = null;
            this.displaySnakeCheckBox.setSelected(false);
            this.selectRoisCheckBox.setSelected(false);
        }
    }
}

