/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.experiment.cages;

import icy.roi.ROI2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import plugins.fmp.multiSPOTS96.experiment.cages.CageModern;
import plugins.fmp.multiSPOTS96.experiment.cages.CageOperationResult;
import plugins.fmp.multiSPOTS96.experiment.cages.CagesArrayConfiguration;
import plugins.fmp.multiSPOTS96.experiment.cages.CagesArrayProperties;
import plugins.fmp.multiSPOTS96.experiment.sequence.SequenceCamData;

public final class CagesArrayModern
implements AutoCloseable {
    private static final Logger LOGGER = Logger.getLogger(CagesArrayModern.class.getName());
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final List<CageModern> cages = new CopyOnWriteArrayList<CageModern>();
    private final Map<Integer, CageModern> cagesByID = new ConcurrentHashMap<Integer, CageModern>();
    private final Map<String, CageModern> cagesByName = new ConcurrentHashMap<String, CageModern>();
    private final CagesArrayConfiguration configuration;
    private volatile boolean closed = false;

    public CagesArrayModern(CagesArrayConfiguration configuration) {
        this.configuration = Objects.requireNonNull(configuration, "Configuration cannot be null");
    }

    public static Builder builder() {
        return new Builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CagesArrayProperties getArrayProperties() {
        this.ensureNotClosed();
        this.lock.readLock().lock();
        try {
            List<String> cageNames = this.cages.stream().map(cage -> cage.getData().getName()).collect(Collectors.toList());
            List<String> cageSex = this.cages.stream().map(cage -> cage.getData().getProperties().getFlySex()).collect(Collectors.toList());
            List<String> cageStrain = this.cages.stream().map(cage -> cage.getData().getProperties().getFlyStrain()).collect(Collectors.toList());
            long validCages = this.cages.stream().filter(cage -> cage.getData().isValid()).count();
            long activeCages = this.cages.stream().filter(cage -> cage.getData().isDetectEnabled()).count();
            long cagesWithSpots = this.cages.stream().filter(cage -> cage.getSpotsArray().getSpotsList().size() > 0).count();
            CagesArrayProperties cagesArrayProperties = CagesArrayProperties.builder().totalCages(this.cages.size()).validCages((int)validCages).activeCages((int)activeCages).cagesWithSpots((int)cagesWithSpots).gridSize(this.configuration.getNTotalCages()).cageNames(cageNames).cageSex(cageSex).cageStrain(cageStrain).build();
            return cagesArrayProperties;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public List<CageModern> getCages() {
        this.ensureNotClosed();
        return Collections.unmodifiableList(new ArrayList<CageModern>(this.cages));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CageOperationResult addCage(CageModern cage) {
        if (cage == null) {
            return CageOperationResult.failure("ADD_CAGE", new IllegalArgumentException("Cage cannot be null"), "Cannot add null cage");
        }
        this.ensureNotClosed();
        this.lock.writeLock().lock();
        try {
            CageOperationResult validation;
            long startTime = System.currentTimeMillis();
            if (this.configuration.isValidateInputs() && !(validation = cage.validateCage()).isSuccess()) {
                CageOperationResult cageOperationResult = CageOperationResult.failure("ADD_CAGE", validation.getError().orElse(new IllegalArgumentException("Invalid cage")), "Cage validation failed: " + validation.getMessage());
                return cageOperationResult;
            }
            String cageName = cage.getData().getName();
            int cageID = cage.getData().getProperties().getCageID();
            if (this.cagesByID.containsKey(cageID)) {
                CageOperationResult cageOperationResult = CageOperationResult.failure("ADD_CAGE", new IllegalStateException("Duplicate cage ID"), "Cage with ID " + cageID + " already exists");
                return cageOperationResult;
            }
            if (this.cagesByName.containsKey(cageName)) {
                CageOperationResult cageOperationResult = CageOperationResult.failure("ADD_CAGE", new IllegalStateException("Duplicate cage name"), "Cage with name '" + cageName + "' already exists");
                return cageOperationResult;
            }
            this.cages.add(cage);
            this.cagesByID.put(cageID, cage);
            this.cagesByName.put(cageName, cage);
            long processingTime = System.currentTimeMillis() - startTime;
            CageOperationResult cageOperationResult = CageOperationResult.success("ADD_CAGE", "Successfully added cage: " + cageName).toBuilder().processingTimeMs(processingTime).addMetadata("totalCages", this.cages.size()).addMetadata("cageID", cageID).addMetadata("cageName", cageName).build();
            return cageOperationResult;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CageOperationResult removeCageById(int cageID) {
        this.ensureNotClosed();
        this.lock.writeLock().lock();
        try {
            long startTime = System.currentTimeMillis();
            CageModern cage = this.cagesByID.remove(cageID);
            if (cage != null) {
                this.cages.remove(cage);
                this.cagesByName.remove(cage.getData().getName());
                try {
                    cage.close();
                }
                catch (Exception e) {
                    LOGGER.warning("Error closing cage during removal: " + e.getMessage());
                }
                long processingTime = System.currentTimeMillis() - startTime;
                CageOperationResult cageOperationResult = CageOperationResult.success("REMOVE_CAGE", "Successfully removed cage: " + cage.getData().getName()).toBuilder().processingTimeMs(processingTime).addMetadata("totalCages", this.cages.size()).build();
                return cageOperationResult;
            }
            CageOperationResult cageOperationResult = CageOperationResult.failure("REMOVE_CAGE", new IllegalArgumentException("Cage not found"), "No cage found with ID: " + cageID);
            return cageOperationResult;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Optional<CageModern> findCageById(int cageID) {
        this.ensureNotClosed();
        return Optional.ofNullable(this.cagesByID.get(cageID));
    }

    public Optional<CageModern> findCageByName(String name) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        this.ensureNotClosed();
        return Optional.ofNullable(this.cagesByName.get(name));
    }

    public List<CageModern> findCagesInRegion(Rectangle2D region) {
        if (region == null) {
            throw new IllegalArgumentException("Region cannot be null");
        }
        this.ensureNotClosed();
        this.lock.readLock().lock();
        try {
            List<CageModern> list = this.cages.stream().filter(cage -> region.intersects(cage.getData().getBounds())).collect(Collectors.toList());
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public List<CageModern> findValidCages() {
        this.ensureNotClosed();
        this.lock.readLock().lock();
        try {
            List<CageModern> list = this.cages.stream().filter(cage -> cage.getData().isValid()).collect(Collectors.toList());
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public List<CageModern> findActiveCages() {
        this.ensureNotClosed();
        this.lock.readLock().lock();
        try {
            List<CageModern> list = this.cages.stream().filter(cage -> cage.getData().isDetectEnabled()).collect(Collectors.toList());
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CageOperationResult mergeCages(CagesArrayModern otherArray) {
        if (otherArray == null) {
            return CageOperationResult.failure("MERGE_CAGES", new IllegalArgumentException("Other array cannot be null"), "Cannot merge with null array");
        }
        this.ensureNotClosed();
        this.lock.writeLock().lock();
        try {
            long startTime = System.currentTimeMillis();
            int addedCount = 0;
            int skippedCount = 0;
            ArrayList<String> addedCages = new ArrayList<String>();
            ArrayList<String> skippedCages = new ArrayList<String>();
            for (CageModern cage : otherArray.getCages()) {
                String cageName = cage.getData().getName();
                int cageID = cage.getData().getProperties().getCageID();
                if (!this.cagesByID.containsKey(cageID) && !this.cagesByName.containsKey(cageName)) {
                    this.cages.add(cage);
                    this.cagesByID.put(cageID, cage);
                    this.cagesByName.put(cageName, cage);
                    ++addedCount;
                    addedCages.add(cageName);
                    continue;
                }
                ++skippedCount;
                skippedCages.add(cageName + " (duplicate)");
            }
            long processingTime = System.currentTimeMillis() - startTime;
            CageOperationResult cageOperationResult = CageOperationResult.builder().success(addedCount > 0).operationType("MERGE_CAGES").message(String.format("Merged %d cages, skipped %d duplicates", addedCount, skippedCount)).processingTimeMs(processingTime).addMetadata("addedCount", addedCount).addMetadata("skippedCount", skippedCount).addMetadata("addedCages", addedCages).addMetadata("skippedCages", skippedCages).build();
            return cageOperationResult;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CageOperationResult clearAllCages() {
        this.ensureNotClosed();
        this.lock.writeLock().lock();
        try {
            long startTime = System.currentTimeMillis();
            int removedCount = this.cages.size();
            for (CageModern cage : this.cages) {
                try {
                    cage.close();
                }
                catch (Exception e) {
                    LOGGER.warning("Error closing cage during clear: " + e.getMessage());
                }
            }
            this.cages.clear();
            this.cagesByID.clear();
            this.cagesByName.clear();
            long processingTime = System.currentTimeMillis() - startTime;
            CageOperationResult cageOperationResult = CageOperationResult.success("CLEAR_CAGES", "Successfully cleared all cages").toBuilder().processingTimeMs(processingTime).addMetadata("removedCount", removedCount).build();
            return cageOperationResult;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CageOperationResult transferCagesToSequence(SequenceCamData seqCamData) {
        if (seqCamData == null) {
            return CageOperationResult.failure("TRANSFER_TO_SEQUENCE", new IllegalArgumentException("SequenceCamData cannot be null"), "Cannot transfer to null sequence");
        }
        this.ensureNotClosed();
        this.lock.readLock().lock();
        try {
            long startTime = System.currentTimeMillis();
            ArrayList<ROI2D> cageROIList = new ArrayList<ROI2D>(this.cages.size());
            for (CageModern cage : this.cages) {
                cageROIList.add(cage.getData().getRoi());
            }
            seqCamData.getSequence().addROIs(cageROIList, true);
            long processingTime = System.currentTimeMillis() - startTime;
            CageOperationResult cageOperationResult = CageOperationResult.success("TRANSFER_TO_SEQUENCE", "Successfully transferred " + cageROIList.size() + " cages to sequence").toBuilder().processingTimeMs(processingTime).addMetadata("transferredCount", cageROIList.size()).build();
            return cageOperationResult;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public CagesArrayConfiguration getConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.closed) {
            this.lock.writeLock().lock();
            try {
                if (!this.closed) {
                    for (CageModern cage : this.cages) {
                        try {
                            cage.close();
                        }
                        catch (Exception e) {
                            LOGGER.warning("Error closing cage: " + cage.getData().getName() + " - " + e.getMessage());
                        }
                    }
                    this.cages.clear();
                    this.cagesByID.clear();
                    this.cagesByName.clear();
                    this.closed = true;
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    public String toString() {
        return String.format("ModernCagesArray{cages=%d, valid=%d, active=%d}", this.cages.size(), this.findValidCages().size(), this.findActiveCages().size());
    }

    private void ensureNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("CagesArray is closed");
        }
    }

    public static class Builder {
        private CagesArrayConfiguration configuration = CagesArrayConfiguration.defaultConfiguration();

        public Builder withConfiguration(CagesArrayConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public CagesArrayModern build() {
            return new CagesArrayModern(this.configuration);
        }
    }
}

