/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.series;

import icy.gui.frame.progress.ProgressFrame;
import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageCursor;
import icy.sequence.Sequence;
import icy.system.SystemUtil;
import icy.system.thread.Processor;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.SwingUtilities;
import plugins.fmp.multiSPOTS96.experiment.Experiment;
import plugins.fmp.multiSPOTS96.experiment.cages.Cage;
import plugins.fmp.multiSPOTS96.experiment.sequence.SequenceCamData;
import plugins.fmp.multiSPOTS96.experiment.spots.Spot;
import plugins.fmp.multiSPOTS96.series.AdaptiveBatchSizer;
import plugins.fmp.multiSPOTS96.series.AdvancedMemoryOptions;
import plugins.fmp.multiSPOTS96.series.BuildSeries;
import plugins.fmp.multiSPOTS96.series.CompressedMask;
import plugins.fmp.multiSPOTS96.series.ImageMemoryPool;
import plugins.fmp.multiSPOTS96.series.MemoryMonitor;
import plugins.fmp.multiSPOTS96.series.ResultsThreshold;
import plugins.fmp.multiSPOTS96.series.StreamingImageProcessor;
import plugins.fmp.multiSPOTS96.tools.ROI2D.ROI2DProcessingException;
import plugins.fmp.multiSPOTS96.tools.ROI2D.ROI2DValidationException;
import plugins.fmp.multiSPOTS96.tools.ROI2D.ROI2DWithMask;
import plugins.fmp.multiSPOTS96.tools.ViewerFMP;
import plugins.fmp.multiSPOTS96.tools.imageTransform.ImageTransformInterface;
import plugins.fmp.multiSPOTS96.tools.imageTransform.ImageTransformOptions;

public class BuildSpotsMeasuresAdvanced
extends BuildSeries {
    private StreamingImageProcessor streamingProcessor;
    private final ConcurrentHashMap<String, CompressedMask> compressedMasks = new ConcurrentHashMap();
    private int totalTransformedImagesCreated = 0;
    private int totalCursorsCreated = 0;
    private int batchCount = 0;
    private final MemoryMonitor memoryMonitor;
    private final AdaptiveBatchSizer adaptiveBatchSizer;
    private ImageMemoryPool imageMemoryPool = null;
    private ImageMemoryPool transformedImagePool = null;
    private boolean memoryPoolEnabled = true;
    public Sequence seqData = new Sequence();
    private ViewerFMP vData = null;
    private ImageTransformOptions transformOptions01 = null;
    ImageTransformInterface transformFunctionSpot = null;
    ImageTransformOptions transformOptions02 = null;
    ImageTransformInterface transformFunctionFly = null;

    public BuildSpotsMeasuresAdvanced(AdvancedMemoryOptions advancedOptions) {
        if (advancedOptions == null) {
            new AdvancedMemoryOptions();
        }
        this.memoryMonitor = new MemoryMonitor();
        this.streamingProcessor = new StreamingImageProcessor(this.memoryMonitor);
        this.adaptiveBatchSizer = new AdaptiveBatchSizer(this.memoryMonitor);
        if (this.memoryPoolEnabled) {
            try {
                this.imageMemoryPool = new ImageMemoryPool();
                this.transformedImagePool = new ImageMemoryPool();
            }
            catch (Exception e) {
                System.err.println("WARNING: Failed to create image memory pools: " + e.getMessage());
                this.memoryPoolEnabled = false;
                this.imageMemoryPool = null;
                this.transformedImagePool = null;
            }
        }
    }

    @Override
    void analyzeExperiment(Experiment exp) {
        this.logMemoryUsage("Before Analysis");
        this.streamingProcessor = new StreamingImageProcessor(new MemoryMonitor());
        this.batchCount = 0;
        this.getTimeLimitsOfSequence(exp);
        this.loadExperimentDataToMeasureSpots(exp);
        exp.cagesArray.setReadyToAnalyze(true, this.options);
        this.openViewers(exp);
        boolean processed = this.measureSpotsAdvanced(exp);
        if (processed) {
            this.saveComputation(exp);
        }
        this.logMemoryUsage("After Processing");
        exp.cagesArray.setReadyToAnalyze(false, this.options);
        this.closeViewers();
        this.cleanupResources();
        this.enhancedPostProcessingCleanup();
    }

    private boolean loadExperimentDataToMeasureSpots(Experiment exp) {
        exp.load_MS96_experiment();
        exp.seqCamData.attachSequence(exp.seqCamData.getImageLoader().initSequenceFromFirstImage(exp.seqCamData.getImagesList(true)));
        boolean flag = exp.load_MS96_cages();
        if (exp.seqCamData.getTimeManager().getBinDurationMs() == 0L) {
            exp.loadFileIntervalsFromSeqCamData();
        }
        return flag;
    }

    private void saveComputation(Experiment exp) {
        String directory = exp.getDirectoryToSaveResults();
        if (directory == null) {
            return;
        }
        exp.cagesArray.transferMeasuresToLevel2D();
        exp.cagesArray.medianFilterFromSumToSumClean();
        exp.save_MS96_experiment();
        exp.save_MS96_spotsMeasures();
    }

    private void initMeasureSpots(Experiment exp) {
        this.initMasks2DCompressed(exp);
        this.initSpotsDataArrays(exp);
        if (this.transformFunctionSpot == null) {
            this.transformOptions01 = new ImageTransformOptions();
            this.transformOptions01.transformOption = this.options.transform01;
            this.transformOptions01.copyResultsToThe3planes = false;
            this.transformOptions01.setSingleThreshold(this.options.spotThreshold, this.options.spotThresholdUp);
            this.transformFunctionSpot = this.options.transform01.getFunction();
            this.transformOptions02 = new ImageTransformOptions();
            this.transformOptions02.transformOption = this.options.transform02;
            this.transformOptions02.copyResultsToThe3planes = false;
            this.transformFunctionFly = this.options.transform02.getFunction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean measureSpotsAdvanced(Experiment exp) {
        if (exp.cagesArray.getTotalNumberOfSpots() < 1) {
            return false;
        }
        this.threadRunning = true;
        this.stopFlag = false;
        if (!exp.seqCamData.build_MsTimesArray_From_FileNamesList()) {
            return false;
        }
        int iiFirst = 0;
        int iiLast = exp.seqCamData.getImageLoader().getNTotalFrames();
        this.vData.setTitle(exp.seqCamData.getCSCamFileName() + ": " + iiFirst + "-" + iiLast);
        ProgressFrame progressBar1 = new ProgressFrame("Analyze stack (Advanced)");
        this.adaptiveBatchSizer.initialize(iiLast - iiFirst, this.memoryMonitor.getAvailableMemoryMB());
        this.initMeasureSpots(exp);
        this.streamingProcessor.start(exp.seqCamData, iiFirst, iiLast);
        try {
            for (int batchStart = iiFirst; batchStart < iiLast; batchStart += this.adaptiveBatchSizer.getCurrentBatchSize()) {
                if (this.stopFlag) {
                    break;
                }
                int batchEnd = Math.min(batchStart + this.adaptiveBatchSizer.getCurrentBatchSize(), iiLast);
                this.processFrameBatchAdvanced(exp, batchStart, batchEnd, iiFirst, iiLast, progressBar1);
                this.adaptiveBatchSizer.updateBatchSize(this.memoryMonitor.getMemoryUsagePercent());
                this.checkMemoryPressure();
                System.gc();
            }
        }
        finally {
            this.streamingProcessor.stop();
        }
        progressBar1.close();
        return true;
    }

    private void processFrameBatchAdvanced(final Experiment exp, int batchStart, int batchEnd, final int iiFirst, int iiLast, ProgressFrame progressBar1) {
        if (this.options.enableMemoryProfiling) {
            this.logMemoryUsage("Before Batch " + batchStart + "-" + (batchEnd - 1));
        }
        Processor processor = new Processor(Math.min(this.options.maxConcurrentTasks, SystemUtil.getNumberOfCPUs()));
        processor.setThreadName("measureSpotsAdvanced");
        processor.setPriority(5);
        ArrayList tasks = new ArrayList(batchEnd - batchStart);
        for (int ii = batchStart; ii < batchEnd && !this.stopFlag; ++ii) {
            IcyBufferedImage sourceImage0;
            if (this.options.concurrentDisplay && (sourceImage0 = this.streamingProcessor.getImage(ii)) != null) {
                this.seqData.setImage(0, 0, (BufferedImage)sourceImage0);
                this.vData.setTitle("Frame #" + ii + " /" + iiLast);
            }
            final int t = ii;
            progressBar1.setMessage("Analyze frame: " + t + "//" + iiLast);
            String fileName = exp.seqCamData.getFileNameFromImageList(t);
            if (fileName == null) {
                System.out.println("filename null at t=" + t);
                continue;
            }
            final IcyBufferedImage sourceImage = this.streamingProcessor.getImage(t);
            tasks.add(processor.submit(new Runnable(){

                @Override
                public void run() {
                    BuildSpotsMeasuresAdvanced.this.processSingleFrameAdvanced(exp, t, iiFirst, sourceImage);
                }
            }));
        }
        this.waitFuturesCompletion(processor, tasks, null);
        if (this.options.enableMemoryProfiling) {
            this.logMemoryUsage("After Batch " + batchStart + "-" + (batchEnd - 1));
        }
        ++this.batchCount;
        if (this.batchCount % 5 == 0 || this.getMemoryUsagePercent() > 60.0) {
            this.forceAggressiveCleanup();
        } else {
            System.gc();
            Thread.yield();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSingleFrameAdvanced(Experiment exp, int frameIndex, int iiFirst, IcyBufferedImage sourceImage) {
        IcyBufferedImage transformToMeasureArea = null;
        IcyBufferedImage transformToDetectFly = null;
        IcyBufferedImageCursor cursorToDetectFly = null;
        IcyBufferedImageCursor cursorToMeasureArea = null;
        try {
            if (this.imageMemoryPool != null && this.memoryPoolEnabled && frameIndex == iiFirst) {
                this.imageMemoryPool.initializeWithImage(sourceImage);
                this.transformedImagePool.initializeWithImage(sourceImage);
            }
            if (this.transformedImagePool != null && this.memoryPoolEnabled) {
                transformToMeasureArea = this.transformedImagePool.getImage();
                transformToDetectFly = this.transformedImagePool.getImage();
                if (transformToMeasureArea != null && transformToDetectFly != null) {
                    IcyBufferedImage tempMeasureArea = this.transformFunctionSpot.getTransformedImage(sourceImage, this.transformOptions01);
                    IcyBufferedImage tempDetectFly = this.transformFunctionFly.getTransformedImage(sourceImage, this.transformOptions02);
                    this.copyImageData(tempMeasureArea, transformToMeasureArea);
                    this.copyImageData(tempDetectFly, transformToDetectFly);
                    this.totalTransformedImagesCreated += 2;
                } else {
                    transformToMeasureArea = this.transformFunctionSpot.getTransformedImage(sourceImage, this.transformOptions01);
                    transformToDetectFly = this.transformFunctionFly.getTransformedImage(sourceImage, this.transformOptions02);
                    this.totalTransformedImagesCreated += 2;
                }
            } else {
                transformToMeasureArea = this.transformFunctionSpot.getTransformedImage(sourceImage, this.transformOptions01);
                transformToDetectFly = this.transformFunctionFly.getTransformedImage(sourceImage, this.transformOptions02);
                this.totalTransformedImagesCreated += 2;
            }
            if (this.imageMemoryPool != null && this.memoryPoolEnabled) {
                cursorToDetectFly = this.imageMemoryPool.createCursor(transformToDetectFly);
                cursorToMeasureArea = this.imageMemoryPool.createCursor(transformToMeasureArea);
            } else {
                cursorToDetectFly = new IcyBufferedImageCursor(transformToDetectFly);
                cursorToMeasureArea = new IcyBufferedImageCursor(transformToMeasureArea);
            }
            this.totalCursorsCreated += 2;
            int ii_local = frameIndex - iiFirst;
            for (Cage cage : exp.cagesArray.cagesList) {
                for (Spot spot : cage.spotsArray.getSpotsList()) {
                    if (!spot.isReadyForAnalysis()) continue;
                    ROI2DWithMask roiT = spot.getROIMask();
                    ResultsThreshold results = this.measureSpotOverThresholdCompressed(cursorToMeasureArea, cursorToDetectFly, roiT, transformToMeasureArea);
                    if (results.npoints_in <= 0) continue;
                    spot.getFlyPresent().setIsPresentAt(ii_local, results.nPoints_fly_present);
                    spot.getSum().setValueAt(ii_local, results.sumOverThreshold / (double)results.npoints_in);
                    if (results.nPoints_no_fly == results.npoints_in) continue;
                    spot.getSum().setValueAt(ii_local, results.sumTot_no_fly_over_threshold / (double)results.nPoints_no_fly);
                }
            }
            if (this.transformedImagePool != null && this.memoryPoolEnabled) {
                if (transformToMeasureArea != null) {
                    this.transformedImagePool.returnImage(transformToMeasureArea);
                }
                if (transformToDetectFly != null) {
                    this.transformedImagePool.returnImage(transformToDetectFly);
                }
            }
            transformToMeasureArea = null;
            transformToDetectFly = null;
            cursorToDetectFly = null;
            cursorToMeasureArea = null;
        }
        catch (Throwable throwable) {
            if (this.transformedImagePool != null && this.memoryPoolEnabled) {
                if (transformToMeasureArea != null) {
                    this.transformedImagePool.returnImage(transformToMeasureArea);
                }
                if (transformToDetectFly != null) {
                    this.transformedImagePool.returnImage(transformToDetectFly);
                }
            }
            transformToMeasureArea = null;
            transformToDetectFly = null;
            cursorToDetectFly = null;
            cursorToMeasureArea = null;
            if (this.getMemoryUsagePercent() > 70.0) {
                System.gc();
            }
            throw throwable;
        }
        if (this.getMemoryUsagePercent() > 70.0) {
            System.gc();
        }
    }

    private ResultsThreshold measureSpotOverThresholdCompressed(IcyBufferedImageCursor cursorToMeasureArea, IcyBufferedImageCursor cursorToDetectFly, ROI2DWithMask roiT, IcyBufferedImage transformToMeasureArea) {
        ResultsThreshold result = new ResultsThreshold();
        if (cursorToMeasureArea == null || cursorToDetectFly == null) {
            System.err.println("Null cursor provided to measureSpotOverThresholdCompressed");
            result.npoints_in = 0;
            return result;
        }
        CompressedMask compressedMask = this.getCompressedMask(roiT);
        if (compressedMask == null) {
            result.npoints_in = 0;
            return result;
        }
        int[] maskX = compressedMask.getXCoordinates();
        int[] maskY = compressedMask.getYCoordinates();
        if (maskX == null || maskY == null || maskX.length == 0 || maskY.length == 0) {
            System.err.println("Invalid mask coordinates");
            result.npoints_in = 0;
            return result;
        }
        result.npoints_in = maskX.length;
        try {
            if (transformToMeasureArea == null) {
                System.err.println("transformToMeasureArea is null in measureSpotOverThresholdCompressed");
                result.npoints_in = 0;
                return result;
            }
            int imageWidth = transformToMeasureArea.getSizeX();
            int imageHeight = transformToMeasureArea.getSizeY();
            for (int offset = 0; offset < maskX.length; ++offset) {
                int x = maskX[offset];
                int y = maskY[offset];
                if (x < 0 || y < 0 || x >= imageWidth || y >= imageHeight) continue;
                int value = (int)cursorToMeasureArea.get(x, y, 0);
                int value_to_detect_fly = (int)cursorToDetectFly.get(x, y, 0);
                boolean isFlyThere = this.isFlyPresent(value_to_detect_fly);
                if (!isFlyThere) {
                    ++result.nPoints_no_fly;
                } else {
                    ++result.nPoints_fly_present;
                }
                if (!this.isOverThreshold(value)) continue;
                result.sumOverThreshold += (double)value;
                ++result.nPointsOverThreshold;
                if (isFlyThere) continue;
                result.sumTot_no_fly_over_threshold += (double)value;
            }
        }
        catch (Exception e) {
            System.err.println("Error in measureSpotOverThresholdCompressed: " + e.getMessage());
            result.npoints_in = 0;
        }
        return result;
    }

    private CompressedMask getCompressedMask(ROI2DWithMask roiT) {
        String maskKey = roiT.getInputRoi().getName() + "_" + System.identityHashCode(roiT.getInputRoi());
        return this.compressedMasks.computeIfAbsent(maskKey, key -> {
            Point[] maskPoints = roiT.getMaskPoints();
            if (maskPoints == null || maskPoints.length == 0) {
                return null;
            }
            return new CompressedMask(maskPoints);
        });
    }

    private boolean isFlyPresent(double value) {
        boolean flag;
        boolean bl = flag = value > (double)this.options.flyThreshold;
        if (!this.options.flyThresholdUp) {
            flag = !flag;
        }
        return flag;
    }

    private boolean isOverThreshold(double value) {
        boolean flag;
        boolean bl = flag = value > (double)this.options.spotThreshold;
        if (!this.options.spotThresholdUp) {
            flag = !flag;
        }
        return flag;
    }

    private void initSpotsDataArrays(Experiment exp) {
        int nFrames = exp.seqCamData.getImageLoader().getNTotalFrames();
        int spotArrayGlobalIndex = 0;
        for (Cage cage : exp.cagesArray.cagesList) {
            int spotPosition = 0;
            for (Spot spot : cage.spotsArray.getSpotsList()) {
                spot.getProperties().setCagePosition(spotPosition);
                spot.getProperties().setCageID(cage.getProperties().getCageID());
                spot.getProperties().setSpotArrayIndex(spotArrayGlobalIndex);
                spot.getSum().setValues(new double[nFrames]);
                spot.getSumClean().setValues(new double[nFrames]);
                spot.getFlyPresent().setIsPresent(new int[nFrames]);
                ++spotArrayGlobalIndex;
                ++spotPosition;
            }
        }
    }

    private void initMasks2DCompressed(Experiment exp) {
        SequenceCamData seqCamData = exp.seqCamData;
        if (seqCamData.getSequence() == null) {
            seqCamData.attachSequence(exp.seqCamData.getImageLoader().initSequenceFromFirstImage(exp.seqCamData.getImagesList(true)));
        }
        for (Cage cage : exp.cagesArray.cagesList) {
            for (Spot spot : cage.spotsArray.getSpotsList()) {
                ROI2DWithMask roiT = null;
                try {
                    roiT = new ROI2DWithMask(spot.getRoi());
                    roiT.buildMask2DFromInputRoi();
                }
                catch (ROI2DProcessingException | ROI2DValidationException e) {
                    System.err.println("Error building mask for ROI: " + e.getMessage());
                    e.printStackTrace();
                }
                spot.setROIMask(roiT);
            }
        }
    }

    private void cleanupResources() {
        this.compressedMasks.clear();
        if (this.imageMemoryPool != null) {
            this.imageMemoryPool.performPeriodicCleanup();
        }
        if (this.transformedImagePool != null) {
            this.transformedImagePool.performPeriodicCleanup();
        }
    }

    private void closeViewers() {
        this.closeViewer(this.vData);
        this.closeSequence(this.seqData);
    }

    private void openViewers(final Experiment exp) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    BuildSpotsMeasuresAdvanced.this.seqData = BuildSpotsMeasuresAdvanced.this.newSequence(exp.seqCamData.getCSCamFileName(), exp.seqCamData.getSeqImage(0, 0));
                    BuildSpotsMeasuresAdvanced.this.vData = new ViewerFMP(BuildSpotsMeasuresAdvanced.this.seqData, true, true);
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private void logMemoryUsage(String stage) {
        Runtime runtime = Runtime.getRuntime();
        long totalMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        long usedMemory = totalMemory - freeMemory;
        long maxMemory = runtime.maxMemory();
        System.out.println("=== " + stage + " ===");
        System.out.println("Used Memory: " + usedMemory / 1024L / 1024L + " MB");
        System.out.println("Free Memory: " + freeMemory / 1024L / 1024L + " MB");
        System.out.println("Total Memory: " + totalMemory / 1024L / 1024L + " MB");
        System.out.println("Max Memory: " + maxMemory / 1024L / 1024L + " MB");
        System.out.println("Memory Usage: " + usedMemory * 100L / maxMemory + "%");
        System.out.println("Compressed Masks: " + this.compressedMasks.size());
        System.out.println("Total Transformed Images: " + this.totalTransformedImagesCreated);
        System.out.println("Total Cursors: " + this.totalCursorsCreated);
        if (this.imageMemoryPool != null && this.memoryPoolEnabled) {
            System.out.println("Source Image Pool: " + this.imageMemoryPool.getPoolStatistics());
        }
        if (this.transformedImagePool != null && this.memoryPoolEnabled) {
            System.out.println("Transformed Image Pool: " + this.transformedImagePool.getPoolStatistics());
        }
    }

    private void forceAggressiveCleanup() {
        for (int i = 0; i < 3; ++i) {
            System.gc();
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.clearImageCaches();
        this.clearCompressedMaskCache();
        if (this.imageMemoryPool != null) {
            this.imageMemoryPool.clearPool();
        }
        if (this.transformedImagePool != null) {
            this.transformedImagePool.clearPool();
        }
    }

    private void clearImageCaches() {
        try {
            Class<?> icyImageCacheClass = Class.forName("icy.image.ImageCache");
            Method clearCacheMethod = icyImageCacheClass.getDeclaredMethod("clearCache", new Class[0]);
            if (clearCacheMethod != null) {
                clearCacheMethod.setAccessible(true);
                clearCacheMethod.invoke(null, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void clearCompressedMaskCache() {
        if (this.compressedMasks.size() > 1000) {
            System.out.println("Clearing compressed mask cache (size: " + this.compressedMasks.size() + ")");
            this.compressedMasks.clear();
        }
    }

    private double getMemoryUsagePercent() {
        Runtime runtime = Runtime.getRuntime();
        long usedMemory = runtime.totalMemory() - runtime.freeMemory();
        return (double)usedMemory * 100.0 / (double)runtime.maxMemory();
    }

    private void checkMemoryPressure() {
        double usagePercent = this.getMemoryUsagePercent();
        if (usagePercent > 70.0) {
            System.out.println("=== HIGH MEMORY PRESSURE DETECTED: " + usagePercent + "% ===");
            this.forceAggressiveCleanup();
            if (this.adaptiveBatchSizer != null) {
                this.adaptiveBatchSizer.reduceBatchSize();
                System.out.println("Reduced batch size due to memory pressure");
            }
        } else if (usagePercent > 50.0) {
            System.gc();
            Thread.yield();
        }
    }

    private void enhancedPostProcessingCleanup() {
        for (int i = 0; i < 5; ++i) {
            System.gc();
            try {
                Thread.sleep(200L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.clearAllCaches();
        this.clearAllReferences();
        this.forceIcyCleanup();
    }

    private void clearAllCaches() {
        if (this.compressedMasks != null) {
            this.compressedMasks.clear();
        }
        this.totalTransformedImagesCreated = 0;
        this.totalCursorsCreated = 0;
    }

    private void clearAllReferences() {
        if (this.seqData != null) {
            try {
                Method clearMethod = this.seqData.getClass().getDeclaredMethod("clear", new Class[0]);
                if (clearMethod != null) {
                    clearMethod.setAccessible(true);
                    clearMethod.invoke((Object)this.seqData, new Object[0]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.vData != null) {
            try {
                this.vData.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.vData = null;
        }
    }

    private void forceIcyCleanup() {
        try {
            Class<?> icyImageCacheClass = Class.forName("icy.image.ImageCache");
            Method clearCacheMethod = icyImageCacheClass.getDeclaredMethod("clearCache", new Class[0]);
            if (clearCacheMethod != null) {
                clearCacheMethod.setAccessible(true);
                clearCacheMethod.invoke(null, new Object[0]);
            }
        }
        catch (Exception e) {
            System.out.println("WARNING: Could not clear Icy image cache: " + e.getMessage());
        }
        try {
            Class<?> icySequenceClass = Class.forName("icy.sequence.Sequence");
            Method disposeMethod = icySequenceClass.getDeclaredMethod("dispose", new Class[0]);
            if (disposeMethod != null) {
                disposeMethod.setAccessible(true);
                disposeMethod.invoke((Object)this.seqData, new Object[0]);
                System.out.println("Disposed Icy sequence");
            }
        }
        catch (Exception e) {
            System.out.println("WARNING: Could not dispose Icy sequence: " + e.getMessage());
        }
    }

    private void copyImageData(IcyBufferedImage source, IcyBufferedImage destination) {
        if (source == null || destination == null) {
            return;
        }
        try {
            destination.setDataXY(0, source.getDataXY(0));
        }
        catch (Exception e) {
            System.err.println("Error copying image data: " + e.getMessage());
        }
    }
}

