/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.series;

import java.awt.Point;
import java.util.ArrayList;

public class CompressedMask {
    private final byte[] compressedData;
    private volatile int[] xCoords;
    private volatile int[] yCoords;
    private final int originalSize;

    public CompressedMask(Point[] points) {
        this.originalSize = points.length * 8;
        this.compressedData = this.compressCoordinates(points);
    }

    public int[] getXCoordinates() {
        if (this.xCoords == null) {
            this.decompressData();
        }
        return this.xCoords;
    }

    public int[] getYCoordinates() {
        if (this.yCoords == null) {
            this.decompressData();
        }
        return this.yCoords;
    }

    public double getCompressionRatio() {
        return (double)this.compressedData.length / (double)this.originalSize;
    }

    private synchronized void decompressData() {
        int i;
        if (this.xCoords != null && this.yCoords != null) {
            return;
        }
        ArrayList<Integer> xList = new ArrayList<Integer>();
        ArrayList<Integer> yList = new ArrayList<Integer>();
        for (i = 0; i < this.compressedData.length; ++i) {
            int lastY;
            int lastX;
            byte code = this.compressedData[i];
            if (code == 0) {
                if (i + 4 >= this.compressedData.length) continue;
                int x = (this.compressedData[i + 1] & 0xFF) << 8 | this.compressedData[i + 2] & 0xFF;
                int y = (this.compressedData[i + 3] & 0xFF) << 8 | this.compressedData[i + 4] & 0xFF;
                xList.add(x);
                yList.add(y);
                i += 4;
                continue;
            }
            if (code == 1) {
                if (xList.isEmpty() || yList.isEmpty()) continue;
                lastX = (Integer)xList.get(xList.size() - 1);
                lastY = (Integer)yList.get(yList.size() - 1);
                xList.add(lastX + 1);
                yList.add(lastY);
                continue;
            }
            if (code != 2 || xList.isEmpty() || yList.isEmpty()) continue;
            lastX = (Integer)xList.get(xList.size() - 1);
            lastY = (Integer)yList.get(yList.size() - 1);
            xList.add(lastX);
            yList.add(lastY + 1);
        }
        this.xCoords = new int[xList.size()];
        this.yCoords = new int[yList.size()];
        for (i = 0; i < xList.size(); ++i) {
            this.xCoords[i] = (Integer)xList.get(i);
            this.yCoords[i] = (Integer)yList.get(i);
        }
    }

    private byte[] compressCoordinates(Point[] points) {
        ArrayList<Byte> compressed = new ArrayList<Byte>();
        for (int i = 0; i < points.length; ++i) {
            if (i > 0 && points[i].x == points[i - 1].x + 1 && points[i].y == points[i - 1].y) {
                compressed.add((byte)1);
                continue;
            }
            if (i > 0 && points[i].x == points[i - 1].x && points[i].y == points[i - 1].y + 1) {
                compressed.add((byte)2);
                continue;
            }
            compressed.add((byte)0);
            compressed.add((byte)(points[i].x >> 8));
            compressed.add((byte)(points[i].x & 0xFF));
            compressed.add((byte)(points[i].y >> 8));
            compressed.add((byte)(points[i].y & 0xFF));
        }
        byte[] result = new byte[compressed.size()];
        for (int i = 0; i < compressed.size(); ++i) {
            result[i] = (Byte)compressed.get(i);
        }
        return result;
    }
}

