/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.tools.ROI2D;

import java.awt.geom.Point2D;
import java.util.List;
import plugins.fmp.multiSPOTS96.tools.ROI2D.ROI2DValidationException;
import plugins.fmp.multiSPOTS96.tools.ROI2D.ROI2DValidator;
import plugins.kernel.roi.roi2d.ROI2DPolygon;

public class ROI2DPolygonPlus
extends ROI2DPolygon {
    private int cageRow = -1;
    private int cageColumn = -1;
    private int cagePosition = -1;
    private boolean selected = false;

    public ROI2DPolygonPlus() {
    }

    public ROI2DPolygonPlus(int cageRow, int cageColumn) throws ROI2DValidationException {
        this.setCageRow(cageRow);
        this.setCageColumn(cageColumn);
    }

    public ROI2DPolygonPlus(List<Point2D> points, int cageRow, int cageColumn) throws ROI2DValidationException {
        super(ROI2DPolygonPlus.validateAndGetPoints(points));
        this.setCageRow(cageRow);
        this.setCageColumn(cageColumn);
    }

    private static List<Point2D> validateAndGetPoints(List<Point2D> points) throws ROI2DValidationException {
        ROI2DValidator.validateNotNullOrEmpty(points, "points");
        if (points.size() < 3) {
            throw new ROI2DValidationException("points", points.size(), String.format("Polygon requires at least %d points, but only %d provided", 3, points.size()));
        }
        return points;
    }

    public int getCageRow() {
        return this.cageRow;
    }

    public void setCageRow(int cageRow) throws ROI2DValidationException {
        if (cageRow < -1) {
            throw new ROI2DValidationException("cageRow", cageRow, "Row must be non-negative or -1 for unset");
        }
        this.cageRow = cageRow;
    }

    public int getCageColumn() {
        return this.cageColumn;
    }

    public void setCageColumn(int cageColumn) throws ROI2DValidationException {
        if (cageColumn < -1) {
            throw new ROI2DValidationException("cageColumn", cageColumn, "Column must be non-negative or -1 for unset");
        }
        this.cageColumn = cageColumn;
    }

    public int getCagePosition() {
        return this.cagePosition;
    }

    public void setCagePosition(int cagePosition) throws ROI2DValidationException {
        if (cagePosition < -1) {
            throw new ROI2DValidationException("cagePosition", cagePosition, "Position must be non-negative or -1 for unset");
        }
        this.cagePosition = cagePosition;
    }

    public boolean getSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean hasValidCoordinates() {
        return this.cageRow >= 0 && this.cageColumn >= 0;
    }

    public boolean hasValidPosition() {
        return this.cagePosition >= 0;
    }

    public void resetCageProperties() {
        this.cageRow = -1;
        this.cageColumn = -1;
        this.cagePosition = -1;
        this.selected = false;
    }

    public String getCagePropertiesString() {
        return String.format("Cage[row=%d, col=%d, pos=%d, selected=%s]", this.cageRow, this.cageColumn, this.cagePosition, this.selected);
    }

    public ROI2DPolygonPlus getCopy() {
        ROI2DPolygonPlus copy = new ROI2DPolygonPlus();
        copy.setPolygon2D(this.getPolygon2D());
        copy.setName(this.getName());
        copy.setColor(this.getColor());
        copy.setStroke(this.getStroke());
        try {
            copy.setCageRow(this.cageRow);
            copy.setCageColumn(this.cageColumn);
            copy.setCagePosition(this.cagePosition);
            copy.setSelected(this.selected);
        }
        catch (ROI2DValidationException e) {
            throw new RuntimeException("Failed to copy cage properties", e);
        }
        return copy;
    }

    public String toString() {
        return String.format("%s - %s", super.toString(), this.getCagePropertiesString());
    }
}

