/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.tools.overlay;

import icy.canvas.IcyCanvas;
import icy.canvas.IcyCanvas2D;
import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageUtil;
import icy.image.colormap.IcyColorMap;
import icy.painter.Overlay;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import icy.sequence.SequenceListener;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import plugins.fmp.multiSPOTS96.tools.imageTransform.ImageTransformEnums;
import plugins.fmp.multiSPOTS96.tools.imageTransform.ImageTransformInterface;
import plugins.fmp.multiSPOTS96.tools.imageTransform.ImageTransformOptions;
import plugins.fmp.multiSPOTS96.tools.overlay.OverlayColorMask;

public class OverlayThreshold
extends Overlay
implements SequenceListener {
    private static final Logger LOGGER = Logger.getLogger(OverlayThreshold.class.getName());
    private static final String DEFAULT_OVERLAY_NAME = "ThresholdOverlay";
    private static final float DEFAULT_OPACITY = 0.3f;
    private static final Color DEFAULT_MASK_COLOR = new Color(0xFF0000, true);
    private static final String DEFAULT_COLOR_MAP_NAME = "overlaymask";
    private float opacity = 0.3f;
    private final OverlayColorMask colorMap = new OverlayColorMask("overlaymask", DEFAULT_MASK_COLOR);
    private final ImageTransformOptions imageTransformOptions = new ImageTransformOptions();
    private ImageTransformInterface imageTransformFunction = ImageTransformEnums.NONE.getFunction();
    private ImageTransformInterface imageThresholdFunction = ImageTransformEnums.NONE.getFunction();
    private Sequence localSequence;

    public OverlayThreshold() {
        this(null);
    }

    public OverlayThreshold(Sequence sequence) {
        super(DEFAULT_OVERLAY_NAME);
        if (sequence != null) {
            this.setSequence(sequence);
        }
    }

    public void setSequence(Sequence sequence) {
        if (sequence == null) {
            throw new IllegalArgumentException("Sequence cannot be null");
        }
        if (this.localSequence != null) {
            this.localSequence.removeListener((SequenceListener)this);
        }
        this.localSequence = sequence;
        sequence.addListener((SequenceListener)this);
    }

    public Sequence getSequence() {
        return this.localSequence;
    }

    public void setOpacity(float opacity) {
        if (opacity < 0.0f || opacity > 1.0f) {
            throw new IllegalArgumentException("Opacity must be between 0.0 and 1.0, got: " + opacity);
        }
        this.opacity = opacity;
    }

    public float getOpacity() {
        return this.opacity;
    }

    public void setThresholdSingle(int threshold, ImageTransformEnums transformOp, boolean ifGreater) {
        this.setThresholdTransform(threshold, transformOp, ifGreater);
    }

    public void setThresholdTransform(int threshold, ImageTransformEnums transformOp, boolean ifGreater) {
        if (transformOp == null) {
            throw new IllegalArgumentException("Transform operation cannot be null");
        }
        this.imageTransformOptions.setSingleThreshold(threshold, ifGreater);
        this.imageTransformOptions.transformOption = transformOp;
        this.imageTransformFunction = transformOp.getFunction();
        this.imageThresholdFunction = ImageTransformEnums.THRESHOLD_SINGLE.getFunction();
    }

    public void setReferenceImage(IcyBufferedImage referenceImage) {
        if (referenceImage == null) {
            throw new IllegalArgumentException("Reference image cannot be null");
        }
        this.imageTransformOptions.backgroundImage = referenceImage;
    }

    public void setThresholdColor(ArrayList<Color> colorArray, int distanceType, int threshold) {
        if (colorArray == null || colorArray.isEmpty()) {
            throw new IllegalArgumentException("Color array cannot be null or empty");
        }
        this.imageTransformOptions.setColorArrayThreshold(distanceType, threshold, colorArray);
        this.imageTransformFunction = ImageTransformEnums.NONE.getFunction();
        this.imageThresholdFunction = ImageTransformEnums.THRESHOLD_COLORS.getFunction();
    }

    public IcyBufferedImage getTransformedImage(int timePoint) {
        if (this.localSequence == null) {
            LOGGER.warning("Cannot get transformed image: sequence is not set");
            return null;
        }
        try {
            IcyBufferedImage image = this.localSequence.getImage(timePoint, 0);
            if (image == null) {
                LOGGER.warning("No image found at time point: " + timePoint);
                return null;
            }
            return this.getTransformedImage(image);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error getting transformed image for time point " + timePoint, e);
            return null;
        }
    }

    public IcyBufferedImage getTransformedImage(IcyBufferedImage inputImage) {
        if (inputImage == null) {
            throw new IllegalArgumentException("Input image cannot be null");
        }
        try {
            IcyBufferedImage transformedImage = this.imageTransformFunction.getTransformedImage(inputImage, this.imageTransformOptions);
            if (transformedImage == null) {
                LOGGER.warning("Transform function returned null image");
                return null;
            }
            return this.imageThresholdFunction.getTransformedImage(transformedImage, this.imageTransformOptions);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error applying image transformation", e);
            return null;
        }
    }

    public void paint(Graphics2D graphics, Sequence sequence, IcyCanvas canvas) {
        if (graphics == null || sequence == null || canvas == null) {
            return;
        }
        if (!(canvas instanceof IcyCanvas2D)) {
            return;
        }
        try {
            int timePosition = canvas.getPositionT();
            IcyBufferedImage thresholdedImage = this.getTransformedImage(timePosition);
            if (thresholdedImage != null) {
                this.renderOverlay(graphics, thresholdedImage);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error painting overlay", e);
        }
    }

    private void renderOverlay(Graphics2D graphics, IcyBufferedImage thresholdedImage) {
        try {
            thresholdedImage.setColorMap(0, (IcyColorMap)this.colorMap);
            BufferedImage bufferedImage = IcyBufferedImageUtil.getARGBImage((IcyBufferedImage)thresholdedImage);
            Composite originalComposite = graphics.getComposite();
            graphics.setComposite(AlphaComposite.getInstance(3, this.opacity));
            graphics.drawImage((Image)bufferedImage, 0, 0, null);
            graphics.setComposite(originalComposite);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.log(Level.WARNING, "Overlay rendering was interrupted", e);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error rendering overlay", e);
        }
    }

    public void sequenceChanged(SequenceEvent sequenceEvent) {
        if (sequenceEvent == null) {
            return;
        }
        if (sequenceEvent.getSourceType() != SequenceEvent.SequenceEventSourceType.SEQUENCE_OVERLAY) {
            return;
        }
        if (sequenceEvent.getSource() == this && sequenceEvent.getType() == SequenceEvent.SequenceEventType.REMOVED) {
            this.cleanupSequenceListener(sequenceEvent.getSequence());
        }
    }

    public void sequenceClosed(Sequence sequence) {
        if (sequence != null) {
            this.cleanupSequenceListener(sequence);
        }
    }

    private void cleanupSequenceListener(Sequence sequence) {
        if (sequence != null) {
            sequence.removeListener((SequenceListener)this);
        }
        this.remove();
    }
}

