/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.dlg.b_spots;

import icy.gui.frame.progress.AnnounceFrame;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.sequence.Sequence;
import icy.type.geom.Polygon2D;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import plugins.fmp.multiSPOTS96.MultiSPOTS96;
import plugins.fmp.multiSPOTS96.experiment.Experiment;
import plugins.fmp.multiSPOTS96.experiment.ExperimentUtils;
import plugins.fmp.multiSPOTS96.experiment.cages.Cage;
import plugins.fmp.multiSPOTS96.experiment.cages.CagesArray;
import plugins.fmp.multiSPOTS96.tools.ROI2D.ROI2DGeometryException;
import plugins.fmp.multiSPOTS96.tools.ROI2D.ROI2DGrid;
import plugins.fmp.multiSPOTS96.tools.ROI2D.ROI2DValidationException;
import plugins.fmp.multiSPOTS96.tools.polyline.PolygonUtilities;
import plugins.kernel.roi.roi2d.ROI2DPolygon;
import plugins.kernel.roi.roi2d.ROI2DShape;

public class CreateCages
extends JPanel {
    private static final long serialVersionUID = -5257698990389571518L;
    private JButton createFrameButton = new JButton("(1) Create frame over all cages");
    private JButton createGridButton = new JButton("(2) Grid");
    private JButton createCagesButton = new JButton("(3) Create cages");
    private JSpinner nCagesPerPlateAlongXJSpinner = new JSpinner(new SpinnerNumberModel(6, 0, 10000, 1));
    private JSpinner nCagesPerPlateAlongYJSpinner = new JSpinner(new SpinnerNumberModel(8, 0, 10000, 1));
    private JSpinner width_intervalTextField = new JSpinner(new SpinnerNumberModel(4, 0, 10000, 1));
    private int width_interval = 1;
    private int height_interval = 1;
    private Polygon2D polygon2D = null;
    ROI2DPolygon roiCagesPerimeter = null;
    private ROI2DGrid roiGrid = null;
    private MultiSPOTS96 parent0;

    void init(GridLayout capLayout, MultiSPOTS96 parent0) {
        this.setLayout(capLayout);
        this.parent0 = parent0;
        FlowLayout flowLayout = new FlowLayout(0);
        flowLayout.setVgap(0);
        JPanel panel0 = new JPanel(flowLayout);
        panel0.add(this.createFrameButton);
        this.createFrameButton.setHorizontalAlignment(2);
        this.add(panel0);
        JPanel panel1 = new JPanel(flowLayout);
        panel1.add(this.createGridButton);
        this.createGridButton.setHorizontalAlignment(2);
        panel1.add(new JLabel("with"));
        panel1.add(this.nCagesPerPlateAlongXJSpinner);
        this.nCagesPerPlateAlongXJSpinner.setPreferredSize(new Dimension(40, 20));
        panel1.add(new JLabel("cols  x "));
        panel1.add(this.nCagesPerPlateAlongYJSpinner);
        this.nCagesPerPlateAlongYJSpinner.setPreferredSize(new Dimension(40, 20));
        panel1.add(new JLabel("rows"));
        this.add(panel1);
        JPanel panel2 = new JPanel(flowLayout);
        panel2.add(this.createCagesButton);
        this.createCagesButton.setHorizontalAlignment(2);
        panel2.add(new JLabel("with"));
        panel2.add(this.width_intervalTextField);
        this.width_intervalTextField.setPreferredSize(new Dimension(40, 20));
        panel2.add(new JLabel("pixels spacing"));
        this.add(panel2);
        JPanel panel3 = new JPanel(flowLayout);
        this.add(panel3);
        this.defineActionListeners();
    }

    private void defineActionListeners() {
        this.createFrameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = ((CreateCages)CreateCages.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    CreateCages.this.selectRoiPerimeterEnclosingCages(exp);
                    exp.seqCamData.removeROIsContainingString("cage");
                    CreateCages.this.removeGrid(exp);
                }
            }
        });
        this.createGridButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = ((CreateCages)CreateCages.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    CreateCages.this.createGrid(exp);
                }
            }
        });
        this.createCagesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = ((CreateCages)CreateCages.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    CreateCages.this.createCages(exp);
                    CreateCages.this.removeGrid(exp);
                    exp.saveCagesArray_File();
                }
            }
        });
    }

    private void removeGrid(Experiment exp) {
        if (this.roiGrid == null) {
            return;
        }
        exp.seqCamData.getSequence().removeROIs(this.roiGrid.getHorizontalRois(), false);
        exp.seqCamData.getSequence().removeROIs(this.roiGrid.getVerticalRois(), false);
    }

    private void createCages(Experiment exp) {
        this.polygon2D = this.getPolygonFromCagesPerimeterRoi(exp);
        if (this.polygon2D != null) {
            if (this.roiGrid == null) {
                this.createGrid(exp);
            }
            this.createCagesFromGrid(exp, this.roiGrid);
            ExperimentUtils.transferCagesToCamDataSequence(exp);
        }
    }

    private Polygon2D getPolygonFromCagesPerimeterRoi(Experiment exp) {
        this.selectRoiPerimeterEnclosingCages(exp);
        ROI2D roi = (ROI2D)exp.seqCamData.getSequence().getSelectedROI();
        this.polygon2D = PolygonUtilities.orderVerticesOf4CornersPolygon(((ROI2DPolygon)roi).getPolygon());
        exp.seqCamData.getSequence().removeROI((ROI)roi);
        return this.polygon2D;
    }

    void updateNColumnsFieldFromSequence() {
        int nrois;
        Experiment exp = this.parent0.expListCombo.getSelectedItem();
        if (exp != null && (nrois = exp.cagesArray.cagesList.size()) > 0) {
            this.nCagesPerPlateAlongXJSpinner.setValue(exp.cagesArray.nCagesAlongX);
            this.nCagesPerPlateAlongYJSpinner.setValue(exp.cagesArray.nCagesAlongY);
        }
    }

    private void selectRoiPerimeterEnclosingCages(Experiment exp) {
        Sequence seq = exp.seqCamData.getSequence();
        if (this.roiCagesPerimeter == null) {
            this.roiCagesPerimeter = new ROI2DPolygon(this.getPolygonEnclosingAllCages(exp));
            this.roiCagesPerimeter.setName("perimeter");
        }
        if (!seq.contains((ROI)this.roiCagesPerimeter)) {
            seq.addROI((ROI)this.roiCagesPerimeter);
        }
        this.roiCagesPerimeter.setColor(Color.orange);
        seq.setSelectedROI((ROI)this.roiCagesPerimeter);
    }

    private Polygon2D getPolygonEnclosingAllCages(Experiment exp) {
        if (exp.cagesArray.cagesList.size() > 0) {
            this.polygon2D = exp.cagesArray.getPolygon2DEnclosingAllCages();
        } else {
            Rectangle rect = new Rectangle(318, 125, 1260, 836);
            ArrayList<Point2D.Double> points = new ArrayList<Point2D.Double>();
            points.add(new Point2D.Double(rect.x, rect.y));
            points.add(new Point2D.Double(rect.x, rect.y + rect.height));
            points.add(new Point2D.Double(rect.x + rect.width, rect.y + rect.height));
            points.add(new Point2D.Double(rect.x + rect.width, rect.y));
            this.polygon2D = new Polygon2D(points);
        }
        return this.polygon2D;
    }

    private void createCagesFromGrid(Experiment exp, ROI2DGrid roiGrid) {
        int n_columns = 10;
        int n_rows = 1;
        try {
            n_columns = (Integer)this.nCagesPerPlateAlongXJSpinner.getValue();
            n_rows = (Integer)this.nCagesPerPlateAlongYJSpinner.getValue();
            this.height_interval = this.width_interval = ((Integer)this.width_intervalTextField.getValue()).intValue();
        }
        catch (Exception e) {
            new AnnounceFrame("Can't interpret ROI parameters value");
        }
        exp.seqCamData.removeROIsContainingString("cage");
        exp.cagesArray.cagesList.clear();
        exp.cagesArray = new CagesArray(n_columns, n_rows);
        this.createCagesArrayFromGrid(exp, roiGrid, n_columns, n_rows, this.width_interval, this.height_interval);
    }

    private void createCagesArrayFromGrid(Experiment exp, ROI2DGrid roiGrid, int ncolumns, int nrows, int width_interval, int height_interval) {
        Point2D.Double[][] grid = roiGrid.getGridPoints();
        if (grid.length != ncolumns + 1 || grid[0].length != nrows + 1) {
            System.out.println("error in the dimensions of grid");
        }
        String cageRoot = "cage";
        int index = 0;
        for (int row = 0; row < nrows; ++row) {
            for (int column = 0; column < ncolumns; ++column) {
                ROI2DPolygon roiP = this.createRoiPolygon(grid, column, row, width_interval, height_interval);
                roiP.setName(cageRoot + String.format("%03d", index));
                roiP.setColor(Color.magenta);
                Cage cage = new Cage((ROI2DShape)roiP);
                cage.getProperties().setCageID(index);
                cage.getProperties().setArrayIndex(index);
                cage.getProperties().setArrayColumn(column);
                cage.getProperties().setArrayRow(row);
                ++index;
                exp.seqCamData.getSequence().addROI((ROI)roiP);
                exp.cagesArray.cagesList.add(cage);
            }
        }
    }

    private ROI2DPolygon createRoiPolygon(Point2D.Double[][] grid, int icol, int irow, int width, int height) {
        ArrayList<Point2D.Double> points = new ArrayList<Point2D.Double>();
        Point2D.Double pt = (Point2D.Double)grid[icol][irow].clone();
        pt.x += (double)width;
        pt.y += (double)height;
        points.add(pt);
        pt = (Point2D.Double)grid[icol][irow + 1].clone();
        pt.x += (double)width;
        pt.y -= (double)height;
        points.add(pt);
        pt = (Point2D.Double)grid[icol + 1][irow + 1].clone();
        pt.x -= (double)width;
        pt.y -= (double)height;
        points.add(pt);
        pt = (Point2D.Double)grid[icol + 1][irow].clone();
        pt.x -= (double)width;
        pt.y += (double)height;
        points.add(pt);
        ROI2DPolygon roiP = new ROI2DPolygon(points);
        return roiP;
    }

    private void createGrid(Experiment exp) {
        exp.seqCamData.removeROIsContainingString("cage");
        exp.seqCamData.removeROIsContainingString("row");
        exp.seqCamData.removeROIsContainingString("col");
        int n_columns = 6;
        int n_rows = 8;
        try {
            n_columns = (Integer)this.nCagesPerPlateAlongXJSpinner.getValue();
            n_rows = (Integer)this.nCagesPerPlateAlongYJSpinner.getValue();
        }
        catch (Exception e) {
            new AnnounceFrame("Can't interpret one of the ROI parameters value");
        }
        Polygon2D polyGon = this.getPolygonFromCagesPerimeterRoi(exp);
        this.roiGrid = new ROI2DGrid();
        try {
            this.roiGrid.createGridFromFrame(polyGon, n_columns, n_rows);
            exp.seqCamData.getSequence().addROIs(this.roiGrid.getHorizontalRois(), false);
            exp.seqCamData.getSequence().addROIs(this.roiGrid.getVerticalRois(), false);
        }
        catch (ROI2DGeometryException | ROI2DValidationException e) {
            System.err.println("Error creating grid from frame: " + e.getMessage());
            e.printStackTrace();
            new AnnounceFrame("Error creating grid: " + e.getMessage());
        }
    }

    public void clearTemporaryROIs() {
        Experiment exp = this.parent0.expListCombo.getSelectedItem();
        if (exp != null) {
            this.removeGrid(exp);
            exp.seqCamData.getSequence().removeROI((ROI)this.roiCagesPerimeter);
            this.roiGrid = null;
            this.polygon2D = null;
            this.roiCagesPerimeter = null;
        }
    }
}

