/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.dlg.d_spotsMeasures;

import icy.gui.frame.IcyFrame;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.Range;
import plugins.fmp.multiSPOTS96.MultiSPOTS96;
import plugins.fmp.multiSPOTS96.experiment.Experiment;
import plugins.fmp.multiSPOTS96.tools.chart.ChartCageArrayFrame;

public class ChartOptions
extends JPanel {
    private static final long serialVersionUID = 1L;
    IcyFrame dialogFrame = null;
    private MultiSPOTS96 parent0 = null;
    private ChartCageArrayFrame chartCageArrayFrame = null;
    private JSpinner lowerXSpinner = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 255.0, 1.0));
    private JSpinner upperXSpinner = new JSpinner(new SpinnerNumberModel(120.0, 0.0, 255.0, 1.0));
    private JSpinner lowerYSpinner = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 255.0, 1.0));
    private JSpinner upperYSpinner = new JSpinner(new SpinnerNumberModel(80.0, 0.0, 255.0, 1.0));
    private JButton setYaxis = new JButton("set Y axis values");
    private JButton setXaxis = new JButton("set X axis values");

    public void initialize(MultiSPOTS96 parent0, ChartCageArrayFrame chartSpots) {
        this.parent0 = parent0;
        this.chartCageArrayFrame = chartSpots;
        JPanel topPanel = new JPanel(new GridLayout(2, 1));
        FlowLayout flowLayout = new FlowLayout(0);
        JPanel panel1 = new JPanel(flowLayout);
        panel1.add(new JLabel("x axis values:"));
        panel1.add(this.lowerXSpinner);
        panel1.add(this.upperXSpinner);
        panel1.add(this.setXaxis);
        topPanel.add(panel1);
        JPanel panel2 = new JPanel(flowLayout);
        panel2.add(new JLabel("y axis values:"));
        panel2.add(this.lowerYSpinner);
        panel2.add(this.upperYSpinner);
        panel2.add(this.setYaxis);
        topPanel.add(panel2);
        this.dialogFrame = new IcyFrame("Chart options", true, true);
        this.dialogFrame.add((Component)topPanel, (Object)"North");
        this.dialogFrame.pack();
        this.dialogFrame.addToDesktopPane();
        this.dialogFrame.requestFocus();
        this.dialogFrame.center();
        this.dialogFrame.setVisible(true);
        this.collectValuesFromAllCharts();
        this.defineActionListeners();
    }

    public void close() {
        this.dialogFrame.close();
        Experiment exp = this.parent0.expListCombo.getSelectedItem();
        if (exp != null) {
            exp.saveSpotsArray_file();
        }
    }

    private void defineActionListeners() {
        this.setXaxis.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = ((ChartOptions)ChartOptions.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    ChartOptions.this.updateXAxis();
                }
            }
        });
        this.setYaxis.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = ((ChartOptions)ChartOptions.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    ChartOptions.this.updateYAxis();
                }
            }
        });
    }

    private void collectValuesFromAllCharts() {
        int nrows = this.chartCageArrayFrame.chartPanelArray.length;
        int ncolumns = this.chartCageArrayFrame.chartPanelArray[0].length;
        this.chartCageArrayFrame.setXRange(null);
        this.chartCageArrayFrame.setYRange(null);
        for (int column = 0; column < ncolumns; ++column) {
            for (int row = 0; row < nrows; ++row) {
                XYPlot plot;
                ChartPanel chartPanel = this.chartCageArrayFrame.chartPanelArray[row][column].getChartPanel();
                if (chartPanel == null || (plot = (XYPlot)chartPanel.getChart().getPlot()) == null) continue;
                ValueAxis xAxis = plot.getDomainAxis();
                ValueAxis yAxis = plot.getRangeAxis();
                if (xAxis != null) {
                    this.chartCageArrayFrame.setXRange(Range.combine((Range)this.chartCageArrayFrame.getXRange(), (Range)xAxis.getRange()));
                }
                if (yAxis == null) continue;
                this.chartCageArrayFrame.setYRange(Range.combine((Range)this.chartCageArrayFrame.getYRange(), (Range)yAxis.getRange()));
            }
        }
        if (this.chartCageArrayFrame.getXRange() != null) {
            this.lowerXSpinner.setValue(this.chartCageArrayFrame.getXRange().getLowerBound());
            this.upperXSpinner.setValue(this.chartCageArrayFrame.getXRange().getUpperBound());
        }
        if (this.chartCageArrayFrame.getYRange() != null) {
            this.lowerYSpinner.setValue(this.chartCageArrayFrame.getYRange().getLowerBound());
            this.upperYSpinner.setValue(this.chartCageArrayFrame.getYRange().getUpperBound());
        }
    }

    private void updateXAxis() {
        int nrows = this.chartCageArrayFrame.chartPanelArray.length;
        int ncolumns = this.chartCageArrayFrame.chartPanelArray[0].length;
        double upper = (Double)this.upperXSpinner.getValue();
        double lower = (Double)this.lowerXSpinner.getValue();
        for (int column = 0; column < ncolumns; ++column) {
            for (int row = 0; row < nrows; ++row) {
                ChartPanel chartPanel = this.chartCageArrayFrame.chartPanelArray[row][column].getChartPanel();
                if (chartPanel == null) continue;
                XYPlot xyPlot = (XYPlot)chartPanel.getChart().getPlot();
                NumberAxis xAxis = (NumberAxis)xyPlot.getDomainAxis();
                xAxis.setAutoRange(false);
                xAxis.setRange(lower, upper);
            }
        }
    }

    private void updateYAxis() {
        int nrows = this.chartCageArrayFrame.chartPanelArray.length;
        int ncolumns = this.chartCageArrayFrame.chartPanelArray[0].length;
        double upper = (Double)this.upperYSpinner.getValue();
        double lower = (Double)this.lowerYSpinner.getValue();
        for (int column = 0; column < ncolumns; ++column) {
            for (int row = 0; row < nrows; ++row) {
                ChartPanel chartPanel = this.chartCageArrayFrame.chartPanelArray[row][column].getChartPanel();
                if (chartPanel == null) continue;
                XYPlot xyPlot = (XYPlot)chartPanel.getChart().getPlot();
                NumberAxis yAxis = (NumberAxis)xyPlot.getRangeAxis();
                yAxis.setAutoRange(false);
                yAxis.setRange(lower, upper);
            }
        }
    }
}

