/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.experiment.sequence;

import icy.image.IcyBufferedImage;
import icy.roi.ROI2D;
import icy.sequence.Sequence;
import java.awt.Rectangle;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import plugins.fmp.multiSPOTS96.experiment.EnumStatus;
import plugins.fmp.multiSPOTS96.experiment.sequence.ImageLoader;
import plugins.fmp.multiSPOTS96.experiment.sequence.ROIManager;
import plugins.fmp.multiSPOTS96.experiment.sequence.ROIOperation;
import plugins.fmp.multiSPOTS96.experiment.sequence.SequenceInfo;
import plugins.fmp.multiSPOTS96.experiment.sequence.TimeManager;
import plugins.fmp.multiSPOTS96.experiment.sequence.TimeRange;
import plugins.fmp.multiSPOTS96.experiment.sequence.TimeSource;
import plugins.fmp.multiSPOTS96.experiment.sequence.ViewerConfiguration;
import plugins.fmp.multiSPOTS96.experiment.sequence.ViewerManager;
import plugins.fmp.multiSPOTS96.tools.imageTransform.ImageTransformEnums;

public class SequenceCamData
implements AutoCloseable {
    private static final Logger LOGGER = Logger.getLogger(SequenceCamData.class.getName());
    private final ReentrantLock lock = new ReentrantLock();
    private volatile boolean closed = false;
    private Sequence seq = null;
    private EnumStatus status = EnumStatus.REGULAR;
    private int currentFrame = 0;
    private IcyBufferedImage referenceImage = null;
    private final ImageLoader imageLoader;
    private final TimeManager timeManager;
    private final ROIManager roiManager;
    private final ViewerManager viewerManager;

    public SequenceCamData() {
        this.imageLoader = new ImageLoader();
        this.timeManager = new TimeManager();
        this.roiManager = new ROIManager();
        this.viewerManager = new ViewerManager();
        this.seq = new Sequence();
        this.status = EnumStatus.FILESTACK;
    }

    public SequenceCamData(String name, IcyBufferedImage image) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        if (image == null) {
            throw new IllegalArgumentException("Image cannot be null");
        }
        this.imageLoader = new ImageLoader();
        this.timeManager = new TimeManager();
        this.roiManager = new ROIManager();
        this.viewerManager = new ViewerManager();
        this.seq = new Sequence(name, image);
        this.status = EnumStatus.FILESTACK;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean initializeFromDirectory(String directory) {
        if (directory == null || directory.trim().isEmpty()) {
            throw new IllegalArgumentException("Directory cannot be null or empty");
        }
        this.ensureNotClosed();
        this.lock.lock();
        try {
            this.imageLoader.setImagesDirectory(directory);
            boolean bl = this.imageLoader.loadImages(this);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void initializeFromImageList(List<String> imagesList) {
        if (imagesList == null || imagesList.isEmpty()) {
            throw new IllegalArgumentException("Images list cannot be null or empty");
        }
        this.ensureNotClosed();
        this.lock.lock();
        try {
            this.imageLoader.loadImageList(imagesList, this);
        }
        finally {
            this.lock.unlock();
        }
    }

    public SequenceInfo getSequenceInfo() {
        this.ensureNotClosed();
        this.lock.lock();
        try {
            SequenceInfo sequenceInfo = SequenceInfo.builder().name(this.imageLoader.getFileName()).currentFrame(this.currentFrame).totalFrames(this.seq != null ? this.seq.getSizeT() : 0).status(this.status).timeRange(this.getTimeRange()).build();
            return sequenceInfo;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IcyBufferedImage getSeqImage(int t, int z) {
        this.ensureNotClosed();
        if (this.seq == null) {
            throw new IllegalStateException("Sequence is not initialized");
        }
        this.validateFrameIndices(t, z);
        this.lock.lock();
        try {
            this.currentFrame = t;
            IcyBufferedImage icyBufferedImage = this.seq.getImage(t, z);
            return icyBufferedImage;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to get image at t=" + t + ", z=" + z, e);
            IcyBufferedImage icyBufferedImage = null;
            return icyBufferedImage;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDecoratedImageName(int t) {
        this.ensureNotClosed();
        this.lock.lock();
        try {
            this.currentFrame = t;
            String fileName = this.imageLoader.getFileName();
            if (this.seq != null) {
                String string = fileName + " [" + t + "/" + (this.seq.getSizeT() - 1) + "]";
                return string;
            }
            String string = fileName + "[]";
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processROIs(ROIOperation operation) {
        if (operation == null) {
            throw new IllegalArgumentException("Operation cannot be null");
        }
        this.ensureNotClosed();
        if (this.seq == null) {
            LOGGER.warning("Cannot process ROIs: sequence is not initialized");
            return false;
        }
        this.lock.lock();
        try {
            switch (operation.getType()) {
                case DISPLAY: {
                    this.roiManager.displaySpecificROIs(this.seq, operation.isVisible(), operation.getPattern());
                    boolean bl = true;
                    return bl;
                }
                case REMOVE: {
                    this.roiManager.removeROIsContainingString(this.seq, operation.getPattern());
                    boolean bl = true;
                    return bl;
                }
                case CENTER: {
                    this.roiManager.centerOnRoi(this.seq, operation.getRoi());
                    boolean bl = true;
                    return bl;
                }
                case SELECT: {
                    this.roiManager.selectRoi(this.seq, operation.getRoi(), operation.isSelected());
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to process ROI operation: " + (Object)((Object)operation.getType()), e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<ROI2D> findROIs(String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Pattern cannot be null");
        }
        this.ensureNotClosed();
        if (this.seq == null) {
            return new ArrayList<ROI2D>();
        }
        this.lock.lock();
        try {
            ArrayList<ROI2D> arrayList = this.roiManager.getROIsContainingString(this.seq, pattern);
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    public TimeRange getTimeRange() {
        this.ensureNotClosed();
        return new TimeRange(this.timeManager.getFirstImageMs(), this.timeManager.getLastImageMs(), this.timeManager.getBinDurationMs());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileTime getFileTime(int frame, TimeSource source) {
        if (source == null) {
            throw new IllegalArgumentException("Time source cannot be null");
        }
        this.ensureNotClosed();
        this.lock.lock();
        try {
            switch (source) {
                case STRUCTURED_NAME: {
                    FileTime fileTime = this.timeManager.getFileTimeFromStructuredName(this.imageLoader, frame);
                    return fileTime;
                }
                case FILE_ATTRIBUTES: {
                    FileTime fileTime = this.timeManager.getFileTimeFromFileAttributes(this.imageLoader, frame);
                    return fileTime;
                }
                case JPEG_METADATA: {
                    FileTime fileTime = this.timeManager.getFileTimeFromJPEGMetaData(this.imageLoader, frame);
                    return fileTime;
                }
            }
            FileTime fileTime = null;
            return fileTime;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean build_MsTimesArray_From_FileNamesList() {
        if (!this.getImageLoader().checkIfNFramesIsValid()) {
            return false;
        }
        this.getTimeManager().build_MsTimeArray_From_FileNamesList(this.getImageLoader());
        return true;
    }

    public void configureViewer(ViewerConfiguration config) {
        if (config == null) {
            throw new IllegalArgumentException("Configuration cannot be null");
        }
        this.ensureNotClosed();
        if (this.seq == null) {
            LOGGER.warning("Cannot configure viewer: sequence is not initialized");
            return;
        }
        this.lock.lock();
        try {
            if (config.getDisplayRectangle() != null) {
                this.viewerManager.displayViewerAtRectangle(this.seq, config.getDisplayRectangle());
            }
            if (config.isShowOverlay()) {
                this.viewerManager.updateOverlayThreshold(config.getThreshold(), config.getTransform(), config.isIfGreater());
            } else {
                this.viewerManager.removeOverlay(this.seq);
            }
            this.viewerManager.updateOverlay(this.seq);
        }
        finally {
            this.lock.unlock();
        }
    }

    public String getImagesDirectory() {
        return this.imageLoader.getImagesDirectory();
    }

    public void setImagesDirectory(String directoryString) {
        this.imageLoader.setImagesDirectory(directoryString);
    }

    public List<String> getImagesList(boolean bsort) {
        return this.imageLoader.getImagesList(bsort);
    }

    public List<String> getImagesList() {
        return this.imageLoader.getImagesList();
    }

    public void setImagesList(List<String> extImagesList) {
        this.imageLoader.setImagesList(extImagesList);
    }

    public String getCSCamFileName() {
        return this.imageLoader.getFileName();
    }

    public String getFileNameFromImageList(int t) {
        return this.imageLoader.getFileNameFromImageList(t);
    }

    public boolean loadImages() {
        return this.imageLoader.loadImages(this);
    }

    public boolean loadFirstImage() {
        return this.imageLoader.loadFirstImage(this);
    }

    public void loadImageList(List<String> imagesList) {
        this.imageLoader.loadImageList(imagesList, this);
    }

    public FileTime getFileTimeFromStructuredName(int t) {
        return this.timeManager.getFileTimeFromStructuredName(this.imageLoader, t);
    }

    public FileTime getFileTimeFromFileAttributes(int t) {
        return this.timeManager.getFileTimeFromFileAttributes(this.imageLoader, t);
    }

    public FileTime getFileTimeFromJPEGMetaData(int t) {
        return this.timeManager.getFileTimeFromJPEGMetaData(this.imageLoader, t);
    }

    public long getFirstImageMs() {
        return this.timeManager.getFirstImageMs();
    }

    public void setFirstImageMs(long timeMs) {
        this.timeManager.setFirstImageMs(timeMs);
    }

    public long getLastImageMs() {
        return this.timeManager.getLastImageMs();
    }

    public void setLastImageMs(long timeMs) {
        this.timeManager.setLastImageMs(timeMs);
    }

    public long getBinDurationMs() {
        return this.timeManager.getBinDurationMs();
    }

    public void setBinDurationMs(long durationMs) {
        this.timeManager.setBinDurationMs(durationMs);
    }

    public void displaySpecificROIs(boolean isVisible, String pattern) {
        this.roiManager.displaySpecificROIs(this.seq, isVisible, pattern);
    }

    public ArrayList<ROI2D> getROIsContainingString(String string) {
        return this.roiManager.getROIsContainingString(this.seq, string);
    }

    public void removeROIsContainingString(String string) {
        this.roiManager.removeROIsContainingString(this.seq, string);
    }

    public void centerDisplayOnRoi(ROI2D roi) {
        this.roiManager.centerOnRoi(this.seq, roi);
    }

    public void selectRoi(ROI2D roi, boolean select) {
        this.roiManager.selectRoi(this.seq, roi, select);
    }

    public void displayViewerAtRectangle(Rectangle parent0Rect) {
        this.viewerManager.displayViewerAtRectangle(this.seq, parent0Rect);
    }

    public void updateOverlay() {
        this.viewerManager.updateOverlay(this.seq);
    }

    public void removeOverlay() {
        this.viewerManager.removeOverlay(this.seq);
    }

    public void updateOverlayThreshold(int threshold, ImageTransformEnums transform, boolean ifGreater) {
        this.viewerManager.updateOverlayThreshold(threshold, transform, ifGreater);
    }

    public void attachSequence(Sequence sequence) {
        if (sequence == null) {
            throw new IllegalArgumentException("Sequence cannot be null");
        }
        this.ensureNotClosed();
        this.lock.lock();
        try {
            this.seq = sequence;
            this.status = EnumStatus.FILESTACK;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void closeSequence() {
        this.lock.lock();
        try {
            if (this.seq != null) {
                this.seq.removeAllROI();
                this.seq.close();
                this.seq = null;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.lock.lock();
            try {
                if (!this.closed) {
                    this.closeSequence();
                    this.referenceImage = null;
                    this.closed = true;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public Sequence getSequence() {
        return this.seq;
    }

    public EnumStatus getStatus() {
        return this.status;
    }

    public void setStatus(EnumStatus newStatus) {
        this.status = newStatus;
    }

    public int getCurrentFrame() {
        return this.currentFrame;
    }

    public void setCurrentFrame(int frame) {
        this.currentFrame = frame;
    }

    public ImageLoader getImageLoader() {
        return this.imageLoader;
    }

    public TimeManager getTimeManager() {
        return this.timeManager;
    }

    public ROIManager getRoiManager() {
        return this.roiManager;
    }

    public ViewerManager getViewerManager() {
        return this.viewerManager;
    }

    public IcyBufferedImage getReferenceImage() {
        return this.referenceImage;
    }

    public void setReferenceImage(IcyBufferedImage image) {
        this.referenceImage = image;
    }

    private void ensureNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("SequenceCamData is closed");
        }
    }

    private void validateFrameIndices(int t, int z) {
        if (t < 0 || t >= this.seq.getSizeT()) {
            throw new IndexOutOfBoundsException("Frame index out of bounds: " + t + " (max: " + (this.seq.getSizeT() - 1) + ")");
        }
        if (z < 0 || z >= this.seq.getSizeZ()) {
            throw new IndexOutOfBoundsException("Z index out of bounds: " + z + " (max: " + (this.seq.getSizeZ() - 1) + ")");
        }
    }

    public static class Builder {
        private String name;
        private IcyBufferedImage image;
        private String imagesDirectory;
        private EnumStatus status = EnumStatus.FILESTACK;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withImage(IcyBufferedImage image) {
            this.image = image;
            return this;
        }

        public Builder withImagesDirectory(String directory) {
            this.imagesDirectory = directory;
            return this;
        }

        public Builder withStatus(EnumStatus status) {
            this.status = status;
            return this;
        }

        public SequenceCamData build() {
            SequenceCamData data = this.name != null && this.image != null ? new SequenceCamData(this.name, this.image) : new SequenceCamData();
            if (this.imagesDirectory != null) {
                data.setImagesDirectory(this.imagesDirectory);
            }
            data.setStatus(this.status);
            return data;
        }
    }
}

