/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.experiment.spots;

import java.util.List;

public class SpotsArrayInfo {
    private final int totalSpots;
    private final int validSpots;
    private final int spotsWithMeasures;
    private final int spotsReadyForAnalysis;
    private final List<String> spotNames;
    private final boolean hasTimeIntervals;
    private final int timeIntervalsCount;

    private SpotsArrayInfo(Builder builder) {
        this.totalSpots = builder.totalSpots;
        this.validSpots = builder.validSpots;
        this.spotsWithMeasures = builder.spotsWithMeasures;
        this.spotsReadyForAnalysis = builder.spotsReadyForAnalysis;
        this.spotNames = builder.spotNames != null ? List.copyOf(builder.spotNames) : List.of();
        this.hasTimeIntervals = builder.hasTimeIntervals;
        this.timeIntervalsCount = builder.timeIntervalsCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getTotalSpots() {
        return this.totalSpots;
    }

    public int getValidSpots() {
        return this.validSpots;
    }

    public int getSpotsWithMeasures() {
        return this.spotsWithMeasures;
    }

    public int getSpotsReadyForAnalysis() {
        return this.spotsReadyForAnalysis;
    }

    public List<String> getSpotNames() {
        return this.spotNames;
    }

    public boolean hasTimeIntervals() {
        return this.hasTimeIntervals;
    }

    public int getTimeIntervalsCount() {
        return this.timeIntervalsCount;
    }

    public boolean hasValidSpots() {
        return this.validSpots > 0;
    }

    public double getValidSpotsRatio() {
        return this.totalSpots > 0 ? (double)this.validSpots / (double)this.totalSpots : 0.0;
    }

    public double getMeasuresCompletionRatio() {
        return this.totalSpots > 0 ? (double)this.spotsWithMeasures / (double)this.totalSpots : 0.0;
    }

    public boolean isReadyForAnalysis() {
        return this.spotsReadyForAnalysis > 0;
    }

    public String toString() {
        return String.format("SpotsArrayInfo{total=%d, valid=%d, withMeasures=%d, ready=%d, timeIntervals=%d}", this.totalSpots, this.validSpots, this.spotsWithMeasures, this.spotsReadyForAnalysis, this.timeIntervalsCount);
    }

    public static class Builder {
        private int totalSpots;
        private int validSpots;
        private int spotsWithMeasures;
        private int spotsReadyForAnalysis;
        private List<String> spotNames;
        private boolean hasTimeIntervals;
        private int timeIntervalsCount;

        public Builder totalSpots(int totalSpots) {
            this.totalSpots = totalSpots;
            return this;
        }

        public Builder validSpots(int validSpots) {
            this.validSpots = validSpots;
            return this;
        }

        public Builder spotsWithMeasures(int spotsWithMeasures) {
            this.spotsWithMeasures = spotsWithMeasures;
            return this;
        }

        public Builder spotsReadyForAnalysis(int spotsReadyForAnalysis) {
            this.spotsReadyForAnalysis = spotsReadyForAnalysis;
            return this;
        }

        public Builder spotNames(List<String> spotNames) {
            this.spotNames = spotNames;
            return this;
        }

        public Builder hasTimeIntervals(boolean hasTimeIntervals) {
            this.hasTimeIntervals = hasTimeIntervals;
            return this;
        }

        public Builder timeIntervalsCount(int timeIntervalsCount) {
            this.timeIntervalsCount = timeIntervalsCount;
            return this;
        }

        public SpotsArrayInfo build() {
            return new SpotsArrayInfo(this);
        }
    }
}

