/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.series;

import icy.gui.frame.progress.ProgressFrame;
import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageCursor;
import icy.sequence.Sequence;
import java.awt.Point;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import plugins.fmp.multiSPOTS96.experiment.Experiment;
import plugins.fmp.multiSPOTS96.experiment.cages.Cage;
import plugins.fmp.multiSPOTS96.experiment.spots.Spot;
import plugins.fmp.multiSPOTS96.series.BuildSeries;
import plugins.fmp.multiSPOTS96.tools.GaspardRigidRegistration;
import plugins.fmp.multiSPOTS96.tools.ROI2D.ROI2DWithMask;
import plugins.fmp.multiSPOTS96.tools.ViewerFMP;

public class BuildSpotsKymos
extends BuildSeries {
    public Sequence seqData = new Sequence();
    private ViewerFMP vData = null;
    private int kymoImageWidth = 0;

    @Override
    void analyzeExperiment(Experiment exp) {
        if (!this.loadExperimentDataToBuildKymos(exp) || exp.cagesArray.getTotalNumberOfSpots() < 1) {
            return;
        }
        this.openKymoViewers(exp);
        this.getTimeLimitsOfSequence(exp);
        if (this.buildKymo(exp)) {
            this.saveComputation(exp);
        }
        this.closeKymoViewers(exp);
    }

    private boolean loadExperimentDataToBuildKymos(Experiment exp) {
        boolean flag = exp.load_MS96_cages();
        exp.seqCamData.attachSequence(exp.seqCamData.getImageLoader().initSequenceFromFirstImage(exp.seqCamData.getImagesList(true)));
        return flag;
    }

    private void saveComputation(Experiment exp) {
        String directory = exp.getDirectoryToSaveResults();
        if (directory == null) {
            return;
        }
        ProgressFrame progressBar = new ProgressFrame("Save kymographs");
        progressBar.close();
        exp.save_MS96_experiment();
    }

    private boolean buildKymo(Experiment exp) {
        if (exp.cagesArray.getTotalNumberOfSpots() < 1) {
            System.out.println("BuildKymoSpots:buildKymo Abort (1): nb spots = 0");
            return false;
        }
        this.initArraysToBuildKymographImages(exp);
        this.threadRunning = true;
        this.stopFlag = false;
        boolean iiFirst = false;
        int iiLast = exp.seqCamData.getImageLoader().getFixedNumberOfImages() > 0L ? (int)exp.seqCamData.getImageLoader().getFixedNumberOfImages() : exp.seqCamData.getImageLoader().getNTotalFrames();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeImageWithSpot2(IcyBufferedImageCursor cursorSource, Spot spot, int t, int sizeC) {
        ROI2DWithMask roiT = spot.getROIMask();
        Point[] maskPoints = roiT.getMaskPoints();
        if (maskPoints == null) {
            return;
        }
        for (int chan = 0; chan < sizeC; ++chan) {
            IcyBufferedImageCursor cursor = new IcyBufferedImageCursor(spot.getSpotImage());
            try {
                int i = 0;
                for (int j = roiT.getYMin(); j < roiT.getYMax(); ++j) {
                    double iSum = 0.0;
                    int iN = 0;
                    for (int y = 0; y < maskPoints.length; ++y) {
                        Point pt = maskPoints[y];
                        if (pt.y != j) continue;
                        iSum += cursorSource.get((int)pt.getX(), (int)pt.getY(), chan);
                        ++iN;
                    }
                    if (iN == 0) {
                        iN = 1;
                    }
                    cursor.set(t, i, chan, iSum / (double)iN);
                    ++i;
                }
                continue;
            }
            finally {
                cursor.commitChanges();
            }
        }
    }

    private IcyBufferedImage loadImageFromIndex(Experiment exp, int frameIndex) {
        IcyBufferedImage sourceImage = this.imageIORead(exp.seqCamData.getFileNameFromImageList(frameIndex));
        if (this.options.doRegistration) {
            String referenceImageName = exp.seqCamData.getFileNameFromImageList(this.options.referenceFrame);
            IcyBufferedImage referenceImage = this.imageIORead(referenceImageName);
            this.adjustImage(sourceImage, referenceImage);
        }
        return sourceImage;
    }

    private void exportSpotImages_to_Kymograph(Experiment exp, int sizeC) {
    }

    private int getMaxImageHeight(Experiment exp) {
        int maxImageHeight = 0;
        for (Cage cage : exp.cagesArray.cagesList) {
            for (Spot spot : cage.spotsArray.getSpotsList()) {
                int height = spot.getSpotImage().getHeight();
                if (height <= maxImageHeight) continue;
                maxImageHeight = height;
            }
        }
        return maxImageHeight;
    }

    private void initArraysToBuildKymographImages(Experiment exp) {
    }

    private void adjustImage(IcyBufferedImage workImage, IcyBufferedImage referenceImage) {
        int referenceChannel = 0;
        GaspardRigidRegistration.getTranslation2D(workImage, referenceImage, referenceChannel);
        boolean rotate = GaspardRigidRegistration.correctRotation2D(workImage, referenceImage, referenceChannel);
        if (rotate) {
            GaspardRigidRegistration.getTranslation2D(workImage, referenceImage, referenceChannel);
        }
    }

    private void closeKymoViewers(Experiment exp) {
        this.closeViewer(this.vData);
        this.closeSequence(this.seqData);
    }

    private void openKymoViewers(final Experiment exp) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    BuildSpotsKymos.this.seqData = BuildSpotsKymos.this.newSequence("analyze stack starting with file " + exp.seqCamData.getSequence().getName(), exp.seqCamData.getSeqImage(0, 0));
                    BuildSpotsKymos.this.vData = new ViewerFMP(BuildSpotsKymos.this.seqData, true, true);
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

