/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.series;

import icy.gui.frame.progress.ProgressFrame;
import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageUtil;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.List;
import plugins.fmp.multiSPOTS96.experiment.Experiment;
import plugins.fmp.multiSPOTS96.series.BuildSeries;
import plugins.fmp.multiSPOTS96.series.DetectFlyTools;
import plugins.fmp.multiSPOTS96.tools.imageTransform.ImageTransformEnums;
import plugins.fmp.multiSPOTS96.tools.imageTransform.ImageTransformInterface;
import plugins.fmp.multiSPOTS96.tools.imageTransform.ImageTransformOptions;

public class DetectFlyFromCleanBackground
extends BuildSeries {
    private DetectFlyTools find_flies = new DetectFlyTools();
    public boolean viewInternalImages = true;

    @Override
    void analyzeExperiment(Experiment exp) {
        if (!this.loadSeqCamDataAndCages(exp)) {
            return;
        }
        if (!this.checkBoundsForCages(exp)) {
            return;
        }
        this.runFlyDetect2(exp);
        exp.cagesArray.orderFlyPositions();
        if (!this.stopFlag) {
            exp.save_MS96_fliesPositions();
        }
        exp.seqCamData.closeSequence();
    }

    private void runFlyDetect2(Experiment exp) {
        exp.cleanPreviousDetectedFliesROIs();
        this.find_flies.initParametersForDetection(exp, this.options);
        exp.cagesArray.initFlyPositions(this.options.detectCage);
        this.options.threshold = this.options.thresholdDiff;
        if (exp.loadReferenceImage()) {
            this.openFlyDetectViewers(exp);
            this.findFliesInAllFrames(exp);
        }
    }

    private void findFliesInAllFrames(Experiment exp) {
        ProgressFrame progressBar = new ProgressFrame("Detecting flies...");
        ImageTransformOptions transformOptions = new ImageTransformOptions();
        transformOptions.transformOption = ImageTransformEnums.SUBTRACT_REF;
        transformOptions.backgroundImage = IcyBufferedImageUtil.getCopy((IcyBufferedImage)exp.seqCamData.getReferenceImage());
        ImageTransformInterface transformFunction = transformOptions.transformOption.getFunction();
        int totalFrames = exp.seqCamData.getImageLoader().getNTotalFrames();
        for (int index = 0; index < totalFrames; ++index) {
            int t_from = index;
            String title = "Frame #" + t_from + "/" + exp.seqCamData.getImageLoader().getNTotalFrames();
            progressBar.setMessage(title);
            IcyBufferedImage workImage = this.imageIORead(exp.seqCamData.getFileNameFromImageList(t_from));
            IcyBufferedImage negativeImage = transformFunction.getTransformedImage(workImage, transformOptions);
            try {
                this.seqNegative.beginUpdate();
                this.seqNegative.setImage(0, 0, (BufferedImage)negativeImage);
                this.vNegative.setTitle(title);
                List<Rectangle2D> listRectangles = this.find_flies.findFlies(negativeImage, t_from);
                this.displayRectanglesAsROIs(this.seqNegative, listRectangles, true);
                this.seqNegative.endUpdate();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        progressBar.close();
    }
}

