/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.tools.JComponents;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class JComboBoxColorRenderer
extends JPanel
implements ListCellRenderer<Object> {
    private static final long serialVersionUID = -1L;
    JPanel textPanel = new JPanel();
    JLabel text;

    public JComboBoxColorRenderer(JComboBox<Color> combo) {
        this.textPanel.add(this);
        this.text = new JLabel();
        this.text.setOpaque(true);
        this.text.setFont(combo.getFont());
        this.text.setHorizontalAlignment(0);
        this.textPanel.add(this.text);
    }

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Color argb = Color.white;
        Color colorfont = Color.black;
        if (value != null) {
            argb = (Color)value;
            this.text.setText(this.getColorAsText(argb));
            colorfont = this.getInvertedColor(argb);
        } else {
            this.text.setText("");
        }
        this.text.setBackground(argb);
        this.text.setForeground(colorfont);
        return this.text;
    }

    private Color getInvertedColor(Color backgroundColor) {
        int b;
        int g;
        int r = backgroundColor.getRed();
        double luminance = (0.299 * (double)r + 0.587 * (double)(g = backgroundColor.getGreen()) + 0.114 * (double)(b = backgroundColor.getBlue())) / 255.0;
        int fontColorValue = luminance > 0.5 ? 0 : 255;
        return new Color(fontColorValue, fontColorValue, fontColorValue);
    }

    private String getColorAsText(Color color) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        return r + ":" + g + ":" + b;
    }
}

