/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.tools.polyline;

import icy.image.IcyBufferedImage;
import icy.roi.BooleanMask2D;
import icy.type.geom.Polygon2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Blobs {
    private static final Logger LOGGER = Logger.getLogger(Blobs.class.getName());
    private static final int BACKGROUND_VALUE = 0;
    private static final int FIRST_BLOB_NUMBER = 1;
    private static final double POLYGON_DEVIATION = 1.0;
    private static final double PIXEL_CENTER_OFFSET = 0.5;
    private final int[] binaryData;
    private final int imageWidth;
    private final int imageHeight;
    private final int totalPixels;

    public Blobs(IcyBufferedImage image) {
        if (image == null) {
            throw new IllegalArgumentException("Image cannot be null");
        }
        this.imageWidth = image.getSizeX();
        this.imageHeight = image.getSizeY();
        if (this.imageWidth <= 0 || this.imageHeight <= 0) {
            throw new IllegalArgumentException("Image dimensions must be positive: " + this.imageWidth + "x" + this.imageHeight);
        }
        this.totalPixels = this.imageWidth * this.imageHeight;
        this.binaryData = image.getDataXYAsInt(0);
        if (this.binaryData == null || this.binaryData.length != this.totalPixels) {
            throw new IllegalArgumentException("Invalid image data");
        }
    }

    public int getPixelsConnected() {
        int currentBlobNumber = 1;
        try {
            for (int y = 0; y < this.imageHeight; ++y) {
                for (int x = 0; x < this.imageWidth; ++x) {
                    int currentIndex = this.getPixelIndex(x, y);
                    if (this.binaryData[currentIndex] <= 0) continue;
                    int assignedLabel = this.findNeighborLabel(x, y);
                    this.binaryData[currentIndex] = assignedLabel > 0 ? assignedLabel : currentBlobNumber++;
                }
            }
            int numBlobs = currentBlobNumber - 1;
            return numBlobs;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error during connected component labeling", e);
            return 0;
        }
    }

    public void getBlobsConnected() {
        try {
            for (int y = 0; y < this.imageHeight; ++y) {
                for (int x = 0; x < this.imageWidth; ++x) {
                    int currentIndex = this.getPixelIndex(x, y);
                    if (this.binaryData[currentIndex] <= 0) continue;
                    int currentValue = this.binaryData[currentIndex];
                    this.mergeWithNeighbors(x, y, currentValue);
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error during blob merging", e);
        }
    }

    public void fillBlanksPixelsWithinBlobs() {
        try {
            for (int y = 0; y < this.imageHeight; ++y) {
                for (int x = 0; x < this.imageWidth; ++x) {
                    int currentIndex = this.getPixelIndex(x, y);
                    int blobValue = this.binaryData[currentIndex];
                    if (blobValue <= 0) continue;
                    int firstX = x;
                    int lastX = this.findLastOccurrenceInRow(y, x, blobValue);
                    for (int fillX = firstX; fillX <= lastX; ++fillX) {
                        this.binaryData[this.getPixelIndex((int)fillX, (int)y)] = blobValue;
                    }
                    x = lastX;
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error during hole filling", e);
        }
    }

    public int getBlobAt(int x, int y) {
        if (!this.isValidCoordinate(x, y)) {
            throw new IllegalArgumentException("Coordinates out of bounds: (" + x + ", " + y + ")");
        }
        return this.binaryData[this.getPixelIndex(x, y)];
    }

    public List<Integer> getListOfBlobs() {
        HashSet<Integer> uniqueBlobs = new HashSet<Integer>();
        for (int value : this.binaryData) {
            if (value <= 0) continue;
            uniqueBlobs.add(value);
        }
        ArrayList<Integer> result = new ArrayList<Integer>(uniqueBlobs);
        Collections.sort(result);
        return result;
    }

    @Deprecated
    public List<Integer> getListOfBlobs(int[] binaryData) {
        LOGGER.warning("Using deprecated method getListOfBlobs(int[])");
        return this.getListOfBlobs();
    }

    public Polygon2D getBlobPolygon2D(int blobNumber) {
        if (blobNumber <= 0) {
            throw new IllegalArgumentException("Invalid blob number: " + blobNumber);
        }
        try {
            ArrayList<Point> leftBoundary = new ArrayList<Point>();
            ArrayList<Point> rightBoundary = new ArrayList<Point>();
            for (int y = 0; y < this.imageHeight; ++y) {
                Point leftPoint = null;
                Point rightPoint = null;
                for (int x = 0; x < this.imageWidth; ++x) {
                    if (this.binaryData[this.getPixelIndex(x, y)] != blobNumber) continue;
                    if (leftPoint == null) {
                        leftPoint = new Point(x, y);
                    }
                    rightPoint = new Point(x, y);
                }
                if (leftPoint == null) continue;
                leftBoundary.add(leftPoint);
                if (leftPoint.equals(rightPoint)) continue;
                rightBoundary.add(rightPoint);
            }
            ArrayList<Point> allBoundaryPoints = new ArrayList<Point>();
            allBoundaryPoints.addAll(leftBoundary);
            Collections.reverse(rightBoundary);
            allBoundaryPoints.addAll(rightBoundary);
            ArrayList<Point2D.Double> polygonPoints = new ArrayList<Point2D.Double>(allBoundaryPoints.size());
            for (Point point : allBoundaryPoints) {
                polygonPoints.add(new Point2D.Double((double)point.x + 0.5, (double)point.y + 0.5));
            }
            return Polygon2D.getPolygon2D(polygonPoints, (double)1.0);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error creating polygon for blob " + blobNumber, e);
            return new Polygon2D();
        }
    }

    public BooleanMask2D getBlobBooleanMask2D(int blobNumber) {
        if (blobNumber <= 0) {
            throw new IllegalArgumentException("Invalid blob number: " + blobNumber);
        }
        try {
            ArrayList<Point> blobPoints = new ArrayList<Point>();
            for (int y = 0; y < this.imageHeight; ++y) {
                for (int x = 0; x < this.imageWidth; ++x) {
                    if (this.binaryData[this.getPixelIndex(x, y)] != blobNumber) continue;
                    blobPoints.add(new Point(x, y));
                }
            }
            if (blobPoints.isEmpty()) {
                LOGGER.warning("No pixels found for blob " + blobNumber);
                return new BooleanMask2D(new Point[0]);
            }
            Point[] pointArray = blobPoints.toArray(new Point[0]);
            return new BooleanMask2D(pointArray);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error creating boolean mask for blob " + blobNumber, e);
            return new BooleanMask2D(new Point[0]);
        }
    }

    public Rectangle getBlobRectangle(int blobNumber) {
        if (blobNumber <= 0) {
            throw new IllegalArgumentException("Invalid blob number: " + blobNumber);
        }
        try {
            int minX = this.imageWidth;
            int maxX = -1;
            int minY = this.imageHeight;
            int maxY = -1;
            boolean blobFound = false;
            for (int y = 0; y < this.imageHeight; ++y) {
                for (int x = 0; x < this.imageWidth; ++x) {
                    if (this.binaryData[this.getPixelIndex(x, y)] != blobNumber) continue;
                    blobFound = true;
                    minX = Math.min(minX, x);
                    maxX = Math.max(maxX, x);
                    minY = Math.min(minY, y);
                    maxY = Math.max(maxY, y);
                }
            }
            if (!blobFound) {
                LOGGER.warning("No pixels found for blob " + blobNumber);
                return new Rectangle(0, 0, 0, 0);
            }
            return new Rectangle(minX, minY, maxX - minX + 1, maxY - minY + 1);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error calculating rectangle for blob " + blobNumber, e);
            return new Rectangle(0, 0, 0, 0);
        }
    }

    public Point getImageDimensions() {
        return new Point(this.imageWidth, this.imageHeight);
    }

    public int getTotalPixels() {
        return this.totalPixels;
    }

    private int getPixelIndex(int x, int y) {
        return x + this.imageWidth * y;
    }

    private boolean isValidCoordinate(int x, int y) {
        return x >= 0 && x < this.imageWidth && y >= 0 && y < this.imageHeight;
    }

    private int findNeighborLabel(int x, int y) {
        if (y > 0 && this.binaryData[this.getPixelIndex(x, y - 1)] > 0) {
            return this.binaryData[this.getPixelIndex(x, y - 1)];
        }
        if (x > 0 && y > 0 && this.binaryData[this.getPixelIndex(x - 1, y - 1)] > 0) {
            return this.binaryData[this.getPixelIndex(x - 1, y - 1)];
        }
        if (x < this.imageWidth - 1 && y > 0 && this.binaryData[this.getPixelIndex(x + 1, y - 1)] > 0) {
            return this.binaryData[this.getPixelIndex(x + 1, y - 1)];
        }
        if (x > 0 && this.binaryData[this.getPixelIndex(x - 1, y)] > 0) {
            return this.binaryData[this.getPixelIndex(x - 1, y)];
        }
        return 0;
    }

    private void mergeWithNeighbors(int x, int y, int currentValue) {
        for (int dy = -1; dy <= 1; ++dy) {
            for (int dx = -1; dx <= 1; ++dx) {
                int neighborValue;
                int neighborY;
                int neighborX;
                if (dx == 0 && dy == 0 || !this.isValidCoordinate(neighborX = x + dx, neighborY = y + dy) || (neighborValue = this.binaryData[this.getPixelIndex(neighborX, neighborY)]) <= 0 || neighborValue == currentValue) continue;
                this.changeAllBlobNumber(neighborValue, currentValue);
            }
        }
    }

    private void changeAllBlobNumber(int oldValue, int newValue) {
        for (int i = 0; i < this.binaryData.length; ++i) {
            if (this.binaryData[i] != oldValue) continue;
            this.binaryData[i] = newValue;
        }
    }

    private int findLastOccurrenceInRow(int y, int startX, int blobValue) {
        int lastX = startX;
        for (int x = startX; x < this.imageWidth; ++x) {
            if (this.binaryData[this.getPixelIndex(x, y)] != blobValue) continue;
            lastX = x;
        }
        return lastX;
    }
}

