/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.tools.toExcel;

import plugins.fmp.multiSPOTS96.tools.toExcel.XLSExport;
import plugins.fmp.multiSPOTS96.tools.toExcel.XLSExportMeasuresFromSpot;
import plugins.fmp.multiSPOTS96.tools.toExcel.XLSExportMeasuresFromSpotOptimized;
import plugins.fmp.multiSPOTS96.tools.toExcel.XLSExportMeasuresFromSpotStreaming;
import plugins.fmp.multiSPOTS96.tools.toExcel.XLSExportOptions;
import plugins.fmp.multiSPOTS96.tools.toExcel.exceptions.ExcelExportException;

public class XLSExportFactory {
    private static final int SMALL_DATASET_THRESHOLD = 10;
    private static final int MEDIUM_DATASET_THRESHOLD = 100;
    private static final double MEMORY_USAGE_THRESHOLD = 0.7;
    private static final int BYTES_PER_SPOT_PER_TIME_POINT = 24;
    private static final int AVERAGE_TIME_POINTS_PER_SPOT = 1000;
    private static final int SPOTS_PER_EXPERIMENT = 96;
    private static final int EXPORT_TYPES = 3;

    public static XLSExport createExporter(int experimentCount, XLSExportOptions options) throws ExcelExportException {
        long estimatedMemoryMB = XLSExportFactory.estimateMemoryUsage(experimentCount);
        double availableMemoryMB = XLSExportFactory.getAvailableMemoryMB();
        double memoryUsageRatio = (double)estimatedMemoryMB / availableMemoryMB;
        if (experimentCount <= 10 && memoryUsageRatio < 0.3) {
            return XLSExportFactory.createOriginalExporter();
        }
        if (experimentCount <= 100 && memoryUsageRatio < 0.7) {
            return XLSExportFactory.createOptimizedExporter();
        }
        return XLSExportFactory.createStreamingExporter();
    }

    public static XLSExport createExporter(int experimentCount, XLSExportOptions options, boolean enableMemoryMonitoring) throws ExcelExportException {
        XLSExport exporter = XLSExportFactory.createExporter(experimentCount, options);
        if (enableMemoryMonitoring && exporter instanceof XLSExportMeasuresFromSpotStreaming) {
            ((XLSExportMeasuresFromSpotStreaming)exporter).setMemoryMonitoringEnabled(true);
        }
        return exporter;
    }

    public static XLSExport createOriginalExporter() {
        return new XLSExportMeasuresFromSpot();
    }

    public static XLSExport createOptimizedExporter() {
        return new XLSExportMeasuresFromSpotOptimized();
    }

    public static XLSExport createStreamingExporter() {
        return new XLSExportMeasuresFromSpotStreaming();
    }

    public static long estimateMemoryUsage(int experimentCount) {
        long totalSpots = (long)experimentCount * 96L;
        long totalTimePoints = totalSpots * 1000L;
        long totalDataPoints = totalTimePoints * 3L;
        long estimatedBytes = totalDataPoints * 24L;
        return estimatedBytes / 0x100000L;
    }

    public static double getAvailableMemoryMB() {
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        long totalMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        long availableMemory = maxMemory - totalMemory + freeMemory;
        return (double)availableMemory / 1048576.0;
    }

    public static double getMemoryUsagePercentage() {
        Runtime runtime = Runtime.getRuntime();
        long usedMemory = runtime.totalMemory() - runtime.freeMemory();
        return (double)usedMemory / (double)runtime.maxMemory();
    }

    public static boolean isUnderMemoryPressure() {
        return XLSExportFactory.getMemoryUsagePercentage() > 0.7;
    }

    public static String getRecommendation(int experimentCount) {
        long estimatedMemoryMB = XLSExportFactory.estimateMemoryUsage(experimentCount);
        double availableMemoryMB = XLSExportFactory.getAvailableMemoryMB();
        double memoryUsageRatio = (double)estimatedMemoryMB / availableMemoryMB;
        if (experimentCount <= 10 && memoryUsageRatio < 0.3) {
            return "Original implementation recommended (small dataset, low memory usage)";
        }
        if (experimentCount <= 100 && memoryUsageRatio < 0.7) {
            return "Optimized implementation recommended (medium dataset, moderate memory usage)";
        }
        return "Streaming implementation recommended (large dataset or memory constraints)";
    }

    public static XLSExport createExporterWithCustomThresholds(int experimentCount, XLSExportOptions options, int smallDatasetThreshold, int mediumDatasetThreshold, double memoryUsageThreshold) throws ExcelExportException {
        long estimatedMemoryMB = XLSExportFactory.estimateMemoryUsage(experimentCount);
        double availableMemoryMB = XLSExportFactory.getAvailableMemoryMB();
        double memoryUsageRatio = (double)estimatedMemoryMB / availableMemoryMB;
        if (experimentCount <= smallDatasetThreshold && memoryUsageRatio < 0.3) {
            return XLSExportFactory.createOriginalExporter();
        }
        if (experimentCount <= mediumDatasetThreshold && memoryUsageRatio < memoryUsageThreshold) {
            return XLSExportFactory.createOptimizedExporter();
        }
        return XLSExportFactory.createStreamingExporter();
    }

    public static String getMemoryAnalysis(int experimentCount) {
        long estimatedMemoryMB = XLSExportFactory.estimateMemoryUsage(experimentCount);
        double availableMemoryMB = XLSExportFactory.getAvailableMemoryMB();
        double memoryUsageRatio = (double)estimatedMemoryMB / availableMemoryMB;
        double currentMemoryUsage = XLSExportFactory.getMemoryUsagePercentage();
        StringBuilder analysis = new StringBuilder();
        analysis.append("Memory Analysis:\n");
        analysis.append(String.format("- Experiments: %d\n", experimentCount));
        analysis.append(String.format("- Estimated memory usage: %.1f MB\n", estimatedMemoryMB));
        analysis.append(String.format("- Available memory: %.1f MB\n", availableMemoryMB));
        analysis.append(String.format("- Memory usage ratio: %.1f%%\n", memoryUsageRatio * 100.0));
        analysis.append(String.format("- Current memory usage: %.1f%%\n", currentMemoryUsage * 100.0));
        analysis.append(String.format("- Recommendation: %s\n", XLSExportFactory.getRecommendation(experimentCount)));
        return analysis.toString();
    }

    public static boolean canHandleExport(int experimentCount) {
        double availableMemoryMB;
        long estimatedMemoryMB = XLSExportFactory.estimateMemoryUsage(experimentCount);
        return (double)estimatedMemoryMB < (availableMemoryMB = XLSExportFactory.getAvailableMemoryMB()) * 0.8;
    }

    public static long getMinimumRequiredMemory(int experimentCount) {
        return XLSExportFactory.estimateMemoryUsage(experimentCount);
    }
}

