/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.viewers;

import icy.canvas.IcyCanvas3D;
import icy.common.listener.ProgressListener;
import icy.gui.frame.progress.ToolTipFrame;
import icy.gui.viewer.Viewer;
import icy.image.colormap.IcyColorMap;
import icy.image.lut.LUT;
import icy.image.lut.LUTListener;
import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginCanvas;
import icy.sequence.DimensionId;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import icy.sequence.SequenceListener;
import icy.system.IcyHandledException;
import icy.system.thread.ThreadUtil;
import icy.type.DataType;
import icy.vtk.IcyVtkPanel;
import icy.vtk.VtkUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import javax.swing.JToolBar;
import vtk.vtkCamera;
import vtk.vtkCubeAxesActor2D;
import vtk.vtkDataObject;
import vtk.vtkDataSet;
import vtk.vtkElevationFilter;
import vtk.vtkImageData;
import vtk.vtkImageDataGeometryFilter;
import vtk.vtkLODActor;
import vtk.vtkLookupTable;
import vtk.vtkMapper;
import vtk.vtkPointSet;
import vtk.vtkPolyDataMapper;
import vtk.vtkProp;
import vtk.vtkRenderer;
import vtk.vtkScalarsToColors;
import vtk.vtkSliderRepresentation2D;
import vtk.vtkWarpScalar;

public class Elevation
extends Plugin
implements PluginCanvas {
    public String getCanvasClassName() {
        return ElevationCanvas.class.getName();
    }

    public ElevationCanvas createCanvas(Viewer viewer) {
        return new ElevationCanvas(viewer);
    }

    public static class ElevationCanvas
    extends IcyCanvas3D {
        final IcyVtkPanel vtkPanel;
        final vtkRenderer vtkRenderer;
        final vtkImageDataGeometryFilter geom;
        final vtkWarpScalar warp;
        final vtkElevationFilter elevationFilter;
        final vtkCubeAxesActor2D axes;
        final vtkLookupTable vtkLUT;
        private vtkImageData imageData;
        final vtkSliderRepresentation2D slider;
        private final LUT userLUT;
        private final LUTListener lutListener = event -> {
            this.updateVTKLUT();
            this.refresh();
        };
        private final SequenceListener dataListener = new SequenceListener(){

            public void sequenceClosed(Sequence sequence) {
                sequence.removeListener((SequenceListener)this);
            }

            public void sequenceChanged(SequenceEvent sequenceEvent) {
                if (sequenceEvent.getSourceType() == SequenceEvent.SequenceEventSourceType.SEQUENCE_DATA) {
                    this.updateVtkImageData();
                    this.refresh();
                }
            }
        };
        private final ToolTipFrame helpBox;

        public void keyTyped(KeyEvent e) {
            super.keyTyped(e);
            if (e.isConsumed()) {
                return;
            }
            if (e.getKeyChar() == 'c' || e.getKeyChar() == 'C') {
                this.setPositionC((this.getPositionC() + 1) % this.getSequence().getSizeC());
                e.consume();
            } else if (e.getKeyChar() == '-') {
                this.warp.SetScaleFactor(this.warp.GetScaleFactor() * 9.0 / 10.0);
                e.consume();
                this.refresh();
            } else if (e.getKeyChar() == '+') {
                this.warp.SetScaleFactor(this.warp.GetScaleFactor() * 10.0 / 9.0);
                e.consume();
                this.refresh();
            }
        }

        public void mouseWheelMoved(MouseWheelEvent event) {
            event.consume();
            double zoomFactor = Math.pow(1.02, event.getWheelRotation());
            vtkCamera camera = this.vtkPanel.getCamera();
            if (camera.GetParallelProjection() == 1) {
                camera.SetParallelScale(camera.GetParallelScale() / zoomFactor);
            } else {
                camera.Dolly(zoomFactor);
                this.vtkPanel.resetCameraClippingRange();
            }
            this.refresh();
        }

        public ElevationCanvas(Viewer viewer) {
            super(viewer);
            try {
                this.geom = new vtkImageDataGeometryFilter();
                this.warp = new vtkWarpScalar();
                this.elevationFilter = new vtkElevationFilter();
                this.axes = new vtkCubeAxesActor2D();
                this.vtkLUT = new vtkLookupTable();
                this.imageData = new vtkImageData();
                this.slider = new vtkSliderRepresentation2D();
            }
            catch (UnsatisfiedLinkError uslErr) {
                throw new IcyHandledException("The \"Elevation map\" viewer cannot be activated because VTK is not inialised properly.");
            }
            try {
                this.vtkPanel = new IcyVtkPanel();
            }
            catch (UnsatisfiedLinkError error) {
                throw new IcyHandledException("Cannot load the elevation map: VTK library not found.");
            }
            this.vtkRenderer = this.vtkPanel.getRenderer();
            this.add((Component)this.vtkPanel, "Center");
            this.userLUT = this.getLut();
            this.setPositionC(0);
            this.setPositionZ(viewer.getPositionZ());
            this.updateZNav();
            this.updateTNav();
            this.setPositionX(-1);
            this.setPositionY(-1);
            this.getMouseImageInfosPanel().setVisible(false);
            int sizeX = this.getSequence().getSizeX();
            int sizeY = this.getSequence().getSizeY();
            int minDim = Math.min(sizeX, sizeY);
            double max = this.getSequence().getChannelMax(this.getPositionC());
            this.geom.SetOutputTriangles(1);
            this.warp.SetInputData((vtkPointSet)this.geom.GetOutput());
            this.warp.SetScaleFactor(-0.25 / max * (double)minDim);
            this.elevationFilter.SetInputConnection(this.warp.GetOutputPort());
            vtkPolyDataMapper mapper = new vtkPolyDataMapper();
            mapper.SetInputConnection(this.elevationFilter.GetOutputPort());
            mapper.SetLookupTable((vtkScalarsToColors)this.vtkLUT);
            vtkLODActor actor = new vtkLODActor();
            actor.SetNumberOfCloudPoints(sizeX * sizeY / 100);
            actor.SetScale(1.0, 1.0, 1.0);
            actor.SetMapper((vtkMapper)mapper);
            this.vtkRenderer.AddActor((vtkProp)actor);
            this.axes.SetInputData((vtkDataSet)this.elevationFilter.GetPolyDataOutput());
            this.axes.SetCamera(this.vtkRenderer.GetActiveCamera());
            this.axes.SetLabelFormat("%7.0f");
            this.axes.SetXLabel("X");
            this.axes.SetYLabel("Y");
            this.axes.SetZLabel("Intensity");
            this.axes.SetFlyModeToOuterEdges();
            this.axes.SetFontFactor(0.9);
            this.axes.GetProperty().SetColor(1.0, 1.0, 1.0);
            this.axes.UseBoundsOff();
            this.axes.UseRangesOn();
            this.axes.SetCornerOffset(0.0);
            this.vtkRenderer.AddActor((vtkProp)this.axes);
            this.vtkRenderer.SetBackground(0.0, 0.0, 0.0);
            LUT.LUTChannel currentLUT = this.userLUT.getLutChannel(this.getPositionC());
            IcyColorMap map = currentLUT.getColorMap();
            this.vtkLUT.SetNumberOfColors(256L);
            for (int i = 0; i < 256; ++i) {
                this.vtkLUT.SetTableValue((long)i, (double)map.red.mapf[i], (double)map.green.mapf[i], (double)map.blue.mapf[i], 1.0);
            }
            this.updateVTKLUT();
            this.userLUT.addListener(this.lutListener);
            this.vtkRenderer.GetActiveCamera().SetViewUp(0.0, -1.0, 0.0);
            this.vtkRenderer.ResetCamera();
            this.vtkRenderer.GetActiveCamera().Elevation(180.0);
            this.vtkRenderer.ResetCameraClippingRange();
            String helpText = "<b>How to use the elevation map:</b><br><ul>";
            helpText = helpText + " <li>interact with the mouse and colormap just like in the 2D viewer<br>";
            helpText = helpText + " <li>press 'c' to toggle between channels<br>";
            helpText = helpText + " <li>press '+' or '-' to increase or decrease the depth";
            helpText = helpText + "</ul><i>(click on this message box to dismiss it)</i>";
            this.helpBox = new ToolTipFrame(helpText);
            this.getSequence().addListener(this.dataListener);
        }

        public void refresh() {
            this.vtkPanel.repaint();
        }

        protected void positionChanged(DimensionId dim) {
            this.updateVtkImageData();
            if (dim == DimensionId.C) {
                this.updateVTKLUT();
            }
            this.refresh();
        }

        public Component getViewComponent() {
            return this.vtkPanel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BufferedImage getRenderedImage(int t, int z, int c, boolean canvasView) {
            int oldT = this.getPositionT();
            int oldZ = this.getPositionZ();
            int oldC = this.getPositionC();
            this.setPositionT(t);
            this.setPositionZ(z);
            this.setPositionC(c);
            try {
                ThreadUtil.sleep((int)1000);
                BufferedImage bufferedImage = this.getRenderedImage();
                return bufferedImage;
            }
            finally {
                this.setPositionT(oldT);
                this.setPositionZ(oldZ);
                this.setPositionC(oldC);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Sequence getRenderedSequence(boolean canvasView, ProgressListener progressListener) {
            Sequence screenshot = new Sequence("Screenshot of " + this.getSequence().getName() + " (channel " + this.getSequence().getChannelName(this.getPositionC()) + ")");
            if (this.getSequence().getSizeZ() == 1 && this.getSequence().getSizeT() == 1) {
                screenshot.setImage(0, 0, this.getRenderedImage());
                return screenshot;
            }
            int oldT = this.getPositionT();
            int oldZ = this.getPositionZ();
            try {
                for (int t = 0; t < this.getSequence().getSizeT(); ++t) {
                    for (int z = 0; z < this.getSequence().getSizeZ(); ++z) {
                        this.setPositionTInternal(t);
                        this.setPositionZInternal(z);
                        this.positionChanged(DimensionId.NULL);
                        ThreadUtil.sleep((int)1000);
                        screenshot.setImage(t, z, this.getRenderedImage());
                    }
                }
                Sequence sequence = screenshot;
                return sequence;
            }
            finally {
                this.setPositionT(oldT);
                this.setPositionZ(oldZ);
            }
        }

        public BufferedImage getRenderedImage() {
            int w = this.vtkPanel.getWidth();
            int h = this.vtkPanel.getHeight();
            BufferedImage shot = new BufferedImage(w, h, 2);
            this.vtkPanel.paint((Graphics)shot.createGraphics());
            return shot;
        }

        private void updateVtkImageData() {
            Sequence seq = this.getSequence();
            if (this.getPositionC() == -1 || this.getPositionZ() == -1 || this.getPositionT() == -1) {
                return;
            }
            this.imageData = VtkUtil.getImageData((Object)seq.getDataXY(this.getPositionT(), this.getPositionZ(), this.getPositionC()), (DataType)seq.getDataType_(), (int)seq.getSizeX(), (int)seq.getSizeY(), (int)seq.getSizeZ(), (int)1);
            this.geom.SetInputData((vtkDataObject)this.imageData);
            this.geom.Update();
            this.axes.SetRanges(0.0, (double)this.getSequence().getSizeX(), 0.0, (double)this.getSequence().getSizeY(), this.getCurrentImage().getChannelMax(0), this.getSequence().getChannelMin(0));
        }

        private void updateVTKLUT() {
            LUT.LUTChannel currentLUT = this.userLUT.getLutChannel(this.getPositionC());
            IcyColorMap map = currentLUT.getColorMap();
            double newMin = currentLUT.getMin() * this.warp.GetScaleFactor();
            double newMax = currentLUT.getMax() * this.warp.GetScaleFactor();
            double[] rgba = new double[4];
            for (int i = 0; i < 256; ++i) {
                rgba[0] = map.red.mapf[i];
                rgba[1] = map.green.mapf[i];
                rgba[2] = map.blue.mapf[i];
                rgba[3] = map.alpha.mapf[i];
                this.vtkLUT.SetTableValue((long)i, rgba);
            }
            this.elevationFilter.SetLowPoint(0.0, 0.0, newMin);
            this.elevationFilter.SetHighPoint(0.0, 0.0, newMax);
        }

        public void shutDown() {
            this.userLUT.removeListener(this.lutListener);
            if (this.getSequence() != null) {
                this.getSequence().removeListener(this.dataListener);
            }
            this.vtkPanel.disposeInternal();
            this.helpBox.close();
            super.shutDown();
        }

        public void customizeToolbar(JToolBar toolBar) {
        }
    }
}

