/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.dlg.cages;

import icy.gui.frame.IcyFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import plugins.fmp.multicafe.MultiCAFE;
import plugins.fmp.multicafe.experiment.Experiment;
import plugins.fmp.multicafe.experiment.cages.Cage;
import plugins.fmp.multicafe.tools.JComponents.CageTableModel;

public class InfosCagesTable
extends JPanel {
    private static final long serialVersionUID = 7599620793495187279L;
    IcyFrame dialogFrame = null;
    private JTable tableView = new JTable();
    private CageTableModel cageTableModel = null;
    private JButton copyButton = new JButton("Copy table");
    private JButton pasteButton = new JButton("Paste");
    private JButton duplicateAllButton = new JButton("Duplicate cell to all");
    private JButton noFliesButton = new JButton("Cage 0/9: no flies");
    private MultiCAFE parent0 = null;
    private List<Cage> cageArrayCopy = null;

    public void initialize(MultiCAFE parent0, List<Cage> cageCopy) {
        this.parent0 = parent0;
        this.cageArrayCopy = cageCopy;
        this.cageTableModel = new CageTableModel(parent0.expListCombo);
        this.tableView.setModel(this.cageTableModel);
        this.tableView.setPreferredScrollableViewportSize(new Dimension(500, 400));
        this.tableView.setFillsViewportHeight(true);
        TableColumnModel columnModel = this.tableView.getColumnModel();
        for (int i = 0; i < 2; ++i) {
            this.setFixedColumnProperties(columnModel.getColumn(i));
        }
        JScrollPane scrollPane = new JScrollPane(this.tableView);
        JPanel topPanel = new JPanel(new GridLayout(2, 1));
        FlowLayout flowLayout = new FlowLayout(0);
        JPanel panel1 = new JPanel(flowLayout);
        panel1.add(this.copyButton);
        panel1.add(this.pasteButton);
        topPanel.add(panel1);
        JPanel panel2 = new JPanel(flowLayout);
        panel2.add(this.duplicateAllButton);
        panel2.add(this.noFliesButton);
        topPanel.add(panel2);
        JPanel tablePanel = new JPanel();
        tablePanel.add(scrollPane);
        this.dialogFrame = new IcyFrame("Cell properties", true, true);
        this.dialogFrame.add((Component)topPanel, (Object)"North");
        this.dialogFrame.add((Component)tablePanel, (Object)"Center");
        this.dialogFrame.pack();
        this.dialogFrame.addToDesktopPane();
        this.dialogFrame.requestFocus();
        this.dialogFrame.center();
        this.dialogFrame.setVisible(true);
        this.defineActionListeners();
        this.pasteButton.setEnabled(this.cageArrayCopy.size() > 0);
    }

    private void defineActionListeners() {
        this.copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((InfosCagesTable)InfosCagesTable.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    InfosCagesTable.this.cageArrayCopy.clear();
                    for (Cage cell : exp.cages.cageList) {
                        InfosCagesTable.this.cageArrayCopy.add(cell);
                    }
                    InfosCagesTable.this.pasteButton.setEnabled(true);
                }
            }
        });
        this.pasteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((InfosCagesTable)InfosCagesTable.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    for (Cage cellFrom : InfosCagesTable.this.cageArrayCopy) {
                        cellFrom.valid = false;
                        for (Cage cellTo : exp.cages.cageList) {
                            if (!cellFrom.cageRoi2D.getName().equals(cellTo.cageRoi2D.getName())) continue;
                            cellFrom.valid = true;
                            cellTo.cageNFlies = cellFrom.cageNFlies;
                            cellTo.cageAge = cellFrom.cageAge;
                            cellTo.cageComment = cellFrom.cageComment;
                            cellTo.cageSex = cellFrom.cageSex;
                            cellTo.cageStrain = cellFrom.cageStrain;
                        }
                    }
                    InfosCagesTable.this.cageTableModel.fireTableDataChanged();
                }
            }
        });
        this.duplicateAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((InfosCagesTable)InfosCagesTable.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    int rowIndex = InfosCagesTable.this.tableView.getSelectedRow();
                    int columnIndex = InfosCagesTable.this.tableView.getSelectedColumn();
                    if (rowIndex >= 0) {
                        Cage cell0 = exp.cages.cageList.get(rowIndex);
                        for (Cage cell : exp.cages.cageList) {
                            if (cell.cageRoi2D.getName().equals(cell0.cageRoi2D.getName())) continue;
                            switch (columnIndex) {
                                case 1: {
                                    cell.cageNFlies = cell0.cageNFlies;
                                    break;
                                }
                                case 2: {
                                    cell.cageStrain = cell0.cageStrain;
                                    break;
                                }
                                case 3: {
                                    cell.cageSex = cell0.cageSex;
                                    break;
                                }
                                case 4: {
                                    cell.cageAge = cell0.cageAge;
                                    break;
                                }
                                case 5: {
                                    cell.cageComment = cell0.cageComment;
                                    break;
                                }
                            }
                        }
                    }
                    InfosCagesTable.this.cageTableModel.fireTableDataChanged();
                }
            }
        });
        this.noFliesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((InfosCagesTable)InfosCagesTable.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    exp.cages.setFirstAndLastCageToZeroFly();
                    InfosCagesTable.this.cageTableModel.fireTableDataChanged();
                }
            }
        });
    }

    void close() {
        this.dialogFrame.close();
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp != null) {
            exp.cages.transferNFliesFromCagesToCapillaries(exp.capillaries.capillariesList);
            this.parent0.paneCapillaries.tabFile.saveCapillaries_file(exp);
        }
    }

    private void setFixedColumnProperties(TableColumn column) {
        column.setResizable(false);
        column.setPreferredWidth(50);
        column.setMaxWidth(50);
        column.setMinWidth(30);
    }
}

