/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.dlg.capillaries;

import icy.gui.frame.IcyFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import plugins.fmp.multicafe.MultiCAFE;
import plugins.fmp.multicafe.experiment.Experiment;
import plugins.fmp.multicafe.experiment.capillaries.Capillary;
import plugins.fmp.multicafe.tools.JComponents.CapillaryTableModel;

public class InfosCapillaryTable
extends JPanel {
    private static final long serialVersionUID = -8611587540329642259L;
    IcyFrame dialogFrame = null;
    private JTable tableView = new JTable();
    private CapillaryTableModel capillaryTableModel = null;
    private JButton copyButton = new JButton("Copy table");
    private JButton pasteButton = new JButton("Paste");
    private JButton duplicateLRButton = new JButton("Duplicate cell to L/R");
    private JButton duplicateCageButton = new JButton("Duplicate cell stim");
    private JButton exchangeLRButton = new JButton("Exchg L/R");
    private JButton duplicateAllButton = new JButton("Duplicate cell to all");
    private JButton getNfliesButton = new JButton("Get n flies from cell");
    private JButton getCageNoButton = new JButton("Set cell n#");
    private JButton noFliesButton = new JButton("Cells 0/9: no flies");
    private MultiCAFE parent0 = null;
    private List<Capillary> capillariesArrayCopy = null;

    public void initialize(MultiCAFE parent0, List<Capillary> capCopy) {
        this.parent0 = parent0;
        this.capillariesArrayCopy = capCopy;
        this.capillaryTableModel = new CapillaryTableModel(parent0.expListCombo);
        this.tableView.setModel(this.capillaryTableModel);
        this.tableView.setSelectionMode(0);
        this.tableView.setPreferredScrollableViewportSize(new Dimension(500, 400));
        this.tableView.setFillsViewportHeight(true);
        TableColumnModel columnModel = this.tableView.getColumnModel();
        DefaultTableCellRenderer centerRenderer = new DefaultTableCellRenderer();
        centerRenderer.setHorizontalAlignment(0);
        for (int i = 0; i < this.capillaryTableModel.getColumnCount(); ++i) {
            TableColumn col = columnModel.getColumn(i);
            if (i < 4) {
                this.setFixedColumnProperties(col);
            }
            col.setCellRenderer(centerRenderer);
        }
        JScrollPane scrollPane = new JScrollPane(this.tableView);
        JPanel topPanel = new JPanel(new GridLayout(2, 1));
        FlowLayout flowLayout = new FlowLayout(0);
        JPanel panel1 = new JPanel(flowLayout);
        panel1.add(this.copyButton);
        panel1.add(this.pasteButton);
        panel1.add(this.duplicateLRButton);
        panel1.add(this.duplicateAllButton);
        panel1.add(this.exchangeLRButton);
        topPanel.add(panel1);
        JPanel panel2 = new JPanel(flowLayout);
        panel2.add(this.getCageNoButton);
        panel2.add(this.getNfliesButton);
        panel2.add(this.noFliesButton);
        panel2.add(this.duplicateCageButton);
        topPanel.add(panel2);
        JPanel tablePanel = new JPanel();
        tablePanel.add(scrollPane);
        this.dialogFrame = new IcyFrame("Capillaries properties", true, true);
        this.dialogFrame.add((Component)topPanel, (Object)"North");
        this.dialogFrame.add((Component)tablePanel, (Object)"Center");
        this.dialogFrame.pack();
        this.dialogFrame.addToDesktopPane();
        this.dialogFrame.requestFocus();
        this.dialogFrame.center();
        this.dialogFrame.setVisible(true);
        this.defineActionListeners();
        this.pasteButton.setEnabled(this.capillariesArrayCopy.size() > 0);
    }

    private void defineActionListeners() {
        this.copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((InfosCapillaryTable)InfosCapillaryTable.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    InfosCapillaryTable.this.copyInfos(exp);
                }
            }
        });
        this.pasteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((InfosCapillaryTable)InfosCapillaryTable.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    InfosCapillaryTable.this.pasteInfos(exp);
                }
                InfosCapillaryTable.this.capillaryTableModel.fireTableDataChanged();
            }
        });
        this.noFliesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((InfosCapillaryTable)InfosCapillaryTable.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    InfosCapillaryTable.this.setFliesNumbers(exp);
                    InfosCapillaryTable.this.capillaryTableModel.fireTableDataChanged();
                }
            }
        });
        this.duplicateLRButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((InfosCapillaryTable)InfosCapillaryTable.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    InfosCapillaryTable.this.duplicateLR(exp);
                }
            }
        });
        this.duplicateCageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((InfosCapillaryTable)InfosCapillaryTable.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    InfosCapillaryTable.this.duplicateCage(exp);
                }
            }
        });
        this.exchangeLRButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((InfosCapillaryTable)InfosCapillaryTable.this).parent0.expListCombo.getSelectedItem();
                if (exp == null || exp.capillaries.capillariesDescription.grouping != 2) {
                    return;
                }
                InfosCapillaryTable.this.exchangeLR(exp);
            }
        });
        this.duplicateAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((InfosCapillaryTable)InfosCapillaryTable.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    InfosCapillaryTable.this.duplicateAll(exp);
                }
            }
        });
        this.getNfliesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((InfosCapillaryTable)InfosCapillaryTable.this).parent0.expListCombo.getSelectedItem();
                if (exp != null && exp.cages.cageList.size() > 0) {
                    exp.cages.transferNFliesFromCagesToCapillaries(exp.capillaries.capillariesList);
                    InfosCapillaryTable.this.capillaryTableModel.fireTableDataChanged();
                }
            }
        });
        this.getCageNoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((InfosCapillaryTable)InfosCapillaryTable.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    exp.cages.setCageNbFromName(exp.capillaries.capillariesList);
                    InfosCapillaryTable.this.capillaryTableModel.fireTableDataChanged();
                }
            }
        });
    }

    void close() {
        this.dialogFrame.close();
    }

    private void setFixedColumnProperties(TableColumn column) {
        column.setResizable(false);
        column.setPreferredWidth(50);
        column.setMaxWidth(50);
        column.setMinWidth(30);
    }

    private void exchangeLR(Experiment exp) {
        int columnIndex = this.tableView.getSelectedColumn();
        if (columnIndex < 0) {
            columnIndex = 5;
        }
        String side0 = exp.capillaries.capillariesList.get(0).getCapillarySide();
        Capillary cap0 = new Capillary();
        this.storeCapillaryValues(exp.capillaries.capillariesList.get(0), cap0);
        Capillary cap1 = new Capillary();
        this.storeCapillaryValues(exp.capillaries.capillariesList.get(1), cap1);
        for (Capillary cap : exp.capillaries.capillariesList) {
            if (cap.getCapillarySide().equals(side0)) {
                this.switchCapillaryValue(cap1, cap, columnIndex);
                continue;
            }
            this.switchCapillaryValue(cap0, cap, columnIndex);
        }
    }

    private void storeCapillaryValues(Capillary sourceCapillary, Capillary destinationCapillary) {
        destinationCapillary.capNFlies = sourceCapillary.capNFlies;
        destinationCapillary.capVolume = sourceCapillary.capVolume;
        destinationCapillary.capStimulus = sourceCapillary.capStimulus;
        destinationCapillary.capConcentration = sourceCapillary.capConcentration;
        destinationCapillary.capSide = sourceCapillary.capSide;
    }

    private void switchCapillaryValue(Capillary sourceCapillary, Capillary destinationCapillary, int columnIndex) {
        switch (columnIndex) {
            case 2: {
                destinationCapillary.capNFlies = sourceCapillary.capNFlies;
                break;
            }
            case 3: {
                destinationCapillary.capVolume = sourceCapillary.capVolume;
                break;
            }
            case 4: {
                destinationCapillary.capStimulus = sourceCapillary.capStimulus;
                break;
            }
            case 5: {
                destinationCapillary.capConcentration = sourceCapillary.capConcentration;
                break;
            }
        }
    }

    private void copyInfos(Experiment exp) {
        this.capillariesArrayCopy.clear();
        for (Capillary cap : exp.capillaries.capillariesList) {
            this.capillariesArrayCopy.add(cap);
        }
        this.pasteButton.setEnabled(true);
    }

    private void pasteInfos(Experiment exp) {
        for (Capillary capFrom : this.capillariesArrayCopy) {
            capFrom.valid = false;
            for (Capillary capTo : exp.capillaries.capillariesList) {
                if (!capFrom.getRoiName().equals(capTo.getRoiName())) continue;
                capFrom.valid = true;
                capTo.capCageID = capFrom.capCageID;
                capTo.capNFlies = capFrom.capNFlies;
                capTo.capVolume = capFrom.capVolume;
                capTo.capStimulus = capFrom.capStimulus;
                capTo.capConcentration = capFrom.capConcentration;
            }
        }
    }

    private void setFliesNumbers(Experiment exp) {
        int ncapillaries = exp.capillaries.capillariesList.size();
        for (int i = 0; i < ncapillaries; ++i) {
            Capillary cap = exp.capillaries.capillariesList.get(i);
            cap.capNFlies = i < 2 || i >= ncapillaries - 2 ? 0 : 1;
        }
    }

    private void duplicateLR(Experiment exp) {
        int rowIndex = this.tableView.getSelectedRow();
        int columnIndex = this.tableView.getSelectedColumn();
        if (rowIndex < 0) {
            return;
        }
        Capillary cap0 = exp.capillaries.capillariesList.get(rowIndex);
        String side = cap0.getCapillarySide();
        int modulo2 = 0;
        modulo2 = side.equals("L") ? 0 : (side.equals("R") ? 1 : Integer.valueOf(cap0.getCapillarySide()) % 2);
        for (Capillary cap : exp.capillaries.capillariesList) {
            block11: {
                if (cap.getKymographName().equals(cap0.getKymographName()) || exp.capillaries.capillariesDescription.grouping == 2 && !cap.getCapillarySide().equals(side)) continue;
                try {
                    int mod = Integer.valueOf(cap.getCapillarySide()) % 2;
                    if (mod != modulo2) {
                    }
                    break block11;
                }
                catch (NumberFormatException nfe) {
                    if (cap.getCapillarySide().equals(side)) break block11;
                }
                continue;
            }
            switch (columnIndex) {
                case 2: {
                    cap.capNFlies = cap0.capNFlies;
                    break;
                }
                case 3: {
                    cap.capVolume = cap0.capVolume;
                    break;
                }
                case 4: {
                    cap.capStimulus = cap0.capStimulus;
                    break;
                }
                case 5: {
                    cap.capConcentration = cap0.capConcentration;
                    break;
                }
            }
        }
    }

    private void duplicateAll(Experiment exp) {
        int rowIndex = this.tableView.getSelectedRow();
        int columnIndex = this.tableView.getSelectedColumn();
        if (rowIndex < 0) {
            return;
        }
        Capillary cap0 = exp.capillaries.capillariesList.get(rowIndex);
        for (Capillary cap : exp.capillaries.capillariesList) {
            if (cap.getKymographName().equals(cap0.getKymographName())) continue;
            switch (columnIndex) {
                case 2: {
                    cap.capNFlies = cap0.capNFlies;
                    break;
                }
                case 3: {
                    cap.capVolume = cap0.capVolume;
                    break;
                }
                case 4: {
                    cap.capStimulus = cap0.capStimulus;
                    break;
                }
                case 5: {
                    cap.capConcentration = cap0.capConcentration;
                    break;
                }
            }
        }
    }

    private void duplicateCage(Experiment exp) {
        int rowIndex = this.tableView.getSelectedRow();
        int columnIndex = this.tableView.getSelectedColumn();
        if (rowIndex < 0) {
            return;
        }
        Capillary capFrom = exp.capillaries.capillariesList.get(rowIndex);
        int cageFrom = capFrom.capCageID;
        int cageTo = -1;
        int nCapillariesPerCage = this.getCageNCapillaries(exp, cageFrom);
        int indexFirstCapillaryOfCageFrom = this.getIndexFirstCapillaryOfCage(exp, cageFrom);
        int indexFirstCapillaryOfCageTo = -1;
        block6: for (int i = 0; i < exp.capillaries.capillariesList.size(); ++i) {
            Capillary cap = exp.capillaries.capillariesList.get(i);
            if (cap.capCageID == cageFrom) continue;
            if (cap.capCageID != cageTo) {
                cageTo = cap.capCageID;
                indexFirstCapillaryOfCageTo = this.getIndexFirstCapillaryOfCage(exp, cageTo);
            }
            if (this.getCageNCapillaries(exp, cap.capCageID) != nCapillariesPerCage) continue;
            int indexFrom = i - indexFirstCapillaryOfCageTo + indexFirstCapillaryOfCageFrom;
            Capillary cap0 = exp.capillaries.capillariesList.get(indexFrom);
            switch (columnIndex) {
                case 2: {
                    cap.capNFlies = cap0.capNFlies;
                    continue block6;
                }
                case 3: {
                    cap.capVolume = cap0.capVolume;
                    continue block6;
                }
                case 4: {
                    cap.capStimulus = cap0.capStimulus;
                    continue block6;
                }
                case 5: {
                    cap.capConcentration = cap0.capConcentration;
                    continue block6;
                }
            }
        }
    }

    private int getCageNCapillaries(Experiment exp, int cageID) {
        int nCapillaries = 0;
        for (Capillary cap : exp.capillaries.capillariesList) {
            if (cap.capCageID != cageID) continue;
            ++nCapillaries;
        }
        return nCapillaries;
    }

    private int getIndexFirstCapillaryOfCage(Experiment exp, int cageID) {
        int index = -1;
        for (int i = 0; i < exp.capillaries.capillariesList.size(); ++i) {
            Capillary cap = exp.capillaries.capillariesList.get(i);
            if (cap.capCageID != cageID) continue;
            index = i;
            break;
        }
        return index;
    }
}

