/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.experiment.capillaries;

import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.type.geom.Polyline2D;
import icy.util.XMLUtil;
import java.awt.Color;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.fmp.multicafe.experiment.capillaries.CapillaryGulps;
import plugins.fmp.multicafe.experiment.capillaries.CapillaryMeasure;
import plugins.fmp.multicafe.experiment.capillaries.EnumCapillaryMeasures;
import plugins.fmp.multicafe.series.BuildSeriesOptions;
import plugins.fmp.multicafe.tools.ROI2D.ROI2DAlongT;
import plugins.fmp.multicafe.tools.ROI2D.ROI2DUtilities;
import plugins.fmp.multicafe.tools.toExcel.EnumXLSColumnHeader;
import plugins.fmp.multicafe.tools.toExcel.EnumXLSExport;
import plugins.kernel.roi.roi2d.ROI2DLine;
import plugins.kernel.roi.roi2d.ROI2DPolyLine;

public class Capillary
implements Comparable<Capillary> {
    private ROI2D roiCap = null;
    private ArrayList<ROI2DAlongT> roisForKymo = new ArrayList();
    private String kymographName = null;
    public int kymographIndex = -1;
    private String kymographPrefix = null;
    public String version = null;
    public String filenameTIFF = null;
    public ArrayList<int[]> cap_Integer = null;
    public String capStimulus = new String("..");
    public String capConcentration = new String("..");
    public String capSide = ".";
    public int capNFlies = 1;
    public int capCageID = 0;
    public double capVolume = 5.0;
    public int capPixels = 5;
    public boolean descriptionOK = false;
    public int versionInfos = 0;
    public BuildSeriesOptions limitsOptions = new BuildSeriesOptions();
    public final String ID_TOPLEVEL = "toplevel";
    public final String ID_BOTTOMLEVEL = "bottomlevel";
    public final String ID_DERIVATIVE = "derivative";
    public CapillaryMeasure ptsTop = new CapillaryMeasure("toplevel");
    public CapillaryMeasure ptsBottom = new CapillaryMeasure("bottomlevel");
    public CapillaryMeasure ptsDerivative = new CapillaryMeasure("derivative");
    public CapillaryGulps ptsGulps = new CapillaryGulps();
    public boolean valid = true;
    private final String ID_META = "metaMC";
    private final String ID_NFLIES = "nflies";
    private final String ID_CAGENB = "cage_number";
    private final String ID_CAPVOLUME = "capillaryVolume";
    private final String ID_CAPPIXELS = "capillaryPixels";
    private final String ID_STIML = "stimulus";
    private final String ID_CONCL = "concentration";
    private final String ID_SIDE = "side";
    private final String ID_DESCOK = "descriptionOK";
    private final String ID_VERSIONINFOS = "versionInfos";
    private final String ID_INTERVALS = "INTERVALS";
    private final String ID_NINTERVALS = "nintervals";
    private final String ID_INTERVAL = "interval_";
    private final String ID_INDEXIMAGE = "indexImageMC";
    private final String ID_NAME = "nameMC";
    private final String ID_NAMETIFF = "filenameTIFF";
    private final String ID_VERSION = "version";
    private final String ID_VERSIONNUM = "1.0.0";

    public Capillary(ROI2D roiCapillary) {
        this.roiCap = roiCapillary;
        this.kymographName = Capillary.replace_LR_with_12(roiCapillary.getName());
    }

    Capillary(String name) {
        this.kymographName = Capillary.replace_LR_with_12(name);
    }

    public Capillary() {
    }

    @Override
    public int compareTo(Capillary o) {
        if (o != null) {
            return this.kymographName.compareTo(o.kymographName);
        }
        return 1;
    }

    public void copy(Capillary cap) {
        this.kymographIndex = cap.kymographIndex;
        this.kymographName = cap.kymographName;
        this.version = cap.version;
        this.roiCap = cap.roiCap != null ? (ROI2D)cap.roiCap.getCopy() : null;
        this.filenameTIFF = cap.filenameTIFF;
        this.capStimulus = cap.capStimulus;
        this.capConcentration = cap.capConcentration;
        this.capSide = cap.capSide;
        this.capNFlies = cap.capNFlies;
        this.capCageID = cap.capCageID;
        this.capVolume = cap.capVolume;
        this.capPixels = cap.capPixels;
        this.limitsOptions = cap.limitsOptions;
        this.ptsGulps.copy(cap.ptsGulps);
        this.ptsTop.copy(cap.ptsTop);
        this.ptsBottom.copy(cap.ptsBottom);
        this.ptsDerivative.copy(cap.ptsDerivative);
    }

    public String getKymographName() {
        return this.kymographName;
    }

    public void setKymographName(String name) {
        this.kymographName = name;
    }

    public ROI2D getRoi() {
        return this.roiCap;
    }

    public void setRoi(ROI2D roi) {
        this.roiCap = roi;
    }

    public void setRoiName(String name) {
        this.roiCap.setName(name);
    }

    public String getRoiName() {
        if (this.roiCap != null) {
            return this.roiCap.getName();
        }
        return null;
    }

    public String getLast2ofCapillaryName() {
        if (this.roiCap == null) {
            return "missing";
        }
        return this.roiCap.getName().substring(this.roiCap.getName().length() - 2);
    }

    public String getRoiNamePrefix() {
        return this.kymographPrefix;
    }

    public String getCapillarySide() {
        return this.roiCap.getName().substring(this.roiCap.getName().length() - 1);
    }

    public static String replace_LR_with_12(String name) {
        String newname = name;
        if (name.contains("R")) {
            newname = name.replace("R", "2");
        } else if (name.contains("L")) {
            newname = name.replace("L", "1");
        }
        return newname;
    }

    public int getCageIndexFromRoiName() {
        String name = this.roiCap.getName();
        if (!name.contains("line")) {
            return -1;
        }
        String stringNumber = name.substring(4, 5);
        return Integer.valueOf(stringNumber);
    }

    public String getSideDescriptor(EnumXLSExport xlsExportOption) {
        String value = null;
        this.capSide = this.getCapillarySide();
        switch (xlsExportOption) {
            case DISTANCE: {
                value = this.capSide + "(DIST)";
                break;
            }
            case ISALIVE: {
                value = this.capSide + "(L=R)";
                break;
            }
            case SUMGULPS_LR: 
            case TOPLEVELDELTA_LR: 
            case TOPLEVEL_LR: {
                if (this.capSide.equals("L")) {
                    value = "sum";
                    break;
                }
                value = "PI";
                break;
            }
            case XYIMAGE: 
            case XYTOPCELL: 
            case XYTIPCAPS: {
                if (this.capSide.equals("L")) {
                    value = "x";
                    break;
                }
                value = "y";
                break;
            }
            default: {
                value = this.capSide;
            }
        }
        return value;
    }

    public String getCapillaryField(EnumXLSColumnHeader fieldEnumCode) {
        String stringValue = null;
        switch (fieldEnumCode) {
            case CAP_STIM: {
                stringValue = this.capStimulus;
                break;
            }
            case CAP_CONC: {
                stringValue = this.capConcentration;
                break;
            }
        }
        return stringValue;
    }

    public void setCapillaryField(EnumXLSColumnHeader fieldEnumCode, String stringValue) {
        switch (fieldEnumCode) {
            case CAP_STIM: {
                this.capStimulus = stringValue;
                break;
            }
            case CAP_CONC: {
                this.capConcentration = stringValue;
                break;
            }
        }
    }

    public boolean isThereAnyMeasuresDone(EnumXLSExport option) {
        boolean yes = false;
        switch (option) {
            case DERIVEDVALUES: {
                yes = this.ptsDerivative.isThereAnyMeasuresDone();
                break;
            }
            case SUMGULPS: {
                yes = this.ptsGulps.isThereAnyMeasuresDone();
                break;
            }
            case BOTTOMLEVEL: {
                yes = this.ptsBottom.isThereAnyMeasuresDone();
                break;
            }
            default: {
                yes = this.ptsTop.isThereAnyMeasuresDone();
            }
        }
        return yes;
    }

    public ArrayList<Integer> getCapillaryMeasuresForXLSPass1(EnumXLSExport option, long seriesBinMs, long outputBinMs) {
        ArrayList<Integer> datai = null;
        switch (option) {
            case DERIVEDVALUES: {
                datai = this.ptsDerivative.getMeasures(seriesBinMs, outputBinMs);
                break;
            }
            case SUMGULPS_LR: 
            case SUMGULPS: 
            case NBGULPS: 
            case AMPLITUDEGULPS: 
            case TTOGULP: 
            case TTOGULP_LR: 
            case AUTOCORREL: 
            case AUTOCORREL_LR: 
            case CROSSCORREL: 
            case CROSSCORREL_LR: {
                if (this.ptsGulps == null) break;
                datai = this.ptsGulps.getMeasuresFromGulps(option, this.ptsTop.getNPoints(), seriesBinMs, outputBinMs);
                break;
            }
            case BOTTOMLEVEL: {
                datai = this.ptsBottom.getMeasures(seriesBinMs, outputBinMs);
                break;
            }
            default: {
                datai = this.ptsTop.getMeasures(seriesBinMs, outputBinMs);
            }
        }
        return datai;
    }

    public void cropMeasuresToNPoints(int npoints) {
        if (this.ptsTop.polylineLevel != null) {
            this.ptsTop.cropToNPoints(npoints);
        }
        if (this.ptsBottom.polylineLevel != null) {
            this.ptsBottom.cropToNPoints(npoints);
        }
        if (this.ptsDerivative.polylineLevel != null) {
            this.ptsDerivative.cropToNPoints(npoints);
        }
    }

    public void restoreClippedMeasures() {
        if (this.ptsTop.polylineLevel != null) {
            this.ptsTop.restoreNPoints();
        }
        if (this.ptsBottom.polylineLevel != null) {
            this.ptsBottom.restoreNPoints();
        }
        if (this.ptsDerivative.polylineLevel != null) {
            this.ptsDerivative.restoreNPoints();
        }
    }

    public void setGulpsOptions(BuildSeriesOptions options) {
        this.limitsOptions = options;
    }

    public BuildSeriesOptions getGulpsOptions() {
        return this.limitsOptions;
    }

    public void initGulps() {
        if (this.ptsGulps == null) {
            this.ptsGulps = new CapillaryGulps();
        }
        if (this.limitsOptions.analyzePartOnly) {
            int searchFromXFirst = (int)this.limitsOptions.searchArea.getX();
            int searchFromXLast = (int)this.limitsOptions.searchArea.getWidth() + searchFromXFirst;
            this.ptsGulps.removeGulpsWithinInterval(searchFromXFirst, searchFromXLast);
        } else {
            this.ptsGulps.gulps.clear();
        }
    }

    public void detectGulps() {
        int indexPixel = 0;
        int firstPixel = 1;
        if (this.ptsTop.polylineLevel == null) {
            return;
        }
        int lastPixel = this.ptsTop.polylineLevel.npoints;
        if (this.limitsOptions.analyzePartOnly) {
            firstPixel = (int)this.limitsOptions.searchArea.getX();
            lastPixel = (int)this.limitsOptions.searchArea.getWidth() + firstPixel;
        }
        int threshold = (int)(this.limitsOptions.detectGulpsThreshold_uL / this.capVolume * (double)this.capPixels);
        ArrayList<Point2D> gulpPoints = new ArrayList<Point2D>();
        int indexLastDetected = -1;
        for (indexPixel = firstPixel; indexPixel < lastPixel; ++indexPixel) {
            int derivativevalue = (int)this.ptsDerivative.polylineLevel.ypoints[indexPixel - 1];
            if (derivativevalue < threshold) continue;
            indexLastDetected = this.addPointMatchingThreshold(indexPixel, gulpPoints, indexLastDetected);
        }
        if (indexLastDetected > 0) {
            this.addNewGulp(gulpPoints);
        }
    }

    private int addPointMatchingThreshold(int indexPixel, ArrayList<Point2D> gulpPoints, int indexLastDetected) {
        if (indexLastDetected > 0 && indexPixel > indexLastDetected) {
            if (gulpPoints.size() == 1) {
                gulpPoints.add(new Point2D.Double(indexLastDetected, this.ptsTop.polylineLevel.ypoints[indexLastDetected]));
            }
            this.addNewGulp(gulpPoints);
            gulpPoints.clear();
            gulpPoints.add(new Point2D.Double(indexPixel - 1, this.ptsTop.polylineLevel.ypoints[indexPixel - 1]));
        }
        gulpPoints.add(new Point2D.Double(indexPixel, this.ptsTop.polylineLevel.ypoints[indexPixel]));
        return indexPixel;
    }

    private void addNewGulp(ArrayList<Point2D> gulpPoints) {
        this.ptsGulps.addNewGulpFromPoints(gulpPoints);
    }

    public int getLastMeasure(EnumXLSExport option) {
        int lastMeasure = 0;
        switch (option) {
            case DERIVEDVALUES: {
                lastMeasure = this.ptsDerivative.getLastMeasure();
                break;
            }
            case SUMGULPS: {
                if (this.ptsGulps == null) break;
                ArrayList<Integer> datai = this.ptsGulps.getCumSumFromGulps(this.ptsTop.getNPoints());
                lastMeasure = (Integer)datai.get(datai.size() - 1);
                break;
            }
            case BOTTOMLEVEL: {
                lastMeasure = this.ptsBottom.getLastMeasure();
                break;
            }
            default: {
                lastMeasure = this.ptsTop.getLastMeasure();
            }
        }
        return lastMeasure;
    }

    public int getLastDeltaMeasure(EnumXLSExport option) {
        int lastMeasure = 0;
        switch (option) {
            case DERIVEDVALUES: {
                lastMeasure = this.ptsDerivative.getLastDeltaMeasure();
                break;
            }
            case SUMGULPS: {
                if (this.ptsGulps == null) break;
                ArrayList<Integer> datai = this.ptsGulps.getCumSumFromGulps(this.ptsTop.getNPoints());
                lastMeasure = (Integer)datai.get(datai.size() - 1) - (Integer)datai.get(datai.size() - 2);
                break;
            }
            case BOTTOMLEVEL: {
                lastMeasure = this.ptsBottom.getLastDeltaMeasure();
                break;
            }
            default: {
                lastMeasure = this.ptsTop.getLastDeltaMeasure();
            }
        }
        return lastMeasure;
    }

    public int getT0Measure(EnumXLSExport option) {
        int t0Measure = 0;
        switch (option) {
            case DERIVEDVALUES: {
                t0Measure = this.ptsDerivative.getT0Measure();
                break;
            }
            case SUMGULPS: {
                if (this.ptsGulps == null) break;
                ArrayList<Integer> datai = this.ptsGulps.getCumSumFromGulps(this.ptsTop.getNPoints());
                t0Measure = (Integer)datai.get(0);
                break;
            }
            case BOTTOMLEVEL: {
                t0Measure = this.ptsBottom.getT0Measure();
                break;
            }
            default: {
                t0Measure = this.ptsTop.getT0Measure();
            }
        }
        return t0Measure;
    }

    public List<ROI2D> transferMeasuresToROIs() {
        ArrayList<ROI2D> listrois = new ArrayList<ROI2D>();
        this.getROIFromCapillaryLevel(this.ptsTop, listrois);
        this.getROIFromCapillaryLevel(this.ptsBottom, listrois);
        this.getROIFromCapillaryLevel(this.ptsDerivative, listrois);
        this.getROIsFromCapillaryGulps(this.ptsGulps, listrois);
        return listrois;
    }

    private void getROIFromCapillaryLevel(CapillaryMeasure capLevel, List<ROI2D> listrois) {
        if (capLevel.polylineLevel == null || capLevel.polylineLevel.npoints == 0) {
            return;
        }
        ROI2DPolyLine roi = new ROI2DPolyLine((Polyline2D)capLevel.polylineLevel);
        String name = this.kymographPrefix + "_" + capLevel.capName;
        roi.setName(name);
        roi.setT(this.kymographIndex);
        if (capLevel.capName.contains("derivative")) {
            roi.setColor(Color.yellow);
            roi.setStroke(1.0);
        }
        listrois.add((ROI2D)roi);
    }

    private void getROIsFromCapillaryGulps(CapillaryGulps capGulps, List<ROI2D> listrois) {
        int ngulps = capGulps.gulps.size();
        if (ngulps == 0) {
            return;
        }
        ArrayList<ROI2D> rois = new ArrayList<ROI2D>(ngulps);
        if (capGulps.gulps.size() > 0) {
            for (Polyline2D gulpLine : capGulps.gulps) {
                ROI2D roi = this.getROIfromGulp(gulpLine);
                if (roi == null) continue;
                rois.add(roi);
            }
        }
        listrois.addAll(rois);
    }

    private ROI2D getROIfromGulp(Polyline2D gulpLine) {
        if (gulpLine.npoints == 0) {
            return null;
        }
        ROI2DPolyLine roi = new ROI2DPolyLine(gulpLine);
        int startAt = (int)gulpLine.xpoints[0];
        String name = this.kymographPrefix + "_gulp_at_" + String.format("%07d", startAt);
        roi.setName(name);
        roi.setColor(Color.red);
        roi.setStroke(1.0);
        roi.setT(this.kymographIndex);
        return roi;
    }

    public void transferROIsToMeasures(List<ROI> listRois) {
        this.ptsTop.transferROIsToMeasures(listRois);
        this.ptsBottom.transferROIsToMeasures(listRois);
        this.ptsGulps.transferROIsToMeasures(listRois);
        this.ptsDerivative.transferROIsToMeasures(listRois);
    }

    public boolean xmlLoad_CapillaryOnly(Node node) {
        boolean flag;
        Element nodeMeta = XMLUtil.getElement((Node)node, (String)"metaMC");
        boolean bl = flag = nodeMeta != null;
        if (flag) {
            this.version = XMLUtil.getElementValue((Node)nodeMeta, (String)"version", (String)"0.0.0");
            this.kymographIndex = XMLUtil.getElementIntValue((Node)nodeMeta, (String)"indexImageMC", (int)this.kymographIndex);
            this.kymographName = XMLUtil.getElementValue((Node)nodeMeta, (String)"nameMC", (String)this.kymographName);
            this.filenameTIFF = XMLUtil.getElementValue((Node)nodeMeta, (String)"filenameTIFF", (String)this.filenameTIFF);
            this.descriptionOK = XMLUtil.getElementBooleanValue((Node)nodeMeta, (String)"descriptionOK", (boolean)false);
            this.versionInfos = XMLUtil.getElementIntValue((Node)nodeMeta, (String)"versionInfos", (int)0);
            this.capNFlies = XMLUtil.getElementIntValue((Node)nodeMeta, (String)"nflies", (int)this.capNFlies);
            this.capCageID = XMLUtil.getElementIntValue((Node)nodeMeta, (String)"cage_number", (int)this.capCageID);
            this.capVolume = XMLUtil.getElementDoubleValue((Node)nodeMeta, (String)"capillaryVolume", (double)Double.NaN);
            this.capPixels = XMLUtil.getElementIntValue((Node)nodeMeta, (String)"capillaryPixels", (int)5);
            this.capStimulus = XMLUtil.getElementValue((Node)nodeMeta, (String)"stimulus", (String)"stimulus");
            this.capConcentration = XMLUtil.getElementValue((Node)nodeMeta, (String)"concentration", (String)"concentration");
            this.capSide = XMLUtil.getElementValue((Node)nodeMeta, (String)"side", (String)".");
            this.roiCap = ROI2DUtilities.loadFromXML_ROI(nodeMeta);
            this.limitsOptions.loadFromXML(nodeMeta);
            this.xmlLoad_Intervals(node);
        }
        return flag;
    }

    private boolean xmlLoad_Intervals(Node node) {
        this.roisForKymo.clear();
        Element nodeMeta2 = XMLUtil.getElement((Node)node, (String)"INTERVALS");
        if (nodeMeta2 == null) {
            return false;
        }
        int nitems = XMLUtil.getElementIntValue((Node)nodeMeta2, (String)"nintervals", (int)0);
        if (nitems > 0) {
            for (int i = 0; i < nitems; ++i) {
                Element node_i = XMLUtil.setElement((Node)nodeMeta2, (String)("interval_" + i));
                ROI2DAlongT roiInterval = new ROI2DAlongT();
                roiInterval.loadFromXML(node_i);
                this.roisForKymo.add(roiInterval);
                if (i != 0) continue;
                this.roiCap = this.roisForKymo.get(0).getRoi();
            }
        }
        return true;
    }

    public boolean xmlLoad_MeasuresOnly(Node node) {
        String header = this.getLast2ofCapillaryName() + "_";
        boolean result = this.ptsTop.loadCapillaryLimitFromXML(node, "toplevel", header) > 0;
        result |= this.ptsBottom.loadCapillaryLimitFromXML(node, "bottomlevel", header) > 0;
        result |= this.ptsDerivative.loadCapillaryLimitFromXML(node, "derivative", header) > 0;
        return result |= this.ptsGulps.loadGulpsFromXML(node);
    }

    public boolean xmlSave_CapillaryOnly(Node node) {
        Element nodeMeta = XMLUtil.setElement((Node)node, (String)"metaMC");
        if (nodeMeta == null) {
            return false;
        }
        if (this.version == null) {
            this.version = "1.0.0";
        }
        XMLUtil.setElementValue((Node)nodeMeta, (String)"version", (String)this.version);
        XMLUtil.setElementIntValue((Node)nodeMeta, (String)"indexImageMC", (int)this.kymographIndex);
        XMLUtil.setElementValue((Node)nodeMeta, (String)"nameMC", (String)this.kymographName);
        if (this.filenameTIFF != null) {
            String filename = Paths.get(this.filenameTIFF, new String[0]).getFileName().toString();
            XMLUtil.setElementValue((Node)nodeMeta, (String)"filenameTIFF", (String)filename);
        }
        XMLUtil.setElementBooleanValue((Node)nodeMeta, (String)"descriptionOK", (boolean)this.descriptionOK);
        XMLUtil.setElementIntValue((Node)nodeMeta, (String)"versionInfos", (int)this.versionInfos);
        XMLUtil.setElementIntValue((Node)nodeMeta, (String)"nflies", (int)this.capNFlies);
        XMLUtil.setElementIntValue((Node)nodeMeta, (String)"cage_number", (int)this.capCageID);
        XMLUtil.setElementDoubleValue((Node)nodeMeta, (String)"capillaryVolume", (double)this.capVolume);
        XMLUtil.setElementIntValue((Node)nodeMeta, (String)"capillaryPixels", (int)this.capPixels);
        XMLUtil.setElementValue((Node)nodeMeta, (String)"stimulus", (String)this.capStimulus);
        XMLUtil.setElementValue((Node)nodeMeta, (String)"side", (String)this.capSide);
        XMLUtil.setElementValue((Node)nodeMeta, (String)"concentration", (String)this.capConcentration);
        ROI2DUtilities.saveToXML_ROI(nodeMeta, this.roiCap);
        boolean flag = this.xmlSave_Intervals(node);
        return flag;
    }

    private boolean xmlSave_Intervals(Node node) {
        Element nodeMeta2 = XMLUtil.setElement((Node)node, (String)"INTERVALS");
        if (nodeMeta2 == null) {
            return false;
        }
        int nitems = this.roisForKymo.size();
        XMLUtil.setElementIntValue((Node)nodeMeta2, (String)"nintervals", (int)nitems);
        if (nitems > 0) {
            for (int i = 0; i < nitems; ++i) {
                Element node_i = XMLUtil.setElement((Node)nodeMeta2, (String)("interval_" + i));
                this.roisForKymo.get(i).saveToXML(node_i);
            }
        }
        return true;
    }

    public Point2D getCapillaryTipWithinROI2D(ROI2D roi2D) {
        Point2D pt = null;
        if (this.roiCap instanceof ROI2DPolyLine) {
            Polyline2D line = ((ROI2DPolyLine)this.roiCap).getPolyline2D();
            int last = line.npoints - 1;
            if (roi2D.contains(line.xpoints[0], line.ypoints[0])) {
                pt = new Point2D.Double(line.xpoints[0], line.ypoints[0]);
            } else if (roi2D.contains(line.xpoints[last], line.ypoints[last])) {
                pt = new Point2D.Double(line.xpoints[last], line.ypoints[last]);
            }
        } else if (this.roiCap instanceof ROI2DLine) {
            Line2D line = ((ROI2DLine)this.roiCap).getLine();
            if (roi2D.contains(line.getP1())) {
                pt = line.getP1();
            } else if (roi2D.contains(line.getP2())) {
                pt = line.getP2();
            }
        }
        return pt;
    }

    public Point2D getCapillaryROILowestPoint() {
        Point2D pt = null;
        if (this.roiCap instanceof ROI2DPolyLine) {
            Polyline2D line = ((ROI2DPolyLine)this.roiCap).getPolyline2D();
            int last = line.npoints - 1;
            pt = line.ypoints[0] > line.ypoints[last] ? new Point2D.Double(line.xpoints[0], line.ypoints[0]) : new Point2D.Double(line.xpoints[last], line.ypoints[last]);
        } else if (this.roiCap instanceof ROI2DLine) {
            Line2D line = ((ROI2DLine)this.roiCap).getLine();
            pt = line.getP1().getY() > line.getP2().getY() ? line.getP1() : line.getP2();
        }
        return pt;
    }

    public Point2D getCapillaryROIFirstPoint() {
        Point2D pt = null;
        if (this.roiCap instanceof ROI2DPolyLine) {
            Polyline2D line = ((ROI2DPolyLine)this.roiCap).getPolyline2D();
            pt = new Point2D.Double(line.xpoints[0], line.ypoints[0]);
        } else if (this.roiCap instanceof ROI2DLine) {
            Line2D line = ((ROI2DLine)this.roiCap).getLine();
            pt = line.getP1();
        }
        return pt;
    }

    public Point2D getCapillaryROILastPoint() {
        Point2D pt = null;
        if (this.roiCap instanceof ROI2DPolyLine) {
            Polyline2D line = ((ROI2DPolyLine)this.roiCap).getPolyline2D();
            int last = line.npoints - 1;
            pt = new Point2D.Double(line.xpoints[last], line.ypoints[last]);
        } else if (this.roiCap instanceof ROI2DLine) {
            Line2D line = ((ROI2DLine)this.roiCap).getLine();
            pt = line.getP2();
        }
        return pt;
    }

    public int getCapillaryROILength() {
        Point2D pt1 = this.getCapillaryROIFirstPoint();
        Point2D pt2 = this.getCapillaryROILastPoint();
        double npixels = Math.sqrt((pt2.getY() - pt1.getY()) * (pt2.getY() - pt1.getY()) + (pt2.getX() - pt1.getX()) * (pt2.getX() - pt1.getX()));
        return (int)npixels;
    }

    public void adjustToImageWidth(int imageWidth) {
        this.ptsTop.adjustToImageWidth(imageWidth);
        this.ptsBottom.adjustToImageWidth(imageWidth);
        this.ptsDerivative.adjustToImageWidth(imageWidth);
        this.ptsGulps.gulps.clear();
    }

    public void cropToImageWidth(int imageWidth) {
        this.ptsTop.cropToImageWidth(imageWidth);
        this.ptsBottom.cropToImageWidth(imageWidth);
        this.ptsDerivative.cropToImageWidth(imageWidth);
        this.ptsGulps.gulps.clear();
    }

    public List<ROI2DAlongT> getROIsForKymo() {
        if (this.roisForKymo.size() < 1) {
            this.initROI2DForKymoList();
        }
        return this.roisForKymo;
    }

    public ROI2DAlongT getROI2DKymoAt(int i) {
        if (this.roisForKymo.size() < 1) {
            this.initROI2DForKymoList();
        }
        return this.roisForKymo.get(i);
    }

    public ROI2DAlongT getROI2DKymoAtIntervalT(long t) {
        if (this.roisForKymo.size() < 1) {
            this.initROI2DForKymoList();
        }
        ROI2DAlongT capRoi = null;
        for (ROI2DAlongT item : this.roisForKymo) {
            if (t < item.getStart()) break;
            capRoi = item;
        }
        return capRoi;
    }

    public void removeROI2DIntervalStartingAt(long start) {
        ROI2DAlongT itemFound = null;
        for (ROI2DAlongT item : this.roisForKymo) {
            if (start != item.getStart()) continue;
            itemFound = item;
        }
        if (itemFound != null) {
            this.roisForKymo.remove(itemFound);
        }
    }

    private void initROI2DForKymoList() {
        this.roisForKymo.add(new ROI2DAlongT(0L, this.roiCap));
    }

    public void setVolumeAndPixels(double volume, int pixels) {
        this.capVolume = volume;
        this.capPixels = pixels;
        this.descriptionOK = true;
    }

    public String csvExport_CapillarySubSectionHeader(String sep) {
        StringBuffer sbf = new StringBuffer();
        sbf.append("#" + sep + "CAPILLARIES" + sep + "describe each capillary\n");
        List<String> row2 = Arrays.asList("cap_prefix", "kymoIndex", "kymographName", "kymoFile", "cap_cage", "cap_nflies", "cap_volume", "cap_npixel", "cap_stim", "cap_conc", "cap_side");
        sbf.append(String.join((CharSequence)sep, row2));
        sbf.append("\n");
        return sbf.toString();
    }

    public String csvExport_CapillaryDescription(String sep) {
        StringBuffer sbf = new StringBuffer();
        if (this.kymographPrefix == null) {
            this.kymographPrefix = this.getLast2ofCapillaryName();
        }
        List<String> row = Arrays.asList(this.kymographPrefix, Integer.toString(this.kymographIndex), this.kymographName, this.filenameTIFF, Integer.toString(this.capCageID), Integer.toString(this.capNFlies), Double.toString(this.capVolume), Integer.toString(this.capPixels), this.capStimulus, this.capConcentration, this.capSide);
        sbf.append(String.join((CharSequence)sep, row));
        sbf.append("\n");
        return sbf.toString();
    }

    public String csvExport_MeasureSectionHeader(EnumCapillaryMeasures measureType, String sep) {
        StringBuffer sbf = new StringBuffer();
        String explanation1 = "columns=" + sep + "name" + sep + "index" + sep + "npts" + sep + "yi\n";
        String explanation2 = "columns=" + sep + "name" + sep + "index" + sep + " n_gulps(i)" + sep + " ..." + sep + " gulp_i" + sep + " .npts(j)" + sep + "." + sep + "(xij" + sep + "yij))\n";
        switch (measureType) {
            case TOPLEVEL: {
                sbf.append("#" + sep + "TOPLEVEL" + sep + explanation1);
                break;
            }
            case BOTTOMLEVEL: {
                sbf.append("#" + sep + "BOTTOMLEVEL" + sep + explanation1);
                break;
            }
            case TOPDERIVATIVE: {
                sbf.append("#" + sep + "TOPDERIVATIVE" + sep + explanation1);
                break;
            }
            case GULPS: {
                sbf.append("#" + sep + "GULPS" + sep + explanation2);
                break;
            }
            default: {
                sbf.append("#" + sep + "UNDEFINED------------\n");
            }
        }
        return sbf.toString();
    }

    public String csvExport_MeasuresOneType(EnumCapillaryMeasures measureType, String sep) {
        StringBuffer sbf = new StringBuffer();
        sbf.append(this.kymographPrefix + sep + this.kymographIndex + sep);
        switch (measureType) {
            case TOPLEVEL: {
                this.ptsTop.cvsExportYDataToRow(sbf, sep);
                break;
            }
            case BOTTOMLEVEL: {
                this.ptsBottom.cvsExportYDataToRow(sbf, sep);
                break;
            }
            case TOPDERIVATIVE: {
                this.ptsDerivative.cvsExportYDataToRow(sbf, sep);
                break;
            }
            case GULPS: {
                this.ptsGulps.csvExportDataToRow(sbf, sep);
                break;
            }
        }
        sbf.append("\n");
        return sbf.toString();
    }

    public void csvImport_CapillaryDescription(String[] data) {
        int i = 0;
        this.kymographPrefix = data[i];
        this.kymographIndex = Integer.valueOf(data[++i]);
        this.kymographName = data[++i];
        this.filenameTIFF = data[++i];
        this.capCageID = Integer.valueOf(data[++i]);
        this.capNFlies = Integer.valueOf(data[++i]);
        this.capVolume = Double.valueOf(data[++i]);
        this.capPixels = Integer.valueOf(data[++i]);
        this.capStimulus = data[++i];
        this.capConcentration = data[++i];
        this.capSide = data[++i];
    }

    public void csvImport_CapillaryData(EnumCapillaryMeasures measureType, String[] data, boolean x, boolean y) {
        switch (measureType) {
            case TOPLEVEL: {
                if (x && y) {
                    this.ptsTop.csvImportXYDataFromRow(data, 2);
                    break;
                }
                if (x || !y) break;
                this.ptsTop.csvImportYDataFromRow(data, 2);
                break;
            }
            case BOTTOMLEVEL: {
                if (x && y) {
                    this.ptsBottom.csvImportXYDataFromRow(data, 2);
                    break;
                }
                if (x || !y) break;
                this.ptsBottom.csvImportYDataFromRow(data, 2);
                break;
            }
            case TOPDERIVATIVE: {
                if (x && y) {
                    this.ptsDerivative.csvImportXYDataFromRow(data, 2);
                    break;
                }
                if (x || !y) break;
                this.ptsDerivative.csvImportYDataFromRow(data, 2);
                break;
            }
            case GULPS: {
                this.ptsGulps.csvImportDataFromRow(data, 2);
                break;
            }
        }
    }
}

