/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.series;

import java.util.ArrayList;
import plugins.fmp.multicafe.experiment.Experiment;
import plugins.fmp.multicafe.experiment.SequenceKymos;
import plugins.fmp.multicafe.experiment.capillaries.Capillary;
import plugins.fmp.multicafe.series.BuildSeries;

public class ClipCageMeasuresToSmallest
extends BuildSeries {
    @Override
    void analyzeExperiment(Experiment exp) {
        exp.xmlLoad_MCExperiment();
        exp.loadMCCapillaries();
        if (exp.loadKymographs()) {
            SequenceKymos seqKymos = exp.seqKymos;
            ArrayList<Integer> listCageID = new ArrayList<Integer>(seqKymos.nTotalFrames);
            for (int t = 0; t < seqKymos.nTotalFrames; ++t) {
                Capillary tcap = exp.capillaries.capillariesList.get(t);
                int tcage = tcap.capCageID;
                if (this.findCageID(tcage, listCageID)) continue;
                listCageID.add(tcage);
                int minLength = this.findMinLength(exp, t, tcage);
                for (int tt = t; tt < seqKymos.nTotalFrames; ++tt) {
                    Capillary ttcap = exp.capillaries.capillariesList.get(tt);
                    int ttcage = ttcap.capCageID;
                    if (ttcage != tcage || ttcap.ptsTop.polylineLevel.npoints <= minLength) continue;
                    ttcap.cropMeasuresToNPoints(minLength);
                }
            }
            exp.saveCapillaries();
        }
        exp.seqCamData.closeSequence();
        exp.seqKymos.closeSequence();
    }

    boolean findCageID(int cageID, ArrayList<Integer> listCageID) {
        boolean found = false;
        for (int iID : listCageID) {
            if (iID != cageID) continue;
            found = true;
            break;
        }
        return found;
    }

    private int findMinLength(Experiment exp, int t, int tCell) {
        Capillary tcap = exp.capillaries.capillariesList.get(t);
        int minLength = tcap.ptsTop.polylineLevel.npoints;
        for (int tt = t; tt < exp.capillaries.capillariesList.size(); ++tt) {
            int dataLength;
            Capillary ttcap = exp.capillaries.capillariesList.get(tt);
            int ttCell = ttcap.capCageID;
            if (ttCell != tCell || (dataLength = ttcap.ptsTop.polylineLevel.npoints) >= minLength) continue;
            minLength = dataLength;
        }
        return minLength;
    }
}

