/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.series;

import icy.gui.frame.progress.ProgressFrame;
import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageUtil;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.List;
import plugins.fmp.multicafe.experiment.Experiment;
import plugins.fmp.multicafe.series.BuildSeries;
import plugins.fmp.multicafe.series.FlyDetectTools;
import plugins.fmp.multicafe.tools.ImageTransform.ImageTransformEnums;
import plugins.fmp.multicafe.tools.ImageTransform.ImageTransformInterface;
import plugins.fmp.multicafe.tools.ImageTransform.ImageTransformOptions;

public class FlyDetect2
extends BuildSeries {
    private FlyDetectTools find_flies = new FlyDetectTools();
    public boolean viewInternalImages = true;

    @Override
    void analyzeExperiment(Experiment exp) {
        if (!this.loadDrosoTrack(exp)) {
            return;
        }
        if (!this.checkBoundsForCages(exp)) {
            return;
        }
        this.runFlyDetect2(exp);
        exp.cages.orderFlyPositions();
        if (!this.stopFlag) {
            exp.saveCageMeasures();
        }
        exp.seqCamData.closeSequence();
        this.closeSequence(this.seqNegative);
    }

    private void runFlyDetect2(Experiment exp) {
        exp.cleanPreviousDetectedFliesROIs();
        this.find_flies.initParametersForDetection(exp, this.options);
        exp.cages.initFlyPositions(this.options.detectCage);
        this.options.threshold = this.options.thresholdDiff;
        if (exp.loadReferenceImage()) {
            this.openFlyDetectViewers(exp);
            this.findFliesInAllFrames(exp);
        }
    }

    private void findFliesInAllFrames(Experiment exp) {
        ProgressFrame progressBar = new ProgressFrame("Detecting flies...");
        ImageTransformOptions transformOptions = new ImageTransformOptions();
        transformOptions.transformOption = ImageTransformEnums.SUBTRACT_REF;
        transformOptions.backgroundImage = IcyBufferedImageUtil.getCopy((IcyBufferedImage)exp.seqCamData.refImage);
        ImageTransformInterface transformFunction = transformOptions.transformOption.getFunction();
        int totalFrames = exp.seqCamData.nTotalFrames;
        for (int index = 0; index < totalFrames; ++index) {
            int t_from = index;
            String title = "Frame #" + t_from + "/" + exp.seqCamData.nTotalFrames;
            progressBar.setMessage(title);
            IcyBufferedImage workImage = this.imageIORead(exp.seqCamData.getFileNameFromImageList(t_from));
            IcyBufferedImage negativeImage = transformFunction.getTransformedImage(workImage, transformOptions);
            try {
                this.seqNegative.beginUpdate();
                this.seqNegative.setImage(0, 0, (BufferedImage)negativeImage);
                this.vNegative.setTitle(title);
                List<Rectangle2D> listRectangles = this.find_flies.findFlies(negativeImage, t_from);
                this.displayRectanglesAsROIs(this.seqNegative, listRectangles, true);
                this.seqNegative.endUpdate();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        progressBar.close();
    }
}

